/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.jobs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.embedcdt.internal.packs.core.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.Utils;
import org.eclipse.embedcdt.packs.core.data.PacksStorage;
import org.eclipse.embedcdt.packs.core.data.cmsis.PdscParserFull;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.eclipse.embedcdt.packs.core.tree.PackNode;
import org.xml.sax.SAXParseException;

public class ParsePdscRunnable
implements ICoreRunnable {
    private static boolean fgRunning = false;
    private IConsoleStream fgOut = Activator.getInstance().getConsoleOutput();
    private PackNode fgVersionNode;

    public ParsePdscRunnable(String name, PackNode versionNode) {
        this.fgVersionNode = versionNode;
    }

    public void run(IProgressMonitor monitor) {
        IPath folderPath;
        try {
            folderPath = PacksStorage.getFolderPath();
        }
        catch (IOException e1) {
            return;
        }
        if (fgRunning) {
            return;
        }
        fgRunning = true;
        long beginTime = System.currentTimeMillis();
        this.fgOut.println();
        this.fgOut.println(Utils.getCurrentDateTime());
        String destFolder = this.fgVersionNode.getProperty("dest.folder");
        String pdscName = this.fgVersionNode.getProperty("pdsc.name");
        IPath path = folderPath.append(destFolder).append(pdscName);
        this.fgOut.println("Parsing \"" + path.toOSString() + "\"...");
        Node outlineNode = null;
        try {
            PdscParserFull pdsc = new PdscParserFull();
            pdsc.parseXml(path);
            outlineNode = pdsc.parsePdscFull();
            outlineNode.putProperty("dest.folder", destFolder);
            this.fgVersionNode.setOutline(outlineNode);
            PackNode packNode = (PackNode)this.fgVersionNode.getParent();
            if (packNode.getFirstChild().getName().equals(this.fgVersionNode.getName())) {
                packNode.setOutline(outlineNode);
            }
            pdsc.parseExamples(this.fgVersionNode);
        }
        catch (FileNotFoundException e) {
            this.fgOut.println("Failed: " + e.toString());
        }
        catch (SAXParseException e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + path.toString() + ", line: " + e.getLineNumber() + ", column: " + e.getColumnNumber();
            Activator.log((Throwable)e);
            this.fgOut.println("Failed: " + msg);
        }
        catch (Exception e) {
            Activator.log((Throwable)e);
            this.fgOut.println("Failed: " + e.toString());
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - beginTime;
        if (duration == 0L) {
            duration = 1L;
        }
        this.fgOut.println("Parse completed in " + duration + "ms.");
        fgRunning = false;
    }
}

