/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.jumper.preferences;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.debug.gdbjtag.jumper.Activator;

public class DefaultPreferences
extends ilg.gnumcueclipse.debug.gdbjtag.preferences.DefaultPreferences {
    public static final boolean SERVER_DO_START_DEFAULT = true;
    public static final boolean DO_START_GDB_SERVER_DEFAULT = true;
    public static final String SERVER_EXECUTABLE_DEFAULT = "${jumper_path}/${jumper_executable}";
    protected static final String CLIENT_EXECUTABLE_DEFAULT = "${cross_prefix}gdb${cross_suffix}";
    public static final String JUMPER_BOARD_NAME_DEFAULT = "nrf52832";
    public static final String JUMPER_DEVICE_NAME_DEFAULT = "";
    public static final int SERVER_GDB_PORT_NUMBER_DEFAULT = 5555;
    public static final String SERVER_OTHER_OPTIONS_DEFAULT = "--uart";
    public static final boolean DO_GDB_SERVER_ALLOCATE_CONSOLE_DEFAULT = true;
    public static final boolean JUMPER_IS_VERBOSE_DEFAULT = false;
    public static final String CLIENT_OTHER_OPTIONS_DEFAULT = "";
    public static final String CLIENT_COMMANDS_DEFAULT = "set mem inaccessible-by-default off\n";
    public static final boolean USE_REMOTE_TARGET_DEFAULT = true;
    public static final String REMOTE_IP_ADDRESS_LOCALHOST = "localhost";
    public static final String REMOTE_IP_ADDRESS_DEFAULT = "localhost";
    public static final int REMOTE_PORT_NUMBER_DEFAULT = 5555;
    public static final boolean DO_INITIAL_RESET_DEFAULT = false;
    public static final String DO_INITIAL_RESET_COMMAND = "monitor system_reset ";
    public static final String HALT_COMMAND = "";
    public static final boolean ENABLE_SEMIHOSTING_DEFAULT = true;
    public static final String ENABLE_SEMIHOSTING_OPTION = "-semihosting-config enable=on,target=native";
    public static final String INIT_OTHER_DEFAULT = "";
    public static final boolean DO_DEBUG_IN_RAM_DEFAULT = false;
    public static final boolean DO_PRERUN_RESET_DEFAULT = false;
    public static final String DO_PRERUN_RESET_COMMAND = "monitor system_reset ";
    public static final boolean DO_STOP_AT_DEFAULT = true;
    public static final String STOP_AT_NAME_DEFAULT = "main";
    public static final String PRERUN_OTHER_DEFAULT = "";
    public static final boolean DO_CONTINUE_DEFAULT = true;
    public static final String DO_CONTINUE_COMMAND = "continue";

    public DefaultPreferences(String pluginId) {
        super(pluginId);
    }

    public String getGdbServerExecutable() {
        return this.getString("gdb.server.executable", SERVER_EXECUTABLE_DEFAULT);
    }

    public String getGdbClientExecutable() {
        return this.getString("gdb.client.executable", CLIENT_EXECUTABLE_DEFAULT);
    }

    public String getExecutableName() {
        String key = "executable.name";
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.DefaultPreferences.getExecutableName()=\"" + value + "\"");
        }
        return value;
    }

    public String getExecutableNameOs() {
        String key = EclipseUtils.getKeyOs((String)"executable.name.%s");
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.DefaultPreferences.getExecutableNameOs()=\"" + value + "\" (" + key + ")");
        }
        return value;
    }

    public void putExecutableName(String value) {
        String key = "executable.name";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.DefaultPreferences.putExecutableName(\"" + value + "\")");
        }
        this.putString(key, value);
    }

    public String getInstallFolder() {
        String key = "install.folder";
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.DefaultPreferences.getInstallFolder() = \"" + value + "\"");
        }
        return value;
    }

    public void putInstallFolder(String value) {
        String key = "install.folder";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.DefaultPreferences.putInstallFolder(\"" + value + "\")");
        }
        this.putString(key, value);
    }

    public String getSearchPath() {
        String key = "search.path";
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.DefaultPreferences.getSearchPath()=\"" + value + "\"");
        }
        return value;
    }

    public String getSearchPathOs() {
        String key = EclipseUtils.getKeyOs((String)"search.path.%s");
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.DefaultPreferences.getSearchPathOs()=\"" + value + "\" (" + key + ")");
        }
        return value;
    }

    public void putSearchPath(String value) {
        String key = "search.path";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jumper.DefaultPreferences.putSearchPath(\"" + value + "\")");
        }
        this.putString(key, value);
    }

    public boolean getJumperEnableSemihosting() {
        return this.getBoolean("gdb.jumper.enableSemihosting", true);
    }

    public boolean getTabMainCheckProgram() {
        return this.getBoolean("tab.main.checkProgram", false);
    }

    public boolean getGdbServerDoStart() {
        return this.getBoolean("gdb.server.doStart", true);
    }

    public String getGdbServerOtherOptions() {
        return this.getString("gdb.server.other", SERVER_OTHER_OPTIONS_DEFAULT);
    }

    public String getGdbClientOtherOptions() {
        return this.getString("gdb.client.other", "");
    }

    public String getGdbClientCommands() {
        return this.getString("gdb.client.commands", CLIENT_COMMANDS_DEFAULT);
    }

    public boolean getJumperDebugInRam() {
        return this.getBoolean("gdb.jumper.doDebugInRam", false);
    }

    public boolean getJumperDoInitialReset() {
        return this.getBoolean("gdb.jumper.doInitialReset", false);
    }

    public String getJumperInitOther() {
        return this.getString("gdb.jumper.init.other", "");
    }

    public boolean getJumperDoPreRunReset() {
        return this.getBoolean("gdb.jumper.doPreRunReset", false);
    }

    public String getJumperPreRunOther() {
        return this.getString("gdb.jumper.preRun.other", "");
    }
}

