/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.managedbuild.cross.arm;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.managedbuild.cross.arm.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ToolchainDefinition
extends ilg.gnumcueclipse.managedbuild.cross.ToolchainDefinition {
    public static final String XPACK_ARM_GCC = "xPack GNU Arm Embedded GCC";
    public static final String GME_ARM_GCC = "GNU MCU Eclipse ARM Embedded GCC";
    public static final String GNU_TOOLS_FOR_ARM_EMBEDDED = "GNU Tools for ARM Embedded Processors";
    public static final String DEFAULT_TOOLCHAIN_NAME = "xPack GNU Arm Embedded GCC";
    protected static List<ToolchainDefinition> fgList = new ArrayList<ToolchainDefinition>();
    protected static String[] fArchitectures = new String[]{"ARM (AArch32)", "ARM64 (AArch64)"};
    private static final String CUSTOM_TOOLCHAINS_EXT_POTNT_ID = "ilg.gnumcueclipse.managedbuild.cross.arm.toolchains";

    static {
        ToolchainDefinition.addToolchain(new ToolchainDefinition("xPack GNU Arm Embedded GCC", "arm-none-eabi-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition(GME_ARM_GCC, "arm-none-eabi-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition(GNU_TOOLS_FOR_ARM_EMBEDDED, "arm-none-eabi-"));
        ToolchainDefinition tc = new ToolchainDefinition("Sourcery CodeBench Lite for ARM EABI", "arm-none-eabi-");
        if (EclipseUtils.isWindows()) {
            tc.setWin("cs-make", "cs-rm");
        }
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Sourcery CodeBench Lite for ARM GNU/Linux", "arm-none-linux-gnueabi-");
        if (EclipseUtils.isWindows()) {
            tc.setWin("cs-make", "cs-rm");
        }
        ToolchainDefinition.addToolchain(tc);
        ToolchainDefinition.addToolchain(new ToolchainDefinition("devkitPro ARM EABI", "arm-eabi-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition("Yagarto, Summon, etc. ARM EABI", "arm-none-eabi-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition("Linaro ARMv7 bare-metal EABI", "arm-none-eabi-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition("Linaro ARMv7 big-endian bare-metal EABI", "armeb-none-eabi-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition("Linaro ARMv7 Linux GNU EABI HF", "arm-linux-gnueabihf-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition("Linaro ARMv7 big-endian Linux GNU EABI HF", "armeb-linux-gnueabihf-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition("Linaro AArch64 bare-metal ELF", "aarch64-elf-", "aarch64"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition("Linaro AArch64 big-endian bare-metal ELF", "aarch64_be-elf-", "aarch64"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition("Linaro AArch64 Linux GNU", "aarch64-linux-gnu-", "aarch64"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition("Linaro AArch64 big-endian Linux GNU", "aarch64_be-linux-gnu-", "aarch64"));
        ToolchainDefinition.addExtensionsToolchains(CUSTOM_TOOLCHAINS_EXT_POTNT_ID);
    }

    public ToolchainDefinition(String sName) {
        super(sName);
        this.fArchitecture = "arm";
    }

    public ToolchainDefinition(String sName, String sPrefix) {
        this(sName);
        this.fPrefix = sPrefix;
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture) {
        this(sName, sPrefix);
        this.fArchitecture = sArchitecture;
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture, String cmdMake, String cmdRm) {
        this(sName, sPrefix, sArchitecture);
        this.fCmdMake = cmdMake;
        this.fCmdRm = cmdRm;
    }

    public static List<ToolchainDefinition> getList() {
        return fgList;
    }

    public static ToolchainDefinition getToolchain(int index) {
        return fgList.get(index);
    }

    public static ToolchainDefinition getToolchain(String index) {
        return fgList.get(Integer.parseInt(index));
    }

    public static int getSize() {
        return fgList.size();
    }

    public static void addToolchain(ToolchainDefinition toolchain) {
        fgList.add(toolchain);
    }

    public static int findToolchainByName(String sName) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            if (td.fName.equals(sName)) {
                return i;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    public static int findToolchainByFullName(String sName) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            String sFullName = td.getFullName();
            if (sFullName.equals(sName)) {
                return i;
            }
            ++i;
        }
        return ToolchainDefinition.getDefault();
    }

    public static int getDefault() {
        return 0;
    }

    public static String[] getArchitectures() {
        return fArchitectures;
    }

    public static String getArchitecture(int index) {
        return fArchitectures[index];
    }

    private static void addExtensionsToolchains(String extensionPointId) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getAttribute("name");
            try {
                ToolchainDefinition.findToolchainByName(name);
                Activator.log((String)("Duplicate toolchain name '" + name + "', ignored."));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                String cmdRm;
                String cmdMake;
                String architecture;
                String suffix;
                ToolchainDefinition td = new ToolchainDefinition(name);
                String prefix = element.getAttribute("prefix");
                if (prefix != null && !prefix.isEmpty()) {
                    td.setPrefix(prefix);
                }
                if ((suffix = element.getAttribute("suffix")) != null && !suffix.isEmpty()) {
                    td.setSuffix(suffix);
                }
                if ((architecture = element.getAttribute("architecture")) != null && !architecture.isEmpty()) {
                    td.setArchitecture(architecture);
                }
                if ((cmdMake = element.getAttribute("make_cmd")) != null && !cmdMake.isEmpty()) {
                    td.setCmdMake(cmdMake);
                }
                if ((cmdRm = element.getAttribute("remove_cmd")) != null && !cmdRm.isEmpty()) {
                    td.setCmdRm(cmdRm);
                }
                fgList.add(td);
            }
            ++n2;
        }
    }
}

