/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.core.StringUtils;
import ilg.gnumcueclipse.debug.gdbjtag.Activator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.debug.internal.core.DebugStringVariableSubstitutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.internal.core.envvar.EnvVarCollector;
import org.eclipse.cdt.internal.core.envvar.EnvVarDescriptor;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.IEnvironmentContextInfo;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;

public class DebugUtils {
    public static String[] getLaunchEnvironment(ILaunchConfiguration config) throws CoreException {
        ICdtVariable[] build_vars;
        IEnvironmentVariable[] vars;
        ICConfigurationDescription cfg = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)config);
        if (cfg == null) {
            return DebugUtils.getLaunchEnvironmentWithoutProject();
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        IEnvironmentVariable[] iEnvironmentVariableArray = vars = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(cfg, true);
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            envMap.put(var.getName(), var.getValue());
            ++n2;
        }
        ICdtVariable[] iCdtVariableArray = build_vars = CCorePlugin.getDefault().getCdtVariableManager().getVariables(cfg);
        int n3 = build_vars.length;
        n = 0;
        while (n < n3) {
            ICdtVariable var = iCdtVariableArray[n];
            try {
                if (!"project_classpath".equals(var.getName())) {
                    envMap.put(var.getName(), var.getStringValue());
                }
            }
            catch (CdtVariableException cdtVariableException) {}
            ++n;
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry entry : envMap.entrySet()) {
            StringBuffer buffer = new StringBuffer((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String[] getLaunchEnvironmentWithoutProject() throws CoreException {
        String[] retVal = null;
        IEnvironmentContextInfo contextInfo = EnvironmentVariableManager.getDefault().getContextInfo(null);
        EnvVarCollector envVarMergedCollection = EnvironmentVariableManager.getVariables((IEnvironmentContextInfo)contextInfo, (boolean)true);
        if (envVarMergedCollection != null) {
            EnvVarDescriptor[] envVars = envVarMergedCollection.toArray(false);
            if (envVars != null) {
                ArrayList<String> strings = new ArrayList<String>();
                int i = 0;
                while (i < envVars.length) {
                    IEnvironmentVariable resolved = EnvironmentVariableManager.getDefault().calculateResolvedVariable(envVars[i], contextInfo);
                    if (resolved != null && !"project_classpath".equals(resolved.getName())) {
                        StringBuffer buffer = new StringBuffer(resolved.getName());
                        buffer.append('=').append(resolved.getValue());
                        strings.add(buffer.toString());
                    }
                    ++i;
                }
                retVal = strings.toArray(new String[strings.size()]);
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag", "Error retrieving workspace environment."));
        }
        return retVal;
    }

    public static File getProjectOsPath(String projectName) {
        IPath path = null;
        if (projectName.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(projectName);
            path = project.getLocation();
        }
        File dir = new File(path.toOSString());
        return dir;
    }

    public static File getProjectOsDir(ILaunchConfiguration configuration) throws CoreException {
        IPath path = DebugUtils.getProjectOsPath(configuration);
        File dir = null;
        if (path != null) {
            dir = new File(path.toOSString());
        }
        return dir;
    }

    public static IPath getProjectOsPath(ILaunchConfiguration configuration) throws CoreException {
        IPath path = null;
        if (configuration != null) {
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (projectName.length() > 0) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(projectName);
                path = project.getLocation();
            } else {
                String executableName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                path = new Path(executableName).removeLastSegments(1);
            }
        }
        return path;
    }

    public static IPath getGDBPath(ILaunchConfiguration configuration) {
        String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
        Path retVal = new Path(defaultGdbCommand);
        try {
            String gdb = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            gdb = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(gdb, false);
            ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
            if (buildConfig != null) {
                gdb = DebugUtils.resolveAll(gdb, buildConfig);
            }
            retVal = new Path(gdb);
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
        return retVal;
    }

    public static String resolveAll(String value, ICConfigurationDescription cfgDescription) {
        try {
            ICdtVariableManager manager = CCorePlugin.getDefault().getCdtVariableManager();
            value = manager.resolveValue(value, "", " ", cfgDescription);
        }
        catch (CdtVariableException cdtVariableException) {}
        try {
            DebugStringVariableSubstitutor substitutor = new DebugStringVariableSubstitutor(cfgDescription.getProjectDescription().getProject());
            value = substitutor.performStringSubstitution(value);
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static String resolveAll(String value, Map<String, Object> attributes) {
        try {
            value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value, false).trim();
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static void addMultiLine(String multiLine, List<String> commandsList) {
        if (!multiLine.isEmpty()) {
            String[] commandsStr;
            String[] stringArray = commandsStr = multiLine.split("\\r?\\n");
            int n = commandsStr.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if ((str = str.trim()).length() > 0) {
                    commandsList.add(str);
                }
                ++n2;
            }
        }
    }

    public static String escapeWhitespaces(String path) {
        String[] segments = (path = path.trim()).split("\\s");
        if (segments.length > 1) {
            if (EclipseUtils.isWindows()) {
                return "\"" + path + "\"";
            }
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("\\ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    public static String getGDBVersion(ILaunchConfiguration configuration, String gdbClientCommand) throws CoreException {
        Process process;
        String[] cmdArray = new String[]{gdbClientCommand, "--version"};
        try {
            process = ProcessFactory.getFactory().exec(cmdArray, DebugUtils.getLaunchEnvironment(configuration));
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag", 5012, "Error while launching command: " + StringUtils.join((String[])cmdArray, (String)" "), e.getCause()));
        }
        Job timeoutJob = new Job("GDB version timeout job"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor arg) {
                process.destroy();
                return Status.OK_STATUS;
            }
        };
        timeoutJob.schedule(10000L);
        InputStream stream = null;
        StringBuilder cmdOutput = new StringBuilder(200);
        try {
            try {
                String line;
                stream = process.getInputStream();
                InputStreamReader r = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(r);
                while ((line = reader.readLine()) != null) {
                    cmdOutput.append(line);
                    cmdOutput.append('\n');
                }
            }
            catch (IOException e) {
                throw new DebugException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag", 5012, "Error reading GDB STDOUT after sending: " + StringUtils.join((String[])cmdArray, (String)" ") + ", response: " + cmdOutput, e.getCause()));
            }
        }
        catch (Throwable throwable) {
            timeoutJob.cancel();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            process.destroy();
            throw throwable;
        }
        timeoutJob.cancel();
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        process.destroy();
        String gdbVersion = LaunchUtils.getGDBVersionFromText((String)cmdOutput.toString());
        if (gdbVersion == null || gdbVersion.isEmpty()) {
            throw new DebugException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag", 5012, "Could not determine GDB version after sending: " + StringUtils.join((String[])cmdArray, (String)" ") + ", response: " + cmdOutput, null));
        }
        return gdbVersion;
    }

    public static boolean isLaunchConfigurationStarted(ILaunchConfiguration configuration) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (!launch.isTerminated() && launch.getLaunchConfiguration() != null && configuration.getName().equals(launch.getLaunchConfiguration().getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void checkLaunchConfigurationStarted(ILaunchConfiguration configuration) throws CoreException {
        if (DebugUtils.isLaunchConfigurationStarted(configuration)) {
            throw new CoreException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag", "Debug session '" + configuration.getName() + "' already started. Terminate the first one before restarting."));
        }
    }

    public static Process exec(String[] commandLineArray, String[] environ, File dir) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("exec " + StringUtils.join((String[])commandLineArray, (String)" "));
            if (dir != null) {
                System.out.println("dir " + dir);
            }
        }
        Activator.log((String)StringUtils.join((String[])commandLineArray, (String)" "));
        Process proc = null;
        try {
            proc = ProcessFactory.getFactory().exec(commandLineArray, environ, dir);
        }
        catch (IOException e) {
            String message = "Launching command [" + StringUtils.join((String[])commandLineArray, (String)" ") + "] failed.";
            throw new CoreException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag", -1, message, (Throwable)e));
        }
        return proc;
    }

    public static Process exec(String commandLine, String[] environ) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("exec " + commandLine);
        }
        Activator.log((String)commandLine);
        Process proc = null;
        try {
            proc = ProcessFactory.getFactory().exec(commandLine, environ);
        }
        catch (IOException e) {
            String message = "Launching command [" + commandLine + "] failed.";
            throw new CoreException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag", -1, message, (Throwable)e));
        }
        return proc;
    }

    public static IPath getGdbWorkingDirectory(ILaunchConfiguration launchConfiguration) throws CoreException {
        ICProject cp;
        String expandedLocation;
        Object path = null;
        String location = launchConfiguration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            path = new Path(expandedLocation);
        }
        if (path != null) {
            if (path.isAbsolute()) {
                File dir = new File(path.toPortableString());
                if (!dir.isDirectory()) {
                    path = null;
                }
            } else {
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                path = res instanceof IContainer && res.exists() ? res.getLocation() : null;
            }
        }
        if (path == null && (cp = LaunchUtils.getCProject((ILaunchConfiguration)launchConfiguration)) != null) {
            IProject p = cp.getProject();
            path = p.getLocation();
        }
        if (path == null) {
            path = DebugUtils.getProjectOsPath(launchConfiguration);
        }
        return path;
    }

    public static void queueCommands(List<String> commands, RequestMonitor rm, IGDBControl control, DsfExecutor executor) {
        if (commands != null && !commands.isEmpty()) {
            CountingRequestMonitor crm = new CountingRequestMonitor((Executor)executor, rm);
            crm.setDoneCount(commands.size());
            Iterator<String> it = commands.iterator();
            while (it.hasNext()) {
                String s = it.next().trim();
                if (s.isEmpty() || s.startsWith("#")) {
                    crm.done();
                    continue;
                }
                control.queueCommand((ICommand)new CLICommand((IDMContext)control.getContext(), s), new DataRequestMonitor((Executor)executor, (RequestMonitor)crm));
            }
        } else {
            rm.done();
        }
    }

    public static int compareVersions(String v1, String v2) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        String[] v1Parts = v1.split("\\.");
        String[] v2Parts = v2.split("\\.");
        int i = 0;
        while (i < v1Parts.length && i < v2Parts.length) {
            int v2PartValue;
            int v1PartValue;
            block16: {
                try {
                    v1PartValue = Integer.parseInt(v1Parts[i]);
                    v2PartValue = Integer.parseInt(v2Parts[i]);
                    if (v1PartValue <= v2PartValue) break block16;
                    return 1;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (v1PartValue < v2PartValue) {
                return -1;
            }
            ++i;
        }
        if (v1Parts.length < v2Parts.length) {
            i = v1Parts.length;
            while (i < v2Parts.length) {
                try {
                    if (Integer.parseInt(v2Parts[i]) != 0) {
                        return -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
        }
        if (v1Parts.length > v2Parts.length) {
            i = v2Parts.length;
            while (i < v1Parts.length) {
                try {
                    if (Integer.parseInt(v1Parts[i]) != 0) {
                        return 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
        }
        return 0;
    }
}

