/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.packs.core.jstree;

import ilg.gnumcueclipse.packs.core.jstree.JsNode;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsObject
extends JsNode {
    private Map<String, Object> fProperties = new LinkedHashMap<String, Object>();
    private ArrayList<JsNode> fChildren = new ArrayList();

    public Map<String, Object> getProperties() {
        return this.fProperties;
    }

    @Override
    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    @Override
    public Collection<JsNode> getChildren() {
        return this.fChildren;
    }

    @Override
    public JsNode getFirstChild() {
        assert (!this.fChildren.isEmpty());
        return this.fChildren.get(0);
    }

    @Override
    protected JsNode getNextSibling(JsNode node) {
        int index = this.fChildren.indexOf(node);
        assert (index >= 0);
        if (++index >= this.fChildren.size()) {
            return null;
        }
        return this.fChildren.get(index);
    }

    public String putProperty(String name, String value) {
        assert (value != null);
        Object prevValue = this.fProperties.put(name, value = value.trim());
        if (prevValue instanceof String) {
            return (String)prevValue;
        }
        return null;
    }

    public JsNode putProperty(String name, JsNode value) {
        assert (value.getParent() == null);
        value.setParent(this);
        value.setPropertyName(name);
        this.fChildren.add(value);
        Object prevValue = this.fProperties.put(name, value);
        if (prevValue instanceof JsNode) {
            return (JsNode)prevValue;
        }
        return null;
    }

    public Object putProperty(String name, Object value) {
        if (value instanceof String) {
            return this.putProperty(name, (String)value);
        }
        if (value instanceof JsNode) {
            return this.putProperty(name, (JsNode)value);
        }
        assert (false) : "Unsupported property value type " + value.getClass().getName();
        return null;
    }

    public String putNonEmptyProperty(String name, String value) {
        if (value != null && value.trim().length() > 0) {
            return this.putProperty(name, value);
        }
        return null;
    }

    public boolean hasProperty(String name) {
        return this.fProperties.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.fProperties.get(name);
    }

    public String getProperty(String name, String defaultValue) {
        Object property = this.fProperties.get(name);
        if (property != null && property instanceof String) {
            return (String)property;
        }
        return defaultValue;
    }

    public Object removeProperty(String name) {
        Object value = this.fProperties.remove(name);
        if (value != null && value instanceof JsNode) {
            JsNode node = (JsNode)value;
            node.setParent(null);
            this.fChildren.remove(node);
        }
        return value;
    }

    public String toString() {
        String str = "{ ";
        boolean first = true;
        String pName = this.getPropertyName();
        if (pName != null) {
            str = String.valueOf(str) + "\"$this\":\"" + pName + "\"";
            first = false;
        }
        for (String key : this.fProperties.keySet()) {
            if (first) {
                first = false;
            } else {
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + "\"" + key + "\":";
            Object value = this.fProperties.get(key);
            str = value instanceof String ? String.valueOf(str) + "\"" + value + "\"" : String.valueOf(str) + "<" + value.getClass().getSimpleName() + ">";
        }
        str = String.valueOf(str) + " }";
        return str;
    }

    @Override
    public void serialize(OutputStream o) throws IOException {
        String str = "{";
        boolean first = true;
        for (String key : this.fProperties.keySet()) {
            if (first) {
                first = false;
            } else {
                str = String.valueOf(str) + ",";
            }
            str = String.valueOf(str) + "\"" + key + "\":";
            Object value = this.fProperties.get(key);
            if (value instanceof String) {
                str = String.valueOf(str) + "\"" + value + "\"";
                o.write(str.getBytes());
                str = "";
                continue;
            }
            if (!(value instanceof JsNode)) continue;
            o.write(str.getBytes());
            str = "";
            ((JsNode)value).serialize(o);
        }
        str = String.valueOf(str) + "}";
        o.write(str.getBytes());
    }
}

