/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.packs.core.data;

import ilg.gnumcueclipse.packs.core.Activator;
import ilg.gnumcueclipse.packs.core.data.IAvailableSupport;
import ilg.gnumcueclipse.packs.core.data.IPacksDataManager;
import ilg.gnumcueclipse.packs.core.data.IPacksDataManagerFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public class PacksDataManagerFactoryProxy
implements IPacksDataManagerFactory,
IAvailableSupport {
    private static final String FACTORY_ELEMENT = "factory";
    private static final String CLASS_ATTRIBUTE = "class";
    private static PacksDataManagerFactoryProxy fgInstance;
    private IPacksDataManager fDataManager = null;

    public static PacksDataManagerFactoryProxy getInstance() {
        if (fgInstance == null) {
            fgInstance = new PacksDataManagerFactoryProxy();
        }
        return fgInstance;
    }

    @Override
    public IPacksDataManager createDataManager() {
        IExtension[] extensions;
        if (this.fDataManager != null) {
            return this.fDataManager;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DataManagerFactoryProxy.createDataManager()");
        }
        if ((extensions = Platform.getExtensionRegistry().getExtensionPoint("ilg.gnumcueclipse.packs.core", "data").getExtensions()).length != 1) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("no single core.data xp");
            }
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        IConfigurationElement configElement = configElements[0];
        if (!FACTORY_ELEMENT.equals(configElement.getName())) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("no <factory> element");
            }
            return null;
        }
        try {
            Object obj = configElement.createExecutableExtension(CLASS_ATTRIBUTE);
            if (obj instanceof IPacksDataManagerFactory) {
                IPacksDataManagerFactory factory = (IPacksDataManagerFactory)obj;
                this.fDataManager = factory.createDataManager();
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("DataManagerFactoryProxy.createDataManager() completed");
                }
                return this.fDataManager;
            }
            return null;
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
            return null;
        }
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public void dispose() {
    }
}

