/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.managedbuild.packs.ui;

import ilg.gnumcueclipse.core.CProjectPacksStorage;
import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.core.JsonUtils;
import ilg.gnumcueclipse.core.StringUtils;
import ilg.gnumcueclipse.managedbuild.packs.Activator;
import ilg.gnumcueclipse.managedbuild.packs.ui.Messages;
import ilg.gnumcueclipse.packs.core.data.IPacksDataManager;
import ilg.gnumcueclipse.packs.core.data.PacksDataManagerFactoryProxy;
import ilg.gnumcueclipse.packs.core.tree.Leaf;
import ilg.gnumcueclipse.packs.core.tree.Node;
import ilg.gnumcueclipse.packs.core.tree.NodeViewContentProvider;
import ilg.gnumcueclipse.packs.data.DataManager;
import ilg.gnumcueclipse.packs.xcdl.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class TabDevices
extends AbstractCBuildPropertyTab {
    private static final int AUTOEXPAND_LEVEL = 2;
    private TreeViewer fDevicesTree;
    private Label fArchitectureLabel;
    private Label fDeviceLabel;
    private Table fMemoryTable;
    private Button fMemoryEditButton;
    private IPacksDataManager fDataManager;
    private Leaf fSelectedDeviceNode;
    private Leaf fSelectedBoardDeviceNode;
    private IConfiguration fConfig = null;

    public void createControls(Composite parent) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Devices.createControls()");
        }
        if (!this.page.isForProject()) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("Devices.not this project");
            }
            return;
        }
        super.createControls(parent);
        this.fConfig = this.getCfg();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Devices.createControls() fConfig=" + this.fConfig);
        }
        this.fDataManager = PacksDataManagerFactoryProxy.getInstance().createDataManager();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.usercomp.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        this.usercomp.setLayoutData((Object)gridData);
        this.createDeviceGroup(this.usercomp);
        this.createMemoryGroup(this.usercomp);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Devices.createControls() completed");
        }
    }

    private void createDeviceGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.DevicesTab_DeviceGroup_name);
        Composite treeComposite = new Composite((Composite)group, 0);
        this.fDevicesTree = new TreeViewer(treeComposite, 2052);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 200;
        gridData.horizontalSpan = 2;
        treeComposite.setLayoutData((Object)gridData);
        Tree tree = this.fDevicesTree.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumnLayout layout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)layout);
        TreeColumn nameColumn = new TreeColumn(tree, 0);
        nameColumn.setText("  Name");
        layout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnPixelData(200));
        TreeColumn descriptionColumn = new TreeColumn(tree, 0);
        descriptionColumn.setAlignment(16384);
        descriptionColumn.setText(" Details");
        layout.setColumnData((Widget)descriptionColumn, (ColumnLayoutData)new ColumnPixelData(450));
        DevicesContentProvider contentProvider = new DevicesContentProvider();
        this.fDevicesTree.setContentProvider((IContentProvider)contentProvider);
        this.fDevicesTree.setLabelProvider((IBaseLabelProvider)new DevicesLabelProvider());
        this.fDevicesTree.setComparator((ViewerComparator)new DevicesViewerComparator());
        this.fDevicesTree.setAutoExpandLevel(2);
        this.fDevicesTree.setInput((Object)this.getDevicesTree(this.fConfig));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.DevicesTab_DeviceGroup_architecture_label);
        this.fArchitectureLabel = new Label((Composite)group, 0);
        this.fArchitectureLabel.setText("-");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.fArchitectureLabel.setLayoutData((Object)gridData);
        this.fDevicesTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TabDevices.this.devicesTreeSelectionChanged(event);
            }
        });
    }

    private void createMemoryGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.DevicesTab_MemoryGroup_name);
        this.fDeviceLabel = new Label((Composite)group, 0);
        this.fDeviceLabel.setText("-");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.fDeviceLabel.setLayoutData((Object)gridData);
        this.fMemoryTable = new Table((Composite)group, 67588);
        this.fMemoryTable.setHeaderVisible(true);
        this.fMemoryTable.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 62;
        this.fMemoryTable.setLayoutData((Object)gridData);
        TableColumn columnSection = new TableColumn(this.fMemoryTable, 0);
        columnSection.setText("Section");
        columnSection.setWidth(80);
        columnSection.setResizable(true);
        columnSection.setToolTipText(Messages.DevicesTab_MemoryGroup_nameColumn_toolTipText);
        TableColumn columnStart = new TableColumn(this.fMemoryTable, 0);
        columnStart.setText("Start");
        columnStart.setWidth(100);
        columnStart.setResizable(true);
        columnStart.setToolTipText(Messages.DevicesTab_MemoryGroup_startColumn_toolTipText);
        TableColumn columnSize = new TableColumn(this.fMemoryTable, 0);
        columnSize.setText("Size");
        columnSize.setWidth(100);
        columnSize.setResizable(true);
        columnSize.setToolTipText(Messages.DevicesTab_MemoryGroup_sizeColumn_toolTipText);
        TableColumn columnStartup = new TableColumn(this.fMemoryTable, 0);
        columnStartup.setText("Startup");
        columnStartup.setWidth(55);
        columnStartup.setResizable(true);
        columnStartup.setToolTipText(Messages.DevicesTab_MemoryGroup_startupColumn_toolTipText);
        this.fMemoryEditButton = new Button((Composite)group, 0);
        this.fMemoryEditButton.setText(Messages.DevicesTab_MemoryGroup_editButton_text);
        this.fMemoryEditButton.setEnabled(false);
    }

    private void devicesTreeSelectionChanged(SelectionChangedEvent event) {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Devices.devicesTreeSelectionChanged() " + selection);
        }
        if (!((element = selection.getFirstElement()) instanceof Node)) {
            return;
        }
        Node node = (Node)element;
        if (!node.isType("device")) {
            this.fDevicesTree.setSelection((ISelection)StructuredSelection.EMPTY);
            return;
        }
        this.fSelectedDeviceNode = null;
        this.fSelectedBoardDeviceNode = null;
        if (node.getParent().isType("board")) {
            this.fSelectedDeviceNode = this.findBoardDevice(node);
            if (this.fSelectedDeviceNode == null) {
                this.fDevicesTree.setSelection((ISelection)StructuredSelection.EMPTY);
                return;
            }
            this.fSelectedBoardDeviceNode = node;
        } else {
            this.fSelectedDeviceNode = node;
        }
        Map<String, String[]> map = this.collectMemoryMap(this.fSelectedDeviceNode);
        this.updateMemoryTableContent(map);
        String arch = DataManager.collectProperty((Leaf)this.fSelectedDeviceNode, (String)"core", (String)"devices");
        this.fArchitectureLabel.setText(arch);
        if (this.fSelectedDeviceNode != null) {
            this.fDeviceLabel.setText(this.fSelectedDeviceNode.getName());
        }
    }

    private Leaf findBoardDevice(Node boardDevice) {
        String packType = boardDevice.getProperty("pack.type", "cmsis");
        String deviceVendorId = boardDevice.getProperty("vendor.id");
        String deviceName = "xpack.xcdl".equals(packType) ? boardDevice.getProperty("$KEY") : boardDevice.getName();
        return this.fDataManager.findInstalledDevice(packType, deviceVendorId, deviceName, null);
    }

    private Map<String, String[]> collectMemoryMap(Leaf node) {
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        if (node != null) {
            do {
                if (!node.hasChildren()) continue;
                for (Leaf child : ((Node)node).getChildren()) {
                    String[] line;
                    if (!child.isType("memory")) continue;
                    String key = child.getName();
                    if (map.containsKey(key)) {
                        line = (String[])map.get(key);
                    } else {
                        line = new String[]{"", "", "", "", ""};
                        line[0] = key;
                        map.put(key, line);
                    }
                    if (line[1].length() == 0) {
                        line[1] = child.getProperty("start");
                    }
                    if (line[2].length() == 0) {
                        line[2] = child.getProperty("size");
                    }
                    if (line[3].length() != 0) continue;
                    line[3] = child.getProperty("startup");
                }
            } while ((node = node.getParent()) != null);
        }
        for (String[] line : map.values()) {
            int i = 3;
            while (i < line.length) {
                if (line[i].length() == 0) {
                    line[i] = "0";
                }
                ++i;
            }
        }
        return map;
    }

    private void updateMemoryTableContent(Map<String, String[]> map) {
        this.fMemoryTable.removeAll();
        if (map != null) {
            for (String key : map.keySet()) {
                String[] line = map.get(key);
                TableItem item = new TableItem(this.fMemoryTable, 0);
                item.setText(line);
            }
        }
    }

    public void updateData(ICResourceDescription cfgd) {
        IConfiguration config;
        if (cfgd == null) {
            return;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Devices.updateData() " + this.getCfg().getName());
        }
        if ((config = TabDevices.getCfg((ICConfigurationDescription)cfgd.getConfiguration())) instanceof MultiConfiguration) {
            MultiConfiguration multi = (MultiConfiguration)config;
            config = (IConfiguration)multi.getItems()[0];
        }
        this.updateControlsForConfig(config);
        this.fDevicesTree.setInput((Object)this.getDevicesTree(config));
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Devices.performApply() " + src.getName() + " -> " + dst.getName());
        }
        if (this.page.isForProject()) {
            IConfiguration cfg1 = TabDevices.getCfg((ICConfigurationDescription)src.getConfiguration());
            IConfiguration cfg2 = TabDevices.getCfg((ICConfigurationDescription)dst.getConfiguration());
            this.updateStorage(cfg1);
            this.updateStorage(cfg2);
        }
    }

    protected void performOK() {
        IConfiguration config = this.getCfg();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Devices.performOK() " + config.getName());
        }
        this.updateStorage(config);
    }

    private void updateControlsForConfig(IConfiguration config) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Devices.updateControlsForConfig() " + config.getName());
        }
        this.fConfig = config;
        boolean mustUpdate = false;
        if (config instanceof Configuration) {
            try {
                Leaf device;
                Leaf board;
                CProjectPacksStorage st = new CProjectPacksStorage(config);
                String packType = st.getOption("pack.type");
                String deviceId = "";
                String coreName = "";
                String boardId = "";
                String boardSupplierName = "";
                String boardSupplierId = "";
                String deviceSupplierId = "";
                if (packType == null || "cmsis".equals(packType)) {
                    packType = "cmsis";
                    deviceId = st.getOption("cmsis.device.name", "");
                    deviceSupplierId = st.getOption("cmsis.device.vendor.id", "");
                    coreName = st.getOption("cmsis.core.name", "");
                    boardId = st.getOption("cmsis.board.name", "");
                    boardSupplierName = st.getOption("cmsis.board.vendor.name", "");
                } else if ("xpack.xcdl".equals(packType)) {
                    deviceId = st.getOption("device.id", "");
                    deviceSupplierId = st.getOption("device.vendor.id", "");
                    coreName = st.getOption("core.arch", "");
                    boardId = st.getOption("board.id", "");
                    boardSupplierName = st.getOption("board.vendor.name", "");
                    boardSupplierId = st.getOption("board.vendor.id", "");
                } else {
                    System.out.println("Unsupported pack type.");
                }
                IProject project = EclipseUtils.getProjectFromConfiguration((IConfiguration)config);
                if (project != null) {
                    try {
                        JSONObject packageJson = Utils.getPackageJson((IProject)project);
                        packType = "xpack.xcdl";
                        if (deviceId.isEmpty()) {
                            deviceId = (String)JsonUtils.get((JSONObject)packageJson, (String)"config.xcdl.device.id", (Object)"");
                            mustUpdate = true;
                        }
                        if (deviceSupplierId.isEmpty()) {
                            deviceSupplierId = (String)JsonUtils.get((JSONObject)packageJson, (String)"config.xcdl.device.supplier.id", (Object)"");
                            mustUpdate = true;
                        }
                        if (boardId.isEmpty()) {
                            boardId = (String)JsonUtils.get((JSONObject)packageJson, (String)"config.xcdl.board.id", (Object)"");
                            mustUpdate = true;
                        }
                        if (boardSupplierId.isEmpty()) {
                            boardSupplierId = (String)JsonUtils.get((JSONObject)packageJson, (String)"config.xcdl.board.supplier.id", (Object)"");
                            mustUpdate = true;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException e) {
                        Activator.log((Throwable)e);
                    }
                    catch (ParseException e) {
                        Activator.log((Throwable)e);
                    }
                }
                boolean wasSelected = false;
                if (!(boardId.isEmpty() || boardSupplierId.isEmpty() && boardSupplierName.isEmpty() || deviceId.isEmpty() || deviceSupplierId.isEmpty() || (board = this.fDataManager.findInstalledBoard(packType, boardSupplierId, boardSupplierName, boardId, config)) == null || !board.hasChildren())) {
                    for (Leaf child : ((Node)board).getChildren()) {
                        String name = "xpack.xcdl".equals(packType) ? child.getProperty("$KEY") : child.getName();
                        if (!child.isType("device") || !deviceId.equals(name) || !deviceSupplierId.equals(child.getProperty("vendor.id"))) continue;
                        this.fDevicesTree.reveal((Object)child);
                        this.fDevicesTree.setSelection((ISelection)new StructuredSelection((Object)child), true);
                        wasSelected = true;
                        break;
                    }
                }
                if (!(wasSelected || deviceId.isEmpty() || deviceSupplierId.isEmpty() || (device = this.fDataManager.findInstalledDevice(packType, deviceSupplierId, deviceId, config)) == null)) {
                    this.fDevicesTree.setSelection((ISelection)new StructuredSelection((Object)device), true);
                    wasSelected = true;
                }
                if (!deviceId.isEmpty()) {
                    this.fDeviceLabel.setText(deviceId);
                }
                if (!coreName.isEmpty()) {
                    this.fArchitectureLabel.setText(coreName);
                }
                if (mustUpdate) {
                    this.updateStorage(config);
                }
                this.fSelectedDeviceNode = null;
                this.fSelectedBoardDeviceNode = null;
                this.updateMemoryTableContent(st.getMemoryMap());
            }
            catch (CoreException coreException) {}
        }
    }

    private void updateStorage(IConfiguration config) {
        if (this.fSelectedDeviceNode == null) {
            return;
        }
        if (config instanceof MultiConfiguration) {
            MultiConfiguration multi = (MultiConfiguration)config;
            Object[] objectArray = multi.getItems();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                IConfiguration cfg = (IConfiguration)obj;
                this.updateStorage(cfg);
                ++n2;
            }
            return;
        }
        if (config instanceof Configuration) {
            try {
                CProjectPacksStorage st = new CProjectPacksStorage(config);
                st.clear();
                String packType = null;
                Leaf node = this.fSelectedDeviceNode;
                while (node != null) {
                    if (node.isType("device")) {
                        packType = node.getProperty("pack.type", "cmsis");
                        if ("cmsis".equals(packType)) {
                            st.setOption("cmsis.device.name", node.getName());
                        } else if ("xpack.xcdl".equals(packType)) {
                            st.setOption("pack.type", packType);
                            st.setOption("device.id", node.getProperty("$KEY"));
                            st.setOption("device.compiler.defines", node.getProperty("compilerDefines"));
                            st.setOption("device.compiler.headers", node.getProperty("compilerHeaders"));
                        }
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("Devices.updateStorage() device.name=" + node.getName());
                        }
                    } else if (node.isType("subfamily")) {
                        if ("cmsis".equals(packType)) {
                            st.setOption("cmsis.subfamily.name", node.getName());
                        } else if ("xpack.xcdl".equals(packType)) {
                            st.setOption("subfamily.key", node.getProperty("$KEY"));
                        }
                    } else if (node.isType("family")) {
                        if ("cmsis".equals(packType)) {
                            st.setOption("cmsis.family.name", node.getName());
                            st.setOption("cmsis.device.vendor.name", node.getProperty("vendor.name"));
                            st.setOption("cmsis.device.vendor.id", node.getProperty("vendor.id"));
                            st.setOption("cmsis.device.pack.vendor", node.getProperty("pack.vendor"));
                            st.setOption("cmsis.device.pack.name", node.getProperty("pack.name"));
                            st.setOption("cmsis.device.pack.version", node.getProperty("pack.version"));
                        } else if ("xpack.xcdl".equals(packType)) {
                            st.setOption("family.id", node.getProperty("$KEY"));
                            st.setOption("device.vendor.name", node.getProperty("vendor.name"));
                            st.setOption("device.vendor.id", node.getProperty("vendor.id"));
                            st.setOption("device.pack.name", node.getProperty("pack.name"));
                            st.setOption("device.pack.version", node.getProperty("pack.version"));
                        }
                    }
                    node = node.getParent();
                }
                if (this.fSelectedBoardDeviceNode != null && (node = this.fSelectedBoardDeviceNode.getParent()).isType("board")) {
                    if ("cmsis".equals(packType)) {
                        st.setOption("cmsis.board.name", node.getName());
                        st.setOption("cmsis.board.revision", node.getProperty("board.revision"));
                        st.setOption("cmsis.board.vendor.name", node.getProperty("vendor.name"));
                        st.setNonEmptyOption("cmsis.board.clock", node.getProperty("clock"));
                        st.setOption("cmsis.board.pack.vendor", node.getProperty("pack.vendor"));
                        st.setOption("cmsis.board.pack.name", node.getProperty("pack.name"));
                        st.setOption("cmsis.board.pack.version", node.getProperty("pack.version"));
                    } else if ("xpack.xcdl".equals(packType)) {
                        st.setOption("board.id", node.getProperty("$KEY"));
                        st.setOption("board.revision", node.getProperty("board.revision"));
                        st.setOption("board.vendor.name", node.getProperty("vendor.name"));
                        st.setOption("board.vendor.id", node.getProperty("vendor.id"));
                        String hfxtal = node.getProperty("hfxtal");
                        if (!hfxtal.isEmpty()) {
                            try {
                                BigInteger clock = Utils.convertUnits((String)hfxtal);
                                st.setOption("board.clock", clock.toString());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        st.setOption("board.pack.name", node.getProperty("pack.name"));
                        st.setOption("board.pack.version", node.getProperty("pack.version"));
                        st.setOption("board.compiler.defines", node.getProperty("compilerDefines"));
                        st.setOption("board.compiler.headers", node.getProperty("compilerHeaders"));
                    }
                }
                if ("cmsis".equals(packType)) {
                    String core = DataManager.collectProperty((Leaf)this.fSelectedDeviceNode, (String)"core", (String)"devices");
                    st.setOption("cmsis.core.name", core);
                    String define = DataManager.collectProperty((Leaf)this.fSelectedDeviceNode, (String)"define", (String)"devices");
                    st.setOption("cmsis.compiler.define", define);
                } else if ("xpack.xcdl".equals(packType)) {
                    String arch = DataManager.collectProperty((Leaf)this.fSelectedDeviceNode, (String)"arch", (String)"devices");
                    st.setOption("core.arch", arch);
                }
                int i = 0;
                while (i < this.fMemoryTable.getItemCount()) {
                    TableItem item = this.fMemoryTable.getItem(i);
                    st.setMemory(item.getText(0), item.getText(1), item.getText(2), item.getText(3));
                    ++i;
                }
                st.update();
            }
            catch (CoreException e) {
                Activator.log((Throwable)e);
            }
        }
    }

    protected void performDefaults() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Devices.performDefaults()");
        }
    }

    public boolean canBeVisible() {
        if (!this.page.isForProject()) {
            return false;
        }
        return this.getCfg().getToolChain().getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.option.base.showDevicesTab") != null;
    }

    public boolean canSupportMultiCfg() {
        return true;
    }

    protected void updateButtons() {
    }

    private Node getDevicesTree(IConfiguration config) {
        Node devicesRoot = this.fDataManager.getInstalledObjectsForBuild(config);
        if (devicesRoot == null) {
            devicesRoot = new Node("root");
            Node emptyNode = Node.addNewChild((Node)devicesRoot, (String)"none");
            emptyNode.setName("No devices available, install xPacks or CMSIS Packs first.");
        }
        return devicesRoot;
    }

    class DevicesContentProvider
    extends NodeViewContentProvider {
        DevicesContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = (Leaf[])super.getChildren(parentElement);
            LinkedList<Leaf> list = new LinkedList<Leaf>();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Leaf child = objectArray[n2];
                if (!child.isType("memory") && !child.isType("book")) {
                    list.add(child);
                }
                ++n2;
            }
            if (children.length != list.size()) {
                return list.toArray(new Leaf[list.size()]);
            }
            return children;
        }
    }

    class DevicesLabelProvider
    implements ITableLabelProvider {
        DevicesLabelProvider() {
        }

        public String getColumnText(Object obj, int columnIndex) {
            Leaf node = (Leaf)obj;
            String name = "";
            switch (columnIndex) {
                case 0: {
                    name = " " + node.getName();
                    break;
                }
                case 1: {
                    String description = "";
                    if (node.isType("vendor")) {
                        description = "Vendor";
                    } else if (node.isType("family")) {
                        description = this.computeDescription(node);
                    } else if (node.isType("subfamily")) {
                        description = this.computeDescription(node);
                    } else if (node.isType("device")) {
                        description = this.computeDescription(node);
                    } else if (node.isType("variant")) {
                        description = this.computeDescription(node);
                    } else if (node.isType("board")) {
                        description = this.computeBoardDescription(node);
                    }
                    name = " " + description;
                }
            }
            return name;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        private String computeBoardDescription(Leaf node) {
            String lfosc;
            String hfosc;
            String clock;
            String description = "";
            String revision = node.getProperty("board.revision");
            if (revision.length() > 0) {
                if (description.length() > 0) {
                    description = String.valueOf(description) + ", ";
                }
                if (!revision.toLowerCase().startsWith("rev") && !revision.toLowerCase().startsWith("ver")) {
                    description = String.valueOf(description) + "Rev ";
                }
                description = String.valueOf(description) + revision;
            }
            if ((clock = node.getProperty("clock")).length() > 0) {
                try {
                    int clockMHz = Integer.parseInt(clock) / 1000000;
                    if (description.length() > 0) {
                        description = String.valueOf(description) + ", ";
                    }
                    description = String.valueOf(description) + String.valueOf(clockMHz) + " MHz XTAL";
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((hfosc = node.getProperty("hfxtal")).length() > 0) {
                if (description.length() > 0) {
                    description = String.valueOf(description) + ", ";
                }
                description = String.valueOf(description) + hfosc + " HFXTAL";
            }
            if ((lfosc = node.getProperty("lfxtal")).length() > 0) {
                if (description.length() > 0) {
                    description = String.valueOf(description) + ", ";
                }
                description = String.valueOf(description) + lfosc + " LFXTAL";
            }
            String prefix = "Board";
            if (description.length() > 0) {
                return String.valueOf(prefix) + " (" + description + ")";
            }
            return prefix;
        }

        protected String computeDescription(Leaf node) {
            String prefix = "";
            if (node.isType("family")) {
                prefix = "Family";
            } else if (node.isType("subfamily")) {
                prefix = "Subfamily";
            } else if (node.isType("device")) {
                prefix = "Device";
            } else if (node.isType("variant")) {
                prefix = "Variant";
            }
            String summary = "";
            String packType = node.getProperty("pack.type");
            if ("xpack.xcdl".equals(packType)) {
                String lfosc;
                String hfosc;
                String arch = node.getProperty("arch");
                if (arch.length() > 0) {
                    if (summary.length() > 0) {
                        summary = String.valueOf(summary) + ", ";
                    }
                    summary = String.valueOf(summary) + arch;
                }
                if ((hfosc = node.getProperty("hfosc")).length() > 0) {
                    if (summary.length() > 0) {
                        summary = String.valueOf(summary) + ", ";
                    }
                    summary = String.valueOf(summary) + hfosc + " HFOSC";
                }
                if ((lfosc = node.getProperty("lfosc")).length() > 0) {
                    if (summary.length() > 0) {
                        summary = String.valueOf(summary) + ", ";
                    }
                    summary = String.valueOf(summary) + lfosc + " LFOSC";
                }
            } else {
                String clock;
                String mpu;
                String fpu;
                String core = node.getProperty("core");
                if (core.length() > 0) {
                    if (summary.length() > 0) {
                        summary = String.valueOf(summary) + ", ";
                    }
                    summary = String.valueOf(summary) + core;
                    String version = node.getProperty("core.version");
                    if (version.length() > 0) {
                        if (summary.length() > 0) {
                            summary = String.valueOf(summary) + ", ";
                        }
                        if (!version.toLowerCase().startsWith("rev") && !version.toLowerCase().startsWith("ver")) {
                            summary = String.valueOf(summary) + "Rev ";
                        }
                        summary = String.valueOf(summary) + version;
                    }
                }
                if ((fpu = node.getProperty("fpu")).length() > 0 && "1".equals(fpu)) {
                    if (summary.length() > 0) {
                        summary = String.valueOf(summary) + ", ";
                    }
                    summary = String.valueOf(summary) + "FPU";
                }
                if ((mpu = node.getProperty("mpu")).length() > 0 && "1".equals(mpu)) {
                    if (summary.length() > 0) {
                        summary = String.valueOf(summary) + ", ";
                    }
                    summary = String.valueOf(summary) + "MPU";
                }
                if ((clock = node.getProperty("clock")).length() > 0) {
                    try {
                        int clockMHz = Integer.parseInt(clock) / 1000000;
                        if (summary.length() > 0) {
                            summary = String.valueOf(summary) + ", ";
                        }
                        summary = String.valueOf(summary) + String.valueOf(clockMHz) + " MHz";
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            int ramKB = 0;
            int romKB = 0;
            if (node.hasChildren()) {
                for (Leaf childNode : ((Node)node).getChildren()) {
                    long sizeKB;
                    if (!"memory".equals(childNode.getType())) continue;
                    String size = childNode.getProperty("size");
                    try {
                        sizeKB = StringUtils.convertHexLong((String)size) / 1024L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        sizeKB = 0L;
                    }
                    String id = childNode.getName();
                    if (id.contains("ROM")) {
                        romKB = (int)((long)romKB + sizeKB);
                        continue;
                    }
                    if (!id.contains("RAM")) continue;
                    ramKB = (int)((long)ramKB + sizeKB);
                }
            }
            if (ramKB > 0) {
                if (summary.length() > 0) {
                    summary = String.valueOf(summary) + ", ";
                }
                summary = String.valueOf(summary) + String.valueOf(ramKB) + " kB RAM";
            }
            if (romKB > 0) {
                if (summary.length() > 0) {
                    summary = String.valueOf(summary) + ", ";
                }
                summary = String.valueOf(summary) + String.valueOf(romKB) + " kB ROM";
            }
            summary = summary.length() > 0 ? String.valueOf(prefix) + " (" + summary + ")" : prefix;
            return summary;
        }
    }

    class DevicesViewerComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            Node p1 = (Node)e1;
            Node p2 = (Node)e2;
            int comparison = p1.getName().compareToIgnoreCase(p2.getName());
            return comparison;
        }
    }
}

