/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.jlink;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.core.StringUtils;
import ilg.gnumcueclipse.debug.gdbjtag.DebugUtils;
import ilg.gnumcueclipse.debug.gdbjtag.jlink.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.jlink.DynamicVariableResolver;
import ilg.gnumcueclipse.debug.gdbjtag.jlink.preferences.DefaultPreferences;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;

public class Configuration {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getGdbServerCommand(ILaunchConfiguration configuration, String executable) {
        DefaultPreferences fDefaultPreferences;
        block3: {
            try {
                if (executable != null) return Configuration.resolveAll(executable, configuration);
                fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
                if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart())) break block3;
                return null;
            }
            catch (CoreException e) {
                Activator.log((Throwable)e);
                return null;
            }
        }
        executable = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerExecutable", fDefaultPreferences.getGdbServerExecutable());
        return Configuration.resolveAll(executable, configuration);
    }

    public static String getGdbServerCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbServerCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String[] getGdbServerCommandLineArray(ILaunchConfiguration configuration) {
        String executable;
        DefaultPreferences fDefaultPreferences;
        ArrayList<String> lst;
        block20: {
            block19: {
                lst = new ArrayList<String>();
                try {
                    fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
                    if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart())) break block19;
                    return null;
                }
                catch (CoreException e) {
                    Activator.log((Throwable)e);
                    return null;
                }
            }
            executable = Configuration.getGdbServerCommand(configuration, null);
            if (executable != null && executable.length() != 0) break block20;
            return null;
        }
        lst.add(executable);
        String connection = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerConnection", fDefaultPreferences.getGdbServerConnection());
        String connectionAddress = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerConnectionAddress", fDefaultPreferences.getGdbServerConnectionAddress());
        connectionAddress = DebugUtils.resolveAll((String)connectionAddress, (Map)configuration.getAttributes());
        if (connectionAddress.length() > 0) {
            if ("usb".equals(connection)) {
                lst.add("-select");
                lst.add("usb=" + connectionAddress);
            } else if ("ip".equals(connection)) {
                lst.add("-select");
                lst.add("ip=" + connectionAddress);
            }
        }
        lst.add("-if");
        lst.add(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDebugInterface", fDefaultPreferences.getGdbServerInterface()));
        String defaultName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.flashDeviceName", "");
        String name = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceName", defaultName).trim();
        name = DebugUtils.resolveAll((String)name, (Map)configuration.getAttributes());
        if (name.length() > 0) {
            lst.add("-device");
            lst.add(name);
        }
        lst.add("-endian");
        lst.add(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceEndianness", fDefaultPreferences.getGdbServerEndianness()));
        lst.add("-speed");
        lst.add(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceSpeed", fDefaultPreferences.getGdbServerInitialSpeed()));
        lst.add("-port");
        lst.add(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerGdbPortNumber", 2331)));
        lst.add("-swoport");
        lst.add(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerSwoPortNumber", 2332)));
        lst.add("-telnetport");
        lst.add(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerTelnetPortNumber", 2333)));
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerVerifyDownload", true)) {
            lst.add("-vd");
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doConnectToRunning", false)) {
            lst.add("-noreset");
            lst.add("-noir");
        } else if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerInitRegs", true)) {
            lst.add("-ir");
        } else {
            lst.add("-noir");
        }
        lst.add("-localhostonly");
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerLocalOnly", true)) {
            lst.add("1");
        } else {
            lst.add("0");
        }
        if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerSilent", false)) {
            lst.add("-silent");
        }
        String logFile = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerLog", "").trim();
        if ((logFile = DebugUtils.resolveAll((String)logFile, (Map)configuration.getAttributes())).length() > 0) {
            lst.add("-log");
            lst.add(logFile);
        }
        String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerOther", fDefaultPreferences.getGdbServerOtherOptions()).trim();
        if ((other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes())).length() > 0) {
            lst.addAll(StringUtils.splitCommandLineOptions((String)other));
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbServerCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbServerCommand(config, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String getGdbServerDeviceName(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceName", "").trim();
    }

    public static String getGdbClientCommand(ILaunchConfiguration configuration, String executable) {
        try {
            if (executable == null) {
                String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
                executable = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            }
            executable = Configuration.resolveAll(executable, configuration);
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return null;
        }
        return executable;
    }

    public static String[] getGdbClientCommandLineArray(ILaunchConfiguration configuration) {
        ArrayList<String> lst = new ArrayList<String>();
        String executable = Configuration.getGdbClientCommand(configuration, null);
        if (executable == null || executable.length() == 0) {
            return null;
        }
        lst.add(executable);
        lst.add("--interpreter=mi2");
        lst.add("--nx");
        try {
            DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
            String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbClientOtherOptions", fDefaultPreferences.getGdbClientOtherOptions()).trim();
            other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes());
            if (other.length() > 0) {
                lst.addAll(StringUtils.splitCommandLineOptions((String)other));
            }
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbClientCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbClientCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String getGdbClientCommandName(ILaunchConfiguration config) {
        String fullCommand = Configuration.getGdbClientCommand(config, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String resolveAll(String str, ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String value = str;
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        if (value.indexOf("${") >= 0 && (project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)configuration)) != null) {
            value = DynamicVariableResolver.resolveAll(value, project);
        }
        if (value.indexOf("${") >= 0) {
            value = DebugUtils.resolveAll((String)value, (Map)configuration.getAttributes());
            ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
            if (buildConfig != null) {
                value = DebugUtils.resolveAll((String)value, (ICConfigurationDescription)buildConfig);
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.resolveAll(\"" + str + "\") = \"" + value + "\"");
        }
        return value;
    }

    public static boolean getDoStartGdbServer(ILaunchConfiguration config) throws CoreException {
        DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
        return config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart());
    }

    public static boolean getDoAddServerConsole(ILaunchConfiguration config) throws CoreException {
        return Configuration.getDoStartGdbServer(config) && config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerAllocateConsole", true);
    }

    public static boolean getDoAddSemihostingConsole(ILaunchConfiguration config) throws CoreException {
        return Configuration.getDoStartGdbServer(config) && config.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerAllocateSemihostingConsole", true);
    }
}

