/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.managedbuild.cross.riscv;

import ilg.gnumcueclipse.managedbuild.cross.riscv.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ToolchainDefinition {
    public static final String RISC_V_GCC_NEWLIB = "RISC-V GCC/Newlib";
    public static final String RISC_V_GCC_LINUX = "RISC-V GCC/Linux";
    public static final String RISC_V_GCC_RTEMS = "RISC-V GCC/RTEMS";
    public static final String GME_RISCV_GCC = "GNU MCU RISC-V GCC";
    public static final String DEFAULT_TOOLCHAIN_NAME = "GNU MCU RISC-V GCC";
    private String fName;
    private int fHash;
    private String fPrefix;
    private String fSuffix;
    private String fArchitecture;
    private String fCmdMake;
    private String fCmdRm;
    private String fCmdWinMake;
    private String fCmdWinRm;
    private String fCmdC;
    private String fCmdCpp;
    private String fCmdAr;
    private String fCmdObjcopy;
    private String fCmdObjdump;
    private String fCmdSize;
    private static String[] fArchitectures = new String[]{"RISC-V"};
    private static List<ToolchainDefinition> fgList = new ArrayList<ToolchainDefinition>();
    private static final String CUSTOM_TOOLCHAINS_EXT_POINT_ID = "ilg.gnumcueclipse.managedbuild.cross.riscv.toolchains";

    static {
        fgList.add(new ToolchainDefinition("GNU MCU RISC-V GCC", "riscv-none-embed-"));
        fgList.add(new ToolchainDefinition(RISC_V_GCC_NEWLIB, "riscv64-unknown-elf-"));
        fgList.add(new ToolchainDefinition(RISC_V_GCC_LINUX, "riscv64-unknown-linux-gnu-"));
        fgList.add(new ToolchainDefinition(RISC_V_GCC_RTEMS, "riscv64-unknown-rtems-"));
        ToolchainDefinition.addToolchains();
    }

    public ToolchainDefinition(String sName) {
        this.fName = sName;
        this.fHash = this.fName.hashCode();
        this.fPrefix = "";
        this.fSuffix = "";
        this.fArchitecture = "risc-v";
        this.fCmdMake = "make";
        this.fCmdRm = "rm";
        this.fCmdC = "gcc";
        this.fCmdCpp = "g++";
        this.fCmdAr = "ar";
        this.fCmdObjcopy = "objcopy";
        this.fCmdObjdump = "objdump";
        this.fCmdSize = "size";
    }

    public ToolchainDefinition(String sName, String sPrefix) {
        this(sName);
        this.fPrefix = sPrefix;
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture) {
        this(sName, sPrefix);
        this.fArchitecture = sArchitecture;
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture, String cmdMake, String cmdRm) {
        this(sName, sPrefix, sArchitecture);
        this.fArchitecture = sArchitecture;
        this.fCmdMake = cmdMake;
        this.fCmdRm = cmdRm;
    }

    public void setWin(String cmdMake, String cmdRm) {
        this.fCmdMake = cmdMake;
        this.fCmdRm = cmdRm;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public int getHash() {
        return this.fHash;
    }

    public void setHash(int hash) {
        this.fHash = hash;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public void setPrefix(String prefix) {
        this.fPrefix = prefix;
    }

    public String getSuffix() {
        return this.fSuffix;
    }

    public void setSuffix(String suffix) {
        this.fSuffix = suffix;
    }

    public String getArchitecture() {
        return this.fArchitecture;
    }

    public void setArchitecture(String architecture) {
        this.fArchitecture = architecture;
    }

    public String getCmdMake() {
        return this.fCmdMake;
    }

    public void setCmdMake(String cmdMake) {
        this.fCmdMake = cmdMake;
    }

    public String getCmdRm() {
        return this.fCmdRm;
    }

    public void setCmdRm(String cmdRm) {
        this.fCmdRm = cmdRm;
    }

    public String getCmdWinMake() {
        return this.fCmdWinMake;
    }

    public void setCmdWinMake(String cmdWinMake) {
        this.fCmdWinMake = cmdWinMake;
    }

    public String getCmdWinRm() {
        return this.fCmdWinRm;
    }

    public void setCmdWinRm(String cmdWinRm) {
        this.fCmdWinRm = cmdWinRm;
    }

    public String getCmdC() {
        return this.fCmdC;
    }

    public void setCmdC(String cmdC) {
        this.fCmdC = cmdC;
    }

    public String getCmdCpp() {
        return this.fCmdCpp;
    }

    public void setCmdCpp(String cmdCpp) {
        this.fCmdCpp = cmdCpp;
    }

    public String getCmdAr() {
        return this.fCmdAr;
    }

    public void setCmdAr(String cmdAr) {
        this.fCmdAr = cmdAr;
    }

    public String getCmdObjcopy() {
        return this.fCmdObjcopy;
    }

    public void setCmdObjcopy(String cmdObjcopy) {
        this.fCmdObjcopy = cmdObjcopy;
    }

    public String getCmdObjdump() {
        return this.fCmdObjdump;
    }

    public void setCmdObjdump(String cmdObjdump) {
        this.fCmdObjdump = cmdObjdump;
    }

    public String getCmdSize() {
        return this.fCmdSize;
    }

    public void setCmdSize(String cmdSize) {
        this.fCmdSize = cmdSize;
    }

    public String getFullCmdC() {
        return String.valueOf(this.getPrefix()) + this.getCmdC() + this.getSuffix();
    }

    public String getFullName() {
        return String.valueOf(this.getName()) + " (" + this.getFullCmdC() + ")";
    }

    public static List<ToolchainDefinition> getList() {
        return fgList;
    }

    public static ToolchainDefinition getToolchain(int index) {
        return fgList.get(index);
    }

    public static ToolchainDefinition getToolchain(String index) {
        return fgList.get(Integer.parseInt(index));
    }

    public static int getSize() {
        return fgList.size();
    }

    public static int findToolchainByName(String sName) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            if (td.fName.equals(sName)) {
                return i;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    public static int findToolchainByFullName(String sName) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            String sFullName = td.getFullName();
            if (sFullName.equals(sName)) {
                return i;
            }
            ++i;
        }
        return ToolchainDefinition.getDefault();
    }

    public static int getDefault() {
        return 0;
    }

    public static String[] getArchitectures() {
        return fArchitectures;
    }

    public static String getArchitecture(int index) {
        return fArchitectures[index];
    }

    private static void addToolchains() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(CUSTOM_TOOLCHAINS_EXT_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getAttribute("name");
            try {
                ToolchainDefinition.findToolchainByName(name);
                Activator.log((String)("Duplicate toolchain name '" + name + "', ignored."));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                String cmdRm;
                String cmdMake;
                String architecture;
                String suffix;
                ToolchainDefinition td = new ToolchainDefinition(name);
                String prefix = element.getAttribute("prefix");
                if (prefix != null && !prefix.isEmpty()) {
                    td.setPrefix(prefix);
                }
                if ((suffix = element.getAttribute("suffix")) != null && !suffix.isEmpty()) {
                    td.setSuffix(suffix);
                }
                if ((architecture = element.getAttribute("architecture")) != null && !architecture.isEmpty()) {
                    td.setArchitecture(architecture);
                }
                if ((cmdMake = element.getAttribute("make_cmd")) != null && !cmdMake.isEmpty()) {
                    td.setCmdMake(cmdMake);
                }
                if ((cmdRm = element.getAttribute("remove_cmd")) != null && !cmdRm.isEmpty()) {
                    td.setCmdRm(cmdRm);
                }
                fgList.add(td);
            }
            ++n2;
        }
    }
}

