/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.managedbuild.cross.riscv;

import ilg.gnumcueclipse.managedbuild.cross.riscv.Activator;
import ilg.gnumcueclipse.managedbuild.cross.riscv.IDs;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;

public class Option {
    public static final String OPTION_PREFIX = String.valueOf(IDs.getIdPrefix()) + ".option";
    public static final String OPTION_TARGET = String.valueOf(OPTION_PREFIX) + ".target.";
    public static final String OPTION_TARGET_ISA_BASE = String.valueOf(OPTION_TARGET) + "isa.base";
    public static final String OPTION_TARGET_ISA_FP = String.valueOf(OPTION_TARGET) + "isa.fp";
    public static final String OPTION_TARGET_ISA_ATOMIC = String.valueOf(OPTION_TARGET) + "isa.atomic";
    public static final String OPTION_TARGET_ISA_MULTIPLY = String.valueOf(OPTION_TARGET) + "isa.multiply";
    public static final String OPTION_TARGET_ISA_COMPRESSED = String.valueOf(OPTION_TARGET) + "isa.compressed";
    public static final String OPTION_TARGET_ABI_INTEGER = String.valueOf(OPTION_TARGET) + "abi.integer";
    public static final String OPTION_TARGET_ABI_FP = String.valueOf(OPTION_TARGET) + "abi.fp";
    public static final String OPTION_TARGET_TUNE = String.valueOf(OPTION_TARGET) + "tune";
    public static final String OPTION_TARGET_CODEMODEL = String.valueOf(OPTION_TARGET) + "codemodel";
    public static final String OPTION_TARGET_SMALLDATALIMIT = String.valueOf(OPTION_TARGET) + "smalldatalimit";
    public static final String OPTION_TARGET_ALIGN = String.valueOf(OPTION_TARGET) + "align";
    public static final String OPTION_TARGET_SAVERESTORE = String.valueOf(OPTION_TARGET) + "saverestore";
    public static final String OPTION_TARGET_MEMCPY = String.valueOf(OPTION_TARGET) + "memcpy";
    public static final String OPTION_TARGET_PLT = String.valueOf(OPTION_TARGET) + "plt";
    public static final String OPTION_TARGET_FDIV = String.valueOf(OPTION_TARGET) + "fdiv";
    public static final String OPTION_TARGET_DIV = String.valueOf(OPTION_TARGET) + "div";
    public static final String OPTION_TARGET_OTHER = String.valueOf(OPTION_TARGET) + "other";
    public static final String OPTION_OPTIMIZATION = String.valueOf(OPTION_PREFIX) + ".optimization.";
    public static final String OPTION_OPTIMIZATION_LEVEL = String.valueOf(OPTION_OPTIMIZATION) + "level";
    public static final String OPTION_OPTIMIZATION_MESSAGELENGTH = String.valueOf(OPTION_OPTIMIZATION) + "messagelength";
    public static final String OPTION_OPTIMIZATION_SIGNEDCHAR = String.valueOf(OPTION_OPTIMIZATION) + "signedchar";
    public static final String OPTION_OPTIMIZATION_FUNCTIONSECTIONS = String.valueOf(OPTION_OPTIMIZATION) + "functionsections";
    public static final String OPTION_OPTIMIZATION_DATASECTIONS = String.valueOf(OPTION_OPTIMIZATION) + "datasections";
    public static final String OPTION_OPTIMIZATION_NOCOMMON = String.valueOf(OPTION_OPTIMIZATION) + "nocommon";
    public static final String OPTION_OPTIMIZATION_NOINLINEFUNCTIONS = String.valueOf(OPTION_OPTIMIZATION) + "noinlinefunctions";
    public static final String OPTION_OPTIMIZATION_FREESTANDING = String.valueOf(OPTION_OPTIMIZATION) + "freestanding";
    public static final String OPTION_OPTIMIZATION_NOBUILTIN = String.valueOf(OPTION_OPTIMIZATION) + "nobuiltin";
    public static final String OPTION_OPTIMIZATION_SPCONSTANT = String.valueOf(OPTION_OPTIMIZATION) + "spconstant";
    public static final String OPTION_OPTIMIZATION_PIC = String.valueOf(OPTION_OPTIMIZATION) + "PIC";
    public static final String OPTION_OPTIMIZATION_LTO = String.valueOf(OPTION_OPTIMIZATION) + "lto";
    public static final String OPTION_OPTIMIZATION_NOMOVELOOPINVARIANTS = String.valueOf(OPTION_OPTIMIZATION) + "nomoveloopinvariants";
    public static final String OPTION_OPTIMIZATION_OTHER = String.valueOf(OPTION_OPTIMIZATION) + "other";
    public static final String OPTION_WARNINGS = String.valueOf(OPTION_PREFIX) + ".warnings.";
    public static final String OPTION_WARNINGS_SYNTAXONLY = String.valueOf(OPTION_WARNINGS) + "syntaxonly";
    public static final String OPTION_WARNINGS_PEDANTIC = String.valueOf(OPTION_WARNINGS) + "pedantic";
    public static final String OPTION_WARNINGS_PEDANTICERRORS = String.valueOf(OPTION_WARNINGS) + "pedanticerrors";
    public static final String OPTION_WARNINGS_ALLWARN = String.valueOf(OPTION_WARNINGS) + "allwarn";
    public static final String OPTION_WARNINGS_NOWARN = String.valueOf(OPTION_WARNINGS) + "nowarn";
    public static final String OPTION_WARNINGS_EXTRAWARN = String.valueOf(OPTION_WARNINGS) + "extrawarn";
    public static final String OPTION_WARNINGS_CONVERSION = String.valueOf(OPTION_WARNINGS) + "conversion";
    public static final String OPTION_WARNINGS_UNINITIALIZED = String.valueOf(OPTION_WARNINGS) + "uninitialized";
    public static final String OPTION_WARNINGS_UNUSED = String.valueOf(OPTION_WARNINGS) + "unused";
    public static final String OPTION_WARNINGS_PADDED = String.valueOf(OPTION_WARNINGS) + "padded";
    public static final String OPTION_WARNINGS_FLOATEQUAL = String.valueOf(OPTION_WARNINGS) + "floatequal";
    public static final String OPTION_WARNINGS_SHADOW = String.valueOf(OPTION_WARNINGS) + "shadow";
    public static final String OPTION_WARNINGS_POINTERARITH = String.valueOf(OPTION_WARNINGS) + "pointerarith";
    public static final String OPTION_WARNINGS_LOGICALOP = String.valueOf(OPTION_WARNINGS) + "logicalop";
    public static final String OPTION_WARNINGS_AGREGGATERETURN = String.valueOf(OPTION_WARNINGS) + "agreggatereturn";
    public static final String OPTION_WARNINGS_MISSINGDECLARATION = String.valueOf(OPTION_WARNINGS) + "missingdeclaration";
    public static final String OPTION_WARNINGS_TOERRORS = String.valueOf(OPTION_WARNINGS) + "toerrors";
    public static final String OPTION_WARNINGS_OTHER = String.valueOf(OPTION_WARNINGS) + "other";
    public static final String OPTION_DEBUGGING = String.valueOf(OPTION_PREFIX) + ".debugging.";
    public static final String OPTION_DEBUGGING_LEVEL = String.valueOf(OPTION_DEBUGGING) + "level";
    public static final String OPTION_DEBUGGING_FORMAT = String.valueOf(OPTION_DEBUGGING) + "format";
    public static final String OPTION_DEBUGGING_PROF = String.valueOf(OPTION_DEBUGGING) + "prof";
    public static final String OPTION_DEBUGGING_GPROF = String.valueOf(OPTION_DEBUGGING) + "gprof";
    public static final String OPTION_DEBUGGING_OTHER = String.valueOf(OPTION_DEBUGGING) + "other";
    public static final String OPTION_TOOLCHAIN_NAME = String.valueOf(OPTION_PREFIX) + ".toolchain.name";
    public static final String OPTION_TOOLCHAIN_ID = String.valueOf(OPTION_PREFIX) + ".toolchain.id";
    public static final String OPTION_COMMAND = String.valueOf(OPTION_PREFIX) + ".command.";
    public static final String OPTION_COMMAND_PREFIX = String.valueOf(OPTION_COMMAND) + "prefix";
    public static final String OPTION_COMMAND_SUFFIX = String.valueOf(OPTION_COMMAND) + "suffix";
    public static final String OPTION_COMMAND_C = String.valueOf(OPTION_COMMAND) + "c";
    public static final String OPTION_COMMAND_CPP = String.valueOf(OPTION_COMMAND) + "cpp";
    public static final String OPTION_COMMAND_AR = String.valueOf(OPTION_COMMAND) + "ar";
    public static final String OPTION_COMMAND_OBJCOPY = String.valueOf(OPTION_COMMAND) + "objcopy";
    public static final String OPTION_COMMAND_OBJDUMP = String.valueOf(OPTION_COMMAND) + "objdump";
    public static final String OPTION_COMMAND_SIZE = String.valueOf(OPTION_COMMAND) + "size";
    public static final String OPTION_COMMAND_MAKE = String.valueOf(OPTION_COMMAND) + "make";
    public static final String OPTION_COMMAND_RM = String.valueOf(OPTION_COMMAND) + "rm";
    public static final String OPTION_ADDTOOLS = String.valueOf(OPTION_PREFIX) + ".addtools.";
    public static final String OPTION_ADDTOOLS_CREATEFLASH = String.valueOf(OPTION_ADDTOOLS) + "createflash";
    public static final String OPTION_ADDTOOLS_CREATELISTING = String.valueOf(OPTION_ADDTOOLS) + "createlisting";
    public static final String OPTION_ADDTOOLS_PRINTSIZE = String.valueOf(OPTION_ADDTOOLS) + "printsize";
    public static final String OPTION_CREATEFLASH_CHOICE = String.valueOf(OPTION_PREFIX) + ".createflash.choice";
    public static final boolean OPTION_ADDTOOLS_CREATEFLASH_DEFAULT = true;
    public static final boolean OPTION_ADDTOOLS_CREATELISTING_DEFAULT = false;
    public static final boolean OPTION_ADDTOOLS_PRINTSIZE_DEFAULT = true;
    public static final String CHOICE_IHEX = "ihex";
    public static final String CHOICE_SREC = "srec";
    public static final String CHOICE_SYMBOLSREC = "symbolsrec";
    public static final String CHOICE_BINARY = "binary";

    public static String getOptionStringValue(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            try {
                sReturn = option.getStringValue().trim();
            }
            catch (BuildException e) {
                Activator.log((Throwable)e);
            }
        } else {
            Activator.log((String)("string value " + sOptionId + " not found"));
        }
        return sReturn;
    }

    public static String getOptionEnumCommand(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            try {
                String sEnumId = option.getStringValue();
                sReturn = option.getEnumCommand(sEnumId).trim();
            }
            catch (BuildException e) {
                Activator.log((Throwable)e);
            }
        } else {
            Activator.log((String)("enum command " + sOptionId + " not found"));
        }
        return sReturn;
    }

    public static Boolean getOptionBooleanValue(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        Boolean bReturn = null;
        if (option != null) {
            try {
                bReturn = new Boolean(option.getBooleanValue());
            }
            catch (BuildException e) {
                Activator.log((Throwable)e);
            }
        } else {
            Activator.log((String)("boolean value " + sOptionId + " not found"));
        }
        return bReturn;
    }

    public static Boolean getOptionBooleanValue2(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        Boolean bReturn = null;
        if (option != null) {
            block5: {
                IOption option2 = config.getToolChain().getOptionToSet(option, false);
                if (option2 != null) break block5;
                return null;
            }
            try {
                bReturn = new Boolean(option.getBooleanValue());
            }
            catch (BuildException e) {
                Activator.log((Throwable)e);
            }
        } else {
            Activator.log((String)("boolean value2 " + sOptionId + " not found"));
        }
        return bReturn;
    }

    public static String getOptionBooleanCommand(IConfiguration config, String sOptionId) {
        String sReturn;
        block5: {
            IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
            sReturn = null;
            if (option != null) {
                try {
                    if (option.getBooleanValue()) {
                        sReturn = option.getCommand().trim();
                        break block5;
                    }
                    sReturn = option.getCommandFalse().trim();
                }
                catch (BuildException e) {
                    Activator.log((Throwable)e);
                }
            } else {
                Activator.log((String)("boolean command " + sOptionId + " not found"));
            }
        }
        return sReturn;
    }

    public static String getOptionStringCommandValue(IConfiguration config, String sOptionId) {
        IOption option = config.getToolChain().getOptionBySuperClassId(sOptionId);
        String sReturn = null;
        if (option != null) {
            try {
                String sValue = option.getStringValue();
                if (!sValue.isEmpty()) {
                    sReturn = String.valueOf(option.getCommand().trim()) + sValue.trim();
                }
            }
            catch (BuildException e) {
                Activator.log((Throwable)e);
            }
        } else {
            Activator.log((String)("boolean command " + sOptionId + " not found"));
        }
        return sReturn;
    }

    private static String getRiscvTargetIsa(IConfiguration config) {
        String sReturn = "";
        String sIsa = Option.getOptionEnumCommand(config, OPTION_TARGET_ISA_BASE);
        if (sIsa != null && sIsa.length() > 0) {
            String sValue;
            sReturn = String.valueOf(sReturn) + sIsa;
            if (!"-march=rv32g".equals(sIsa) && !"-march=rv64g".equals(sIsa)) {
                sValue = Option.getOptionBooleanCommand(config, OPTION_TARGET_ISA_MULTIPLY);
                if (sValue != null && sValue.length() > 0) {
                    sReturn = String.valueOf(sReturn) + sValue;
                }
                if ((sValue = Option.getOptionBooleanCommand(config, OPTION_TARGET_ISA_ATOMIC)) != null && sValue.length() > 0) {
                    sReturn = String.valueOf(sReturn) + sValue;
                }
                if ((sValue = Option.getOptionEnumCommand(config, OPTION_TARGET_ISA_FP)) != null && sValue.length() > 0) {
                    sReturn = String.valueOf(sReturn) + sValue;
                }
            }
            if ((sValue = Option.getOptionBooleanCommand(config, OPTION_TARGET_ISA_COMPRESSED)) != null && sValue.length() > 0) {
                sReturn = String.valueOf(sReturn) + sValue;
            }
        }
        if (sReturn != null) {
            sReturn = sReturn.trim();
        }
        return sReturn;
    }

    private static String getRiscvTargetAbi(IConfiguration config) {
        String sReturn = "";
        String sValue = Option.getOptionEnumCommand(config, OPTION_TARGET_ABI_INTEGER);
        if (sValue != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + sValue;
            sValue = Option.getOptionEnumCommand(config, OPTION_TARGET_ABI_FP);
            if (sValue != null && sValue.length() > 0) {
                sReturn = String.valueOf(sReturn) + sValue;
            }
        }
        if (sReturn != null) {
            sReturn = sReturn.trim();
        }
        return sReturn;
    }

    private static String getOptimizationFlags(IConfiguration config) {
        String sValue;
        String sReturn = "";
        if (sReturn != null) {
            sReturn = sReturn.trim();
        }
        if ((sValue = Option.getOptionEnumCommand(config, OPTION_OPTIMIZATION_LEVEL)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_MESSAGELENGTH)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_SIGNEDCHAR)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_FUNCTIONSECTIONS)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_DATASECTIONS)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_NOCOMMON)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_NOINLINEFUNCTIONS)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_FREESTANDING)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_NOBUILTIN)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_SPCONSTANT)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_PIC)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_LTO)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_OPTIMIZATION_NOMOVELOOPINVARIANTS)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionStringValue(config, OPTION_OPTIMIZATION_OTHER)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if (sReturn != null) {
            sReturn = sReturn.trim();
        }
        return sReturn;
    }

    private static String getWarningFlags(IConfiguration config) {
        String sReturn = "";
        String sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_SYNTAXONLY);
        if (sValue != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_PEDANTIC)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_PEDANTICERRORS)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_NOWARN)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_TOERRORS)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_UNUSED)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_UNINITIALIZED)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_ALLWARN)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_EXTRAWARN)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_MISSINGDECLARATION)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_CONVERSION)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_POINTERARITH)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_PADDED)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_SHADOW)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_LOGICALOP)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_AGREGGATERETURN)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_WARNINGS_FLOATEQUAL)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionStringValue(config, OPTION_WARNINGS_OTHER)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if (sReturn != null) {
            sReturn = sReturn.trim();
        }
        return sReturn;
    }

    private static String getDebuggingFlags(IConfiguration config) {
        String sValue;
        String sReturn = "";
        if (sReturn != null) {
            sReturn = sReturn.trim();
        }
        if ((sValue = Option.getOptionEnumCommand(config, OPTION_DEBUGGING_LEVEL)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
            sValue = Option.getOptionEnumCommand(config, OPTION_DEBUGGING_FORMAT);
            if (sValue != null && sValue.length() > 0) {
                sReturn = String.valueOf(sReturn) + " " + sValue;
            }
        }
        if ((sValue = Option.getOptionStringValue(config, OPTION_DEBUGGING_OTHER)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_DEBUGGING_PROF)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_DEBUGGING_GPROF)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        return sReturn;
    }

    public static String getToolChainFlags(IConfiguration config) {
        String sReturn = "";
        String sValue = Option.getRiscvTargetIsa(config);
        if (sValue != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getRiscvTargetAbi(config)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionEnumCommand(config, OPTION_TARGET_TUNE)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionEnumCommand(config, OPTION_TARGET_CODEMODEL)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionStringCommandValue(config, OPTION_TARGET_SMALLDATALIMIT)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionEnumCommand(config, OPTION_TARGET_ALIGN)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_TARGET_SAVERESTORE)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionBooleanCommand(config, OPTION_TARGET_MEMCPY)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptionStringValue(config, OPTION_TARGET_OTHER)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getOptimizationFlags(config)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getWarningFlags(config)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if ((sValue = Option.getDebuggingFlags(config)) != null && sValue.length() > 0) {
            sReturn = String.valueOf(sReturn) + " " + sValue;
        }
        if (sReturn != null) {
            sReturn = sReturn.trim();
        }
        return sReturn;
    }
}

