/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.templates.core.processes;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.embedcdt.templates.core.Utils;

public class ConditionalAddSourceFolders
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = null;
        IProject projectHandle = null;
        String[] targetPaths = null;
        String condition = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (argName.equals("projectName")) {
                projectName = arg.getSimpleValue();
                projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            } else if (argName.equals("paths")) {
                targetPaths = arg.getSimpleArrayValue();
            } else if (argName.equals("condition")) {
                condition = arg.getSimpleValue();
            }
            ++n2;
        }
        if (projectHandle == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "projectName not specified"));
        }
        if (!projectHandle.exists()) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"CreateSourceFolder.0")) + projectName);
        }
        if (targetPaths == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "No paths"));
        }
        if (!Utils.isConditionSatisfied(condition)) {
            return;
        }
        processArgumentArray = targetPaths;
        n = targetPaths.length;
        n2 = 0;
        while (n2 < n) {
            ProcessArgument targetPath = processArgumentArray[n2];
            this.createSourceFolder(projectHandle, (String)targetPath, monitor);
            ++n2;
        }
    }

    protected void createSourceFolder(IProject projectHandle, String targetPath, IProgressMonitor monitor) throws ProcessFailureException {
        if (targetPath == null || targetPath.length() == 0) {
            return;
        }
        IPath projPath = projectHandle.getFullPath();
        IFolder folder = projectHandle.getFolder(targetPath);
        try {
            ICProject cProject = CoreModel.getDefault().create(projectHandle);
            if (cProject != null) {
                if (CCorePlugin.getDefault().isNewStyleProject(cProject.getProject())) {
                    this.createNewStyleProjectFolder(monitor, projectHandle, folder);
                } else {
                    this.createFolder(targetPath, monitor, projPath, cProject);
                }
            }
        }
        catch (WriteAccessException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"CreateSourceFolder.2")) + e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"CreateSourceFolder.2")) + e.getMessage(), (Throwable)e);
        }
    }

    private void createNewStyleProjectFolder(IProgressMonitor monitor, IProject projectHandle, IFolder folder) throws CoreException, WriteAccessException {
        CSourceEntry newEntry = new CSourceEntry(folder, null, 0);
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(projectHandle);
        ICConfigurationDescription[] configs = description.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            ICConfigurationDescription config = configs[i];
            ICSourceEntry[] entries = config.getSourceEntries();
            HashSet<Object> set = new HashSet<Object>();
            int j = 0;
            while (j < entries.length) {
                if (new Path(entries[j].getValue()).segmentCount() != 1) {
                    set.add(entries[j]);
                }
                ++j;
            }
            set.add(newEntry);
            config.setSourceEntries(set.toArray(new ICSourceEntry[set.size()]));
            ++i;
        }
        CCorePlugin.getDefault().setProjectDescription(projectHandle, description, false, monitor);
    }

    private void createFolder(String targetPath, IProgressMonitor monitor, IPath projPath, ICProject cProject) throws CModelException {
        IPathEntry[] entries = cProject.getRawPathEntries();
        ArrayList<Object> newEntries = new ArrayList<Object>(entries.length + 1);
        int projectEntryIndex = -1;
        IPath path = projPath.append(targetPath);
        int i = 0;
        while (i < entries.length) {
            IPathEntry curr = entries[i];
            if (path.equals((Object)curr.getPath())) {
                return;
            }
            if (projPath.equals((Object)curr.getPath())) {
                projectEntryIndex = i;
            }
            newEntries.add(curr);
            ++i;
        }
        ISourceEntry newEntry = CoreModel.newSourceEntry((IPath)path);
        if (projectEntryIndex != -1) {
            newEntries.set(projectEntryIndex, newEntry);
        } else {
            newEntries.add(CoreModel.newSourceEntry((IPath)path));
        }
        cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), monitor);
    }
}

