/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.qemu.preferences;

import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.preferences.Discoverer;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.Activator;

public class DefaultPreferences
extends org.eclipse.embedcdt.debug.gdbjtag.preferences.DefaultPreferences {
    public static final boolean SERVER_DO_START_DEFAULT = true;
    public static final boolean DO_START_GDB_SERVER_DEFAULT = true;
    public static final String SERVER_EXECUTABLE_DEFAULT = "${qemu_path}/${qemu_executable}";
    protected static final String CLIENT_EXECUTABLE_DEFAULT = "${cross_prefix}gdb${cross_suffix}";
    public static final String SERVER_EXECUTABLE_DEFAULT_NAME = "qemu-system-gnuarmeclipse";
    public static final String QEMU_BOARD_NAME_DEFAULT = "?";
    public static final String QEMU_DEVICE_NAME_DEFAULT = "?";
    public static final int SERVER_GDB_PORT_NUMBER_DEFAULT = 1234;
    public static final String SERVER_OTHER_OPTIONS_DEFAULT = "-d unimp,guest_errors";
    public static final boolean DO_GDB_SERVER_ALLOCATE_CONSOLE_DEFAULT = true;
    public static final boolean QEMU_IS_VERBOSE_DEFAULT = false;
    public static final String CLIENT_OTHER_OPTIONS_DEFAULT = "";
    public static final String CLIENT_COMMANDS_DEFAULT = "set mem inaccessible-by-default off\n";
    public static final boolean USE_REMOTE_TARGET_DEFAULT = true;
    public static final String REMOTE_IP_ADDRESS_LOCALHOST = "localhost";
    public static final String REMOTE_IP_ADDRESS_DEFAULT = "localhost";
    public static final int REMOTE_PORT_NUMBER_DEFAULT = 1234;
    public static final boolean DO_INITIAL_RESET_DEFAULT = false;
    public static final String DO_INITIAL_RESET_COMMAND = "monitor system_reset ";
    public static final String HALT_COMMAND = "";
    public static final boolean ENABLE_SEMIHOSTING_DEFAULT = true;
    public static final String ENABLE_SEMIHOSTING_OPTION = "-semihosting-config enable=on,target=native";
    public static final String INIT_OTHER_DEFAULT = "";
    public static final boolean DO_DEBUG_IN_RAM_DEFAULT = false;
    public static final boolean DO_PRERUN_RESET_DEFAULT = true;
    public static final String DO_PRERUN_RESET_COMMAND = "monitor system_reset ";
    public static final boolean DO_STOP_AT_DEFAULT = true;
    public static final String STOP_AT_NAME_DEFAULT = "main";
    public static final String PRERUN_OTHER_DEFAULT = "";
    public static final boolean DO_CONTINUE_DEFAULT = true;
    public static final String DO_CONTINUE_COMMAND = "continue";
    public static final boolean DISABLE_GRAPHICS_DEFAULT = false;
    private static final String REG_SUBKEY = "\\GNU ARM Eclipse\\QEMU";
    private static final String REG_NAME = "InstallLocation";

    public DefaultPreferences(String pluginId) {
        super(pluginId);
    }

    public String getGdbServerExecutable() {
        return this.getString("gdb.server.executable", SERVER_EXECUTABLE_DEFAULT);
    }

    public String getGdbClientExecutable() {
        return this.getString("gdb.client.executable", CLIENT_EXECUTABLE_DEFAULT);
    }

    public String getExecutableName() {
        String key = "executable.name";
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.DefaultPreferences.getExecutableName()=\"" + value + "\"");
        }
        return value;
    }

    public String getExecutableNameOs() {
        String key = EclipseUtils.getKeyOs((String)"executable.name.%s");
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.DefaultPreferences.getExecutableNameOs()=\"" + value + "\" (" + key + ")");
        }
        return value;
    }

    public void putExecutableName(String value) {
        String key = "executable.name";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.DefaultPreferences.putExecutableName(\"" + value + "\")");
        }
        this.putString(key, value);
    }

    public String getInstallFolder() {
        String key = "install.folder";
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.DefaultPreferences.getInstallFolder() = \"" + value + "\"");
        }
        return value;
    }

    public void putInstallFolder(String value) {
        String key = "install.folder";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.DefaultPreferences.putInstallFolder(\"" + value + "\")");
        }
        this.putString(key, value);
    }

    public String getSearchPath() {
        String key = "search.path";
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.DefaultPreferences.getSearchPath()=\"" + value + "\"");
        }
        return value;
    }

    public String getSearchPathOs() {
        String key = EclipseUtils.getKeyOs((String)"search.path.%s");
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.DefaultPreferences.getSearchPathOs()=\"" + value + "\" (" + key + ")");
        }
        return value;
    }

    public void putSearchPath(String value) {
        String key = "search.path";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.DefaultPreferences.putSearchPath(\"" + value + "\")");
        }
        this.putString(key, value);
    }

    public boolean getQemuEnableSemihosting() {
        return this.getBoolean("gdb.qemu.enableSemihosting", true);
    }

    public boolean getTabMainCheckProgram() {
        return this.getBoolean("tab.main.checkProgram", false);
    }

    public boolean getGdbServerDoStart() {
        return this.getBoolean("gdb.server.doStart", true);
    }

    public String getGdbServerOtherOptions() {
        return this.getString("gdb.server.other", SERVER_OTHER_OPTIONS_DEFAULT);
    }

    public String getGdbClientOtherOptions() {
        return this.getString("gdb.client.other", "");
    }

    public String getGdbClientCommands() {
        return this.getString("gdb.client.commands", CLIENT_COMMANDS_DEFAULT);
    }

    public boolean getQemuDebugInRam() {
        return this.getBoolean("gdb.qemu.doDebugInRam", false);
    }

    public boolean getQemuDoInitialReset() {
        return this.getBoolean("gdb.qemu.doInitialReset", false);
    }

    public String getQemuInitOther() {
        return this.getString("gdb.qemu.init.other", "");
    }

    public boolean getQemuDoPreRunReset() {
        return this.getBoolean("gdb.qemu.doPreRunReset", true);
    }

    public String getQemuPreRunOther() {
        return this.getString("gdb.qemu.preRun.other", "");
    }

    public boolean getQemuDisableGraphics() {
        return this.getBoolean("gdb.qemu.disableGraphics", false);
    }

    protected String getRegistryInstallFolder(String subFolder, String executableName) {
        String path = Discoverer.getRegistryInstallFolder((String)executableName, (String)subFolder, (String)REG_SUBKEY, (String)REG_NAME);
        return path;
    }
}

