/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.viewmodel.peripheral;

import java.math.BigInteger;
import java.util.regex.Pattern;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class PeripheralValue
implements IValue {
    public static final int FORMAT_NONE = 0;
    public static final int FORMAT_HEX = 1;
    public static final int FORMAT_HEX8 = 2;
    public static final int FORMAT_HEX16 = 3;
    public static final int FORMAT_HEX32 = 4;
    public static final int FORMAT_HEX64 = 5;
    private Object fValue = null;
    private int fDisplayFormat = 0;

    public static boolean isNumeric(String str) {
        String regExp = "(0[xX]|\\+|\\-)?[0-9A-Fa-f]+";
        return Pattern.matches(regExp, str);
    }

    public void setDisplayFormat(int displayFormat) {
        this.fDisplayFormat = displayFormat;
    }

    public void setDisplayFormatForBitWidth(int bitWidth) {
        if (bitWidth <= 8) {
            this.setDisplayFormat(2);
        } else if (bitWidth <= 16) {
            this.setDisplayFormat(3);
        } else if (bitWidth <= 32) {
            this.setDisplayFormat(4);
        } else if (bitWidth <= 64) {
            this.setDisplayFormat(5);
        } else {
            this.setDisplayFormat(1);
        }
    }

    public boolean update(Object value) {
        Object previousValue = this.fValue;
        this.fValue = value;
        boolean hasChanged = previousValue != null ? !previousValue.equals(this.fValue) : false;
        return hasChanged;
    }

    public boolean hasValue() {
        return this.fValue != null;
    }

    public BigInteger getBigValue() {
        if (this.fValue instanceof BigInteger) {
            return (BigInteger)this.fValue;
        }
        return null;
    }

    public boolean isNumeric() {
        return this.fValue instanceof BigInteger;
    }

    public String getModelIdentifier() {
        return null;
    }

    public IDebugTarget getDebugTarget() {
        return null;
    }

    public ILaunch getLaunch() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public String getValueString() throws DebugException {
        if (this.isNumeric()) {
            BigInteger value = this.getBigValue();
            if (this.fDisplayFormat == 2) {
                return String.format("0x%02X", value);
            }
            if (this.fDisplayFormat == 3) {
                return String.format("0x%04X", value);
            }
            if (this.fDisplayFormat == 4) {
                return String.format("0x%08X", value);
            }
            if (this.fDisplayFormat == 5) {
                return String.format("0x%016X", value);
            }
            if (this.fDisplayFormat == 1) {
                return String.format("0x%X", value);
            }
            if (value.bitCount() <= 32) {
                return String.format("0x%08X", value);
            }
            return String.format("0x%016X", value);
        }
        if (this.fValue != null) {
            return this.fValue.toString();
        }
        return "";
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public IVariable[] getVariables() throws DebugException {
        return null;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public String toString() {
        try {
            return this.getValueString();
        }
        catch (DebugException debugException) {
            return super.toString();
        }
    }
}

