/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.datamodel;

import java.math.BigInteger;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.IPeripheralDMContext;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.PeripheralDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.memory.MemoryBlockMonitor;
import org.eclipse.ui.IWorkbenchWindow;

public class PeripheralDMContext
extends AbstractDMContext
implements IPeripheralDMContext,
Comparable<IPeripheralDMContext> {
    private PeripheralDMNode fDMNode;

    public PeripheralDMContext(DsfSession session, IDMContext[] parents, PeripheralDMNode instance) {
        super(session, parents);
        this.fDMNode = instance;
    }

    public PeripheralDMNode getPeripheralInstance() {
        return this.fDMNode;
    }

    @Override
    public int compareTo(IPeripheralDMContext context) {
        return this.getName().compareTo(context.getName());
    }

    @Override
    public boolean isSystem() {
        return this.fDMNode.isSystem();
    }

    @Override
    public String getId() {
        return this.fDMNode.getId();
    }

    @Override
    public String getName() {
        return this.fDMNode.getName();
    }

    @Override
    public String getRawAddress() {
        return this.fDMNode.getBaseAddress();
    }

    @Override
    public String getHexAddress() {
        return this.fDMNode.getHexAddress();
    }

    @Override
    public BigInteger getBigAddress() {
        return this.fDMNode.getBigAbsoluteAddress();
    }

    @Override
    public BigInteger getBigLength() {
        return this.fDMNode.getBigSizeBytes();
    }

    @Override
    public String getDescription() {
        return this.fDMNode.getDescription();
    }

    @Override
    public boolean isChecked() {
        return this.fDMNode.isChecked();
    }

    @Override
    public void setChecked(boolean flag) {
        this.fDMNode.setChecked(flag);
    }

    @Override
    public boolean hasMemoryMonitor() {
        return this.fDMNode.isShown();
    }

    public void displayPeripheralMonitor(IWorkbenchWindow workbenchWindow) {
        MemoryBlockMonitor.getInstance().displayPeripheralMonitor(workbenchWindow, this, this.isChecked());
    }

    public boolean equals(Object obj) {
        if (obj instanceof PeripheralDMContext) {
            PeripheralDMContext comp = (PeripheralDMContext)obj;
            return this.baseEquals(obj) && this.fDMNode.equals(comp.fDMNode);
        }
        return false;
    }

    public int hashCode() {
        return this.baseHashCode() + this.fDMNode.hashCode();
    }

    public String toString() {
        return "[" + this.getSessionId() + ", " + this.getName() + ", " + this.getRawAddress() + ", " + this.getBigLength() + ", \"" + this.getDescription() + "\"" + "]";
    }
}

