/**
 * Copyright (c) 2016 Kiel University and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.elk.core.meta.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.elk.core.meta.metaData.MdAlgorithm;
import org.eclipse.elk.core.meta.metaData.MdCategory;
import org.eclipse.elk.core.meta.metaData.MdGroup;
import org.eclipse.elk.core.meta.metaData.MdOption;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

/**
 * Provides labels for EObjects.
 * 
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#label-provider
 */
@SuppressWarnings("all")
public class MetaDataLabelProvider extends DefaultEObjectLabelProvider {
  @Inject
  public MetaDataLabelProvider(final AdapterFactoryLabelProvider delegate) {
    super(delegate);
  }
  
  public String text(final MdAlgorithm algorithm) {
    String _name = algorithm.getName();
    return ("Algorithm: " + _name);
  }
  
  public String text(final MdCategory category) {
    String _name = category.getName();
    return ("Category: " + _name);
  }
  
  public String text(final MdGroup group) {
    String _name = group.getName();
    return ("Group: " + _name);
  }
  
  public String text(final MdOption option) {
    String _name = option.getName();
    return ("Option: " + _name);
  }
}
