/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class PartitionPreprocessor
implements ILayoutProcessor<LGraph> {
    private static final int PARTITION_CONSTRAINT_EDGE_PRIORITY = 20;
    private List<List<LNode>> partitions;

    public void process(LGraph lGraph, IElkProgressMonitor monitor) {
        monitor.begin("Adding partition constraint edges", 1.0f);
        this.partitions = Lists.newArrayList();
        for (LNode node : lGraph.getLayerlessNodes()) {
            if (!node.hasProperty(LayeredOptions.PARTITIONING_PARTITION)) continue;
            Integer index = (Integer)node.getProperty(LayeredOptions.PARTITIONING_PARTITION);
            this.retrievePartition(index).add(node);
        }
        int i = 0;
        while (i < this.partitions.size() - 1) {
            for (LNode node : this.partitions.get(i)) {
                LPort sourcePort = new LPort();
                sourcePort.setNode(node);
                sourcePort.setSide(PortSide.EAST);
                sourcePort.setProperty(InternalProperties.PARTITION_DUMMY, true);
                for (LNode otherNode : this.partitions.get(i + 1)) {
                    LPort targetPort = new LPort();
                    targetPort.setNode(otherNode);
                    targetPort.setSide(PortSide.WEST);
                    targetPort.setProperty(InternalProperties.PARTITION_DUMMY, true);
                    LEdge edge = new LEdge();
                    edge.setProperty(InternalProperties.PARTITION_DUMMY, true);
                    edge.setProperty(LayeredOptions.PRIORITY_DIRECTION, 20);
                    edge.setSource(sourcePort);
                    edge.setTarget(targetPort);
                }
            }
            ++i;
        }
        this.partitions = null;
        monitor.done();
    }

    private List<LNode> retrievePartition(int index) {
        while (index >= this.partitions.size()) {
            this.partitions.add(new ArrayList());
        }
        return this.partitions.get(index);
    }
}

