/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.GraphIdentifierGenerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConvertGraphHandler
extends AbstractHandler {
    private static final String PARAM_TARGET_EXT = "org.eclipse.elk.graph.text.convert.targetExtension";
    private static final String EXT_ELK_TEXT = "elkt";
    private static final String EXT_ELK_XMI = "elkg";
    private String targetExtension;

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        this.targetExtension = event.getParameter(PARAM_TARGET_EXT);
        if (!this.isValidTargetExtension(this.targetExtension)) {
            Status status = new Status(4, "org.eclipse.elk.graph.text.ui", "Invalid target extension: " + this.targetExtension);
            StatusManager.getManager().handle((IStatus)status, 3);
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            final Object[] elements = ((IStructuredSelection)selection).toArray();
            Job job = new Job("convert model"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Convert model", elements.length);
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (monitor.isCanceled()) break;
                        if (object instanceof IFile) {
                            ConvertGraphHandler.this.convert((IFile)object);
                        }
                        monitor.worked(1);
                        ++n2;
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    private boolean isValidTargetExtension(String targetExtension) {
        return targetExtension != null && (EXT_ELK_TEXT.equals(targetExtension) || EXT_ELK_XMI.equals(targetExtension));
    }

    public final void convert(IFile file) {
        try {
            List<EObject> sourceModels = this.readModel(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false));
            ArrayList<EObject> targetModels = new ArrayList<EObject>(sourceModels.size());
            for (EObject model : sourceModels) {
                EObject transformed = this.transform(model);
                targetModels.add(transformed);
            }
            this.saveModel(targetModels, this.createTarget(file));
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.eclipse.elk.graph.text.ui", "Error while converting the selected graph.", (Throwable)exception);
            StatusManager.getManager().handle((IStatus)status, 3);
        }
    }

    protected EObject transform(EObject model) {
        EObject copy = EcoreUtil.copy((EObject)model);
        if (this.targetExtension.equals(EXT_ELK_TEXT) && copy instanceof ElkNode) {
            GraphIdentifierGenerator.forGraph((ElkNode)((ElkNode)copy)).assertValid().assertExists().assertUnique().execute();
        }
        return copy;
    }

    private URI createTarget(IFile file) {
        IPath basePath = file.getFullPath();
        String name = basePath.removeFileExtension().lastSegment();
        Path targetPath = new Path(String.valueOf(name) + "." + this.targetExtension);
        int i = 0;
        IContainer parent = file.getParent();
        while (parent.exists((IPath)targetPath)) {
            targetPath = new Path(String.valueOf(name) + ++i + "." + this.targetExtension);
        }
        targetPath = parent.getFullPath().append((IPath)targetPath);
        return URI.createPlatformResourceURI((String)targetPath.toString(), (boolean)false);
    }

    private List<EObject> readModel(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, true);
        return resource.getContents();
    }

    private void saveModel(List<EObject> models, URI uri) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().addAll(models);
        resource.save(Collections.EMPTY_MAP);
    }
}

