/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.nodespacing.cellsystem;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.core.util.nodespacing.cellsystem.Cell;
import org.eclipse.elk.core.util.nodespacing.cellsystem.HorizontalLabelAlignment;
import org.eclipse.elk.core.util.nodespacing.cellsystem.VerticalLabelAlignment;
import org.eclipse.elk.core.util.nodespacing.internal.NodeLabelLocation;

public class LabelCell
extends Cell {
    private final boolean horizontalLayoutMode;
    private HorizontalLabelAlignment horizontalAlignment = HorizontalLabelAlignment.CENTER;
    private VerticalLabelAlignment verticalAlignment = VerticalLabelAlignment.CENTER;
    private final double gap;
    private List<GraphAdapters.LabelAdapter<?>> labels = Lists.newArrayListWithCapacity((int)2);
    private KVector minimumContentAreaSize = new KVector();

    public LabelCell(double gap) {
        this.gap = gap;
        this.horizontalLayoutMode = true;
    }

    public LabelCell(double gap, boolean horizontalLayoutMode) {
        this.gap = gap;
        this.horizontalLayoutMode = horizontalLayoutMode;
    }

    public LabelCell(double gap, NodeLabelLocation nodeLabelLocation) {
        this.gap = gap;
        this.horizontalLayoutMode = true;
        this.horizontalAlignment = nodeLabelLocation.getHorizontalAlignment();
        this.verticalAlignment = nodeLabelLocation.getVerticalAlignment();
    }

    public HorizontalLabelAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public LabelCell setHorizontalAlignment(HorizontalLabelAlignment newHorizontalAlignment) {
        Objects.requireNonNull(newHorizontalAlignment, "Horizontal alignment cannot be null");
        this.horizontalAlignment = newHorizontalAlignment;
        return this;
    }

    public VerticalLabelAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public LabelCell setVerticalAlignment(VerticalLabelAlignment newVerticalAlignment) {
        Objects.requireNonNull(newVerticalAlignment, "Vertical alignment cannot be null");
        this.verticalAlignment = newVerticalAlignment;
        return this;
    }

    public List<GraphAdapters.LabelAdapter<?>> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    @Override
    public double getMinimumWidth() {
        ElkPadding padding = this.getPadding();
        return this.minimumContentAreaSize.x + padding.left + padding.right;
    }

    @Override
    public double getMinimumHeight() {
        ElkPadding padding = this.getPadding();
        return this.minimumContentAreaSize.y + padding.top + padding.bottom;
    }

    public void addLabel(GraphAdapters.LabelAdapter<?> label) {
        this.labels.add(label);
        KVector labelSize = label.getSize();
        if (this.horizontalLayoutMode) {
            this.minimumContentAreaSize.x = Math.max(this.minimumContentAreaSize.x, labelSize.x);
            this.minimumContentAreaSize.y += labelSize.y;
            if (this.labels.size() > 1) {
                this.minimumContentAreaSize.y += this.gap;
            }
        } else {
            this.minimumContentAreaSize.x += labelSize.x;
            this.minimumContentAreaSize.y = Math.max(this.minimumContentAreaSize.y, labelSize.y);
            if (this.labels.size() > 1) {
                this.minimumContentAreaSize.x += this.gap;
            }
        }
    }

    public boolean hasLabels() {
        return this.labels.size() > 0;
    }

    public void applyLabelLayout() {
        if (this.horizontalLayoutMode) {
            this.applyHorizontalModeLabelLayout();
        } else {
            this.applyVerticalModeLabelLayout();
        }
    }

    private void applyHorizontalModeLabelLayout() {
        ElkRectangle cellRect = this.getCellRectangle();
        ElkPadding cellPadding = this.getPadding();
        double yPos = cellRect.y;
        if (this.verticalAlignment == VerticalLabelAlignment.CENTER) {
            yPos += (cellRect.height - this.minimumContentAreaSize.y) / 2.0;
        } else if (this.verticalAlignment == VerticalLabelAlignment.BOTTOM) {
            yPos += cellRect.height - this.minimumContentAreaSize.y;
        }
        for (GraphAdapters.LabelAdapter<?> label : this.labels) {
            KVector labelSize = label.getSize();
            KVector labelPos = new KVector();
            labelPos.y = yPos;
            yPos += labelSize.y + this.gap;
            switch (this.horizontalAlignment) {
                case LEFT: {
                    labelPos.x = cellRect.x + cellPadding.left;
                    break;
                }
                case CENTER: {
                    labelPos.x = cellRect.x + cellPadding.left + (cellRect.width - labelSize.x) / 2.0;
                    break;
                }
                case RIGHT: {
                    labelPos.x = cellRect.x + cellRect.width - cellPadding.right - labelSize.x;
                }
            }
            label.setPosition(labelPos);
        }
    }

    private void applyVerticalModeLabelLayout() {
        ElkRectangle cellRect = this.getCellRectangle();
        ElkPadding cellPadding = this.getPadding();
        double xPos = cellRect.x;
        if (this.horizontalAlignment == HorizontalLabelAlignment.CENTER) {
            xPos += (cellRect.width - this.minimumContentAreaSize.x) / 2.0;
        } else if (this.horizontalAlignment == HorizontalLabelAlignment.RIGHT) {
            xPos += cellRect.width - this.minimumContentAreaSize.x;
        }
        for (GraphAdapters.LabelAdapter<?> label : this.labels) {
            KVector labelSize = label.getSize();
            KVector labelPos = new KVector();
            labelPos.x = xPos;
            xPos += labelSize.x + this.gap;
            switch (this.verticalAlignment) {
                case TOP: {
                    labelPos.y = cellRect.y + cellPadding.top;
                    break;
                }
                case CENTER: {
                    labelPos.y = cellRect.y + cellPadding.top + (cellRect.height - labelSize.y) / 2.0;
                    break;
                }
                case BOTTOM: {
                    labelPos.y = cellRect.y + cellRect.height - cellPadding.bottom - labelSize.y;
                }
            }
            label.setPosition(labelPos);
        }
    }
}

