/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.meta.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.core.meta.metaData.MdAlgorithm;
import org.eclipse.elk.core.meta.metaData.MdBundle;
import org.eclipse.elk.core.meta.metaData.MdBundleMember;
import org.eclipse.elk.core.meta.metaData.MdCategory;
import org.eclipse.elk.core.meta.metaData.MdGroup;
import org.eclipse.elk.core.meta.metaData.MdGroupOrOption;
import org.eclipse.elk.core.meta.metaData.MdOption;
import org.eclipse.elk.core.meta.metaData.MetaDataPackage;
import org.eclipse.elk.core.meta.validation.AbstractMetaDataValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

public class MetaDataValidator
extends AbstractMetaDataValidator {
    @Check
    public void checkDuplicateMemberId(MdBundle bundle) {
        EList<MdBundleMember> _members = bundle.getMembers();
        this.checkDuplicateIds((Iterable<? extends MdBundleMember>)_members);
    }

    private void checkDuplicateIds(Iterable<? extends MdBundleMember> elements) {
        HashMap algorithmIds = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        HashMap categoryIds = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        HashMap propertyIds = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        HashMap groupIds = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        for (MdBundleMember mdBundleMember : elements) {
            boolean _matched = false;
            if (mdBundleMember instanceof MdAlgorithm) {
                _matched = true;
                this.checkExistsAndRemember(algorithmIds, (MdAlgorithm)mdBundleMember);
            }
            if (!_matched && mdBundleMember instanceof MdCategory) {
                _matched = true;
                this.checkExistsAndRemember(categoryIds, (MdCategory)mdBundleMember);
            }
            if (!_matched && mdBundleMember instanceof MdGroup) {
                _matched = true;
                this.checkExistsAndRemember(groupIds, (MdGroup)mdBundleMember);
                EList<MdGroupOrOption> _children = ((MdGroup)mdBundleMember).getChildren();
                this.checkDuplicateIds((Iterable<? extends MdBundleMember>)_children);
            }
            if (_matched || !(mdBundleMember instanceof MdOption)) continue;
            _matched = true;
            this.checkExistsAndRemember(propertyIds, (MdOption)mdBundleMember);
        }
    }

    private <T extends MdBundleMember> void checkExistsAndRemember(Map<String, T> map, T element) {
        String _name = element.getName();
        boolean _containsKey = map.containsKey(_name);
        if (_containsKey) {
            String _name_1 = element.getName();
            MdBundleMember otherMember = (MdBundleMember)map.get(_name_1);
            if (otherMember != null) {
                this.duplicateId(otherMember);
                String _name_2 = element.getName();
                map.put(_name_2, null);
            }
            this.duplicateId(element);
        } else {
            String _name_3 = element.getName();
            map.put(_name_3, element);
        }
    }

    private void duplicateId(MdBundleMember member) {
        String _name = member.getName();
        String _plus = "The id '" + _name;
        String _plus_1 = String.valueOf(_plus) + "' is already used.";
        this.error(_plus_1, member, (EStructuralFeature)MetaDataPackage.Literals.MD_BUNDLE_MEMBER__NAME);
    }
}

