/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.conn.gmf;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.conn.gmf.IEditPartFilter;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPart;

public class GmfLayoutConfigurationStore
implements ILayoutConfigurationStore {
    public static final String PREFIX = "layout:";
    private final IGraphicalEditPart editPart;
    private final IEditPartFilter editPartFilter;

    public GmfLayoutConfigurationStore(EditPart theeditPart, IEditPartFilter filter) {
        if (theeditPart instanceof CompartmentEditPart) {
            this.editPart = (IGraphicalEditPart)((CompartmentEditPart)theeditPart).getParent();
        } else if (theeditPart instanceof IGraphicalEditPart) {
            this.editPart = (IGraphicalEditPart)theeditPart;
        } else if (theeditPart instanceof DiagramRootEditPart) {
            this.editPart = (IGraphicalEditPart)((DiagramRootEditPart)theeditPart).getContents();
        } else {
            throw new IllegalArgumentException("Not supported: " + theeditPart.toString());
        }
        this.editPartFilter = filter;
    }

    public Object getOptionValue(String optionId) {
        Map<String, Object> defaultOptions;
        View view = this.editPart.getNotationView();
        if (view != null) {
            String key = PREFIX + optionId;
            for (Object obj : view.getStyles()) {
                String result;
                StringValueStyle style;
                if (!(obj instanceof StringValueStyle) || !key.equals((style = (StringValueStyle)obj).getName()) || (result = style.getStringValue()) == null) continue;
                return result;
            }
        }
        if ((defaultOptions = this.getDefaultOptions()) != null) {
            return defaultOptions.get(optionId);
        }
        return null;
    }

    protected Map<String, Object> getDefaultOptions() {
        HashMap result = null;
        if (this.editPart instanceof NoteEditPart) {
            result = Maps.newHashMapWithExpectedSize((int)1);
            result.put(CoreOptions.COMMENT_BOX.getId(), true);
        }
        return result;
    }

    public void setOptionValue(String optionId, String value) {
        View view = this.editPart.getNotationView();
        if (view != null) {
            String key = PREFIX + optionId;
            if (value == null) {
                this.removeValue(key, view);
            } else {
                for (Object obj : view.getStyles()) {
                    StringValueStyle style;
                    if (!(obj instanceof StringValueStyle) || !key.equals((style = (StringValueStyle)obj).getName())) continue;
                    style.setStringValue(value);
                    return;
                }
                StringValueStyle style = NotationFactory.eINSTANCE.createStringValueStyle();
                style.setName(key);
                style.setStringValue(value);
                view.getStyles().add((Object)style);
            }
        }
    }

    protected void removeValue(String key, View view) {
        Iterator iter = view.getStyles().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof StringValueStyle) || !key.equals(((StringValueStyle)obj).getName())) continue;
            iter.remove();
        }
    }

    public Collection<String> getAffectedOptions() {
        Map<String, Object> defaultOptions;
        HashSet<String> options = new HashSet<String>();
        View view = this.editPart.getNotationView();
        if (view != null) {
            for (Object obj : view.getStyles()) {
                StringValueStyle style;
                String key;
                if (!(obj instanceof StringValueStyle) || (key = (style = (StringValueStyle)obj).getName()) == null || !key.startsWith(PREFIX)) continue;
                options.add(key.substring(PREFIX.length()));
            }
        }
        if ((defaultOptions = this.getDefaultOptions()) != null) {
            options.addAll(defaultOptions.keySet());
        }
        return options;
    }

    public EditingDomain getEditingDomain() {
        return this.editPart.getEditingDomain();
    }

    public Set<LayoutOptionData.Target> getOptionTargets() {
        if (this.editPart instanceof AbstractBorderItemEditPart) {
            return EnumSet.of(LayoutOptionData.Target.PORTS);
        }
        if (this.editPart instanceof ShapeNodeEditPart) {
            EnumSet<LayoutOptionData.Target> partTarget = EnumSet.of(LayoutOptionData.Target.NODES);
            if (this.findContainingEditPart(this.editPart) != null) {
                partTarget.add(LayoutOptionData.Target.PARENTS);
            }
            return partTarget;
        }
        if (this.editPart instanceof ConnectionEditPart) {
            return EnumSet.of(LayoutOptionData.Target.EDGES);
        }
        if (this.editPart instanceof LabelEditPart) {
            return EnumSet.of(LayoutOptionData.Target.LABELS);
        }
        if (this.editPart instanceof DiagramEditPart) {
            return EnumSet.of(LayoutOptionData.Target.PARENTS);
        }
        return EnumSet.noneOf(LayoutOptionData.Target.class);
    }

    protected IGraphicalEditPart findContainingEditPart(IGraphicalEditPart nodeEditPart) {
        for (Object child : nodeEditPart.getChildren()) {
            if (!this.editPartFilter.filter((EditPart)child)) continue;
            if (child instanceof ShapeNodeEditPart) {
                return nodeEditPart;
            }
            if (!(child instanceof CompartmentEditPart)) continue;
            for (Object grandChild : ((CompartmentEditPart)child).getChildren()) {
                if (!(grandChild instanceof ShapeNodeEditPart) || !this.editPartFilter.filter((EditPart)grandChild)) continue;
                return (IGraphicalEditPart)child;
            }
        }
        return null;
    }

    public ILayoutConfigurationStore getParent() {
        EditPart container = this.getContainer();
        if (container != null) {
            return new GmfLayoutConfigurationStore(container, this.editPartFilter);
        }
        return null;
    }

    protected EditPart getContainer() {
        if (this.editPart instanceof AbstractBorderItemEditPart) {
            return (IGraphicalEditPart)this.editPart.getParent().getParent();
        }
        if (this.editPart instanceof ShapeNodeEditPart) {
            return (IGraphicalEditPart)this.editPart.getParent();
        }
        if (this.editPart instanceof ConnectionEditPart) {
            EditPart sourcePart = ((ConnectionEditPart)this.editPart).getSource();
            if (sourcePart instanceof AbstractBorderItemEditPart) {
                return sourcePart.getParent().getParent();
            }
            if (sourcePart != null) {
                return sourcePart.getParent();
            }
        } else if (this.editPart instanceof LabelEditPart) {
            IGraphicalEditPart containerEditPart = (IGraphicalEditPart)this.editPart.getParent();
            if (containerEditPart instanceof ConnectionEditPart) {
                EditPart sourcePart = ((ConnectionEditPart)containerEditPart).getSource();
                if (sourcePart instanceof AbstractBorderItemEditPart) {
                    return (IGraphicalEditPart)sourcePart.getParent().getParent();
                }
                if (sourcePart != null) {
                    return (IGraphicalEditPart)sourcePart.getParent();
                }
            } else {
                if (containerEditPart instanceof AbstractBorderItemEditPart) {
                    return (IGraphicalEditPart)containerEditPart.getParent().getParent();
                }
                if (containerEditPart instanceof ShapeNodeEditPart) {
                    return (IGraphicalEditPart)containerEditPart.getParent();
                }
            }
            return containerEditPart;
        }
        return null;
    }

    public static final class Provider
    implements ILayoutConfigurationStore.Provider {
        @Inject
        private IEditPartFilter editPartFilter;

        public ILayoutConfigurationStore get(IWorkbenchPart workbenchPart, Object context) {
            if (context instanceof EditPart) {
                try {
                    return new GmfLayoutConfigurationStore((EditPart)context, this.editPartFilter);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return null;
        }
    }
}

