/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.layouter;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.elk.alg.graphviz.dot.dot.Attribute;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeType;
import org.eclipse.elk.alg.graphviz.dot.dot.DotFactory;
import org.eclipse.elk.alg.graphviz.dot.dot.GraphvizModel;
import org.eclipse.elk.alg.graphviz.dot.dot.Statement;
import org.eclipse.elk.alg.graphviz.dot.transform.Command;
import org.eclipse.elk.alg.graphviz.dot.transform.DotExporter;
import org.eclipse.elk.alg.graphviz.dot.transform.IDotTransformationData;
import org.eclipse.elk.alg.graphviz.dot.transform.NeatoModel;
import org.eclipse.elk.alg.graphviz.dot.transform.OverlapMode;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizMetaDataProvider;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.common.util.EList;

public class LayoutDotExporter
extends DotExporter {
    private static final float NSLIMIT_BASE = 100.0f;

    public void transform(IDotTransformationData<ElkNode, GraphvizModel> transData) {
        ElkNode sourceGraph = (ElkNode)transData.getSourceGraph();
        Command command = (Command)transData.getProperty(COMMAND);
        transData.setProperty(USE_EDGE_IDS, (Object)true);
        transData.setProperty(HIERARCHY, (Object)(sourceGraph.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN && command == Command.DOT ? 1 : 0));
        transData.setProperty(TRANSFORM_NODE_LAYOUT, (Object)((Boolean)sourceGraph.getProperty(CoreOptions.INTERACTIVE)));
        transData.setProperty(TRANSFORM_EDGE_LAYOUT, (Object)false);
        transData.setProperty(TRANSFORM_NODE_LABELS, (Object)false);
        transData.setProperty(ADAPT_PORT_POSITIONS, (Object)((Boolean)sourceGraph.getProperty(GraphvizMetaDataProvider.ADAPT_PORT_POSITIONS)));
        super.transform(transData);
    }

    protected void setGraphAttributes(List<Statement> statements, ElkNode parentNode, IDotTransformationData<ElkNode, GraphvizModel> transData) {
        String splineMode;
        Integer maxiter;
        Command command = (Command)transData.getProperty(COMMAND);
        AttributeStatement graphAttrStatement = DotFactory.eINSTANCE.createAttributeStatement();
        graphAttrStatement.setType(AttributeType.GRAPH);
        EList graphAttrs = graphAttrStatement.getAttributes();
        statements.add((Statement)graphAttrStatement);
        this.setGeneralNodeAttributes(statements);
        List edgeAttrs = this.setGeneralEdgeAttributes(statements);
        Double spacing = (Double)parentNode.getProperty(CoreOptions.SPACING_NODE_NODE);
        if (spacing == null || spacing < 0.0) {
            switch (command) {
                case NEATO: 
                case FDP: 
                case CIRCO: {
                    spacing = 40.0;
                    break;
                }
                case TWOPI: {
                    spacing = 60.0;
                    break;
                }
                default: {
                    spacing = 20.0;
                }
            }
        }
        switch (command) {
            case DOT: {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"nodesep", (double)(spacing / 72.0)));
                double rankSepFactor = (Double)parentNode.getProperty(GraphvizMetaDataProvider.LAYER_SPACING_FACTOR);
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"ranksep", (double)(rankSepFactor * spacing / 72.0)));
                switch ((Direction)parentNode.getProperty(CoreOptions.DIRECTION)) {
                    case UP: {
                        graphAttrs.add(LayoutDotExporter.createAttribute((String)"rankdir", (String)"BT"));
                        break;
                    }
                    case LEFT: {
                        graphAttrs.add(LayoutDotExporter.createAttribute((String)"rankdir", (String)"RL"));
                        break;
                    }
                    case RIGHT: {
                        graphAttrs.add(LayoutDotExporter.createAttribute((String)"rankdir", (String)"LR"));
                        break;
                    }
                    default: {
                        graphAttrs.add(LayoutDotExporter.createAttribute((String)"rankdir", (String)"TB"));
                    }
                }
                Double iterationsFactor = (Double)parentNode.getProperty(GraphvizMetaDataProvider.ITERATIONS_FACTOR);
                if (iterationsFactor != null && iterationsFactor > 0.0) {
                    graphAttrs.add(LayoutDotExporter.createAttribute((String)"mclimit", (double)iterationsFactor));
                    if (iterationsFactor < 1.0) {
                        double simplexLimit = iterationsFactor * 100.0;
                        graphAttrs.add(LayoutDotExporter.createAttribute((String)"nslimit", (double)simplexLimit));
                    }
                }
                if (parentNode.getProperty(CoreOptions.HIERARCHY_HANDLING) != HierarchyHandling.INCLUDE_CHILDREN) break;
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"compound", (String)"true"));
                break;
            }
            case TWOPI: {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"ranksep", (double)(spacing / 72.0)));
                break;
            }
            case CIRCO: {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"mindist", (double)(spacing / 72.0)));
                break;
            }
            case NEATO: {
                NeatoModel model;
                edgeAttrs.add(LayoutDotExporter.createAttribute((String)"len", (double)(spacing / 72.0)));
                Integer seed = (Integer)parentNode.getProperty(CoreOptions.RANDOM_SEED);
                if (seed == null) {
                    seed = 1;
                } else if (seed == 0) {
                    seed = -1;
                } else if (seed < 0) {
                    seed = -seed.intValue();
                }
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"start", (String)("random" + String.valueOf(seed))));
                Double epsilon = (Double)parentNode.getProperty(GraphvizMetaDataProvider.EPSILON);
                if (epsilon != null && epsilon > 0.0) {
                    graphAttrs.add(LayoutDotExporter.createAttribute((String)"epsilon", (double)epsilon));
                }
                if ((model = (NeatoModel)parentNode.getProperty(GraphvizMetaDataProvider.NEATO_MODEL)) == NeatoModel.SHORTPATH) break;
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"model", (String)model.literal()));
                break;
            }
            case FDP: {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"K", (double)(spacing / 72.0)));
            }
        }
        if ((command == Command.NEATO || command == Command.FDP) && (maxiter = (Integer)parentNode.getProperty(GraphvizMetaDataProvider.MAXITER)) != null && maxiter > 0) {
            graphAttrs.add(LayoutDotExporter.createAttribute((String)"maxiter", (int)maxiter));
        }
        if (command != Command.DOT) {
            OverlapMode mode = (OverlapMode)parentNode.getProperty(GraphvizMetaDataProvider.OVERLAP_MODE);
            if (mode != OverlapMode.NONE) {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"overlap", (String)mode.literal()));
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"sep", (String)("\"+" + Math.round(spacing / 2.0) + "\"")));
            }
            Boolean pack = (Boolean)parentNode.getProperty(CoreOptions.SEPARATE_CONNECTED_COMPONENTS);
            if (command == Command.TWOPI || pack != null && pack.booleanValue()) {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"pack", (int)spacing.intValue()));
            }
        }
        EdgeRouting edgeRouting = (EdgeRouting)parentNode.getProperty(CoreOptions.EDGE_ROUTING);
        switch (edgeRouting) {
            case POLYLINE: {
                splineMode = "polyline";
                break;
            }
            case ORTHOGONAL: {
                splineMode = "ortho";
                break;
            }
            default: {
                splineMode = "spline";
                transData.setProperty(USE_SPLINES, (Object)true);
            }
        }
        graphAttrs.add(LayoutDotExporter.createAttribute((String)"splines", (String)splineMode));
        if (((Boolean)parentNode.getProperty(GraphvizMetaDataProvider.CONCENTRATE)).booleanValue()) {
            graphAttrs.add(LayoutDotExporter.createAttribute((String)"concentrate", (String)"true"));
        }
    }

    protected void setEdgeLabels(ElkEdge kedge, List<Attribute> attributes, boolean isVertical) {
        super.setEdgeLabels(kedge, attributes, isVertical);
        if (Iterables.any((Iterable)kedge.getLabels(), label -> {
            EdgeLabelPlacement elp = (EdgeLabelPlacement)label.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
            return elp == EdgeLabelPlacement.HEAD || elp == EdgeLabelPlacement.TAIL;
        })) {
            double distance = (Double)kedge.getProperty(GraphvizMetaDataProvider.LABEL_DISTANCE);
            if (distance >= 0.0) {
                attributes.add(LayoutDotExporter.createAttribute((String)"labeldistance", (double)distance));
            }
            double angle = (Double)kedge.getProperty(GraphvizMetaDataProvider.LABEL_ANGLE);
            attributes.add(LayoutDotExporter.createAttribute((String)"labelangle", (double)angle));
        }
    }
}

