/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.CommandConfirmation;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class ResetMenu {
    public static final String RESET_MODE = "org.eclipse.egit.ui.history.ResetMode";

    public static void performReset(Shell shell, Repository repo, ObjectId commitId, ResetCommand.ResetType resetType) {
        String jobName;
        switch (resetType) {
            case HARD: {
                if (!CommandConfirmation.confirmHardReset(shell, repo)) {
                    return;
                }
                jobName = UIText.HardResetToRevisionAction_hardReset;
                break;
            }
            case SOFT: {
                jobName = UIText.SoftResetToRevisionAction_softReset;
                break;
            }
            case MIXED: {
                jobName = UIText.MixedResetToRevisionAction_mixedReset;
                break;
            }
            default: {
                return;
            }
        }
        ResetOperation operation = new ResetOperation(repo, commitId.getName(), resetType);
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)jobName, (Object)JobFamilies.RESET);
    }
}

