/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.emf.pattern.base;

import java.util.Hashtable;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.JavaCore;

public class GenModelUtil {
    private GenModelUtil() {
    }

    public static Generator createGenerator(GenModel genModel, URI mergeRulesURI) {
        Generator generator = new Generator();
        generator.setInput((Object)genModel);
        if (mergeRulesURI != null) {
            generator.getOptions().mergeRulesURI = mergeRulesURI.toString();
        }
        JControlModel jControlModel = generator.getJControlModel();
        if (genModel.isCodeFormatting()) {
            jControlModel.setLeadingTabReplacement(null);
            jControlModel.setConvertToStandardBraceStyle(false);
        } else {
            Hashtable options = JavaCore.getOptions();
            String tabSize = (String)options.get("org.eclipse.jdt.core.formatter.tabulation.size");
            String braceStyle = (String)options.get("org.eclipse.jdt.core.formatter.brace_position_for_type_declaration");
            String tabCharacter = (String)options.get("org.eclipse.jdt.core.formatter.tabulation.char");
            if ("tab".equals(tabCharacter)) {
                jControlModel.setLeadingTabReplacement("\t");
            } else {
                String spaces = "";
                int i = Integer.parseInt(tabSize);
                while (i > 0) {
                    spaces = String.valueOf(spaces) + " ";
                    --i;
                }
                jControlModel.setLeadingTabReplacement(spaces);
            }
            jControlModel.setConvertToStandardBraceStyle("end_of_line".equals(braceStyle));
        }
        return generator;
    }
}

