/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.task.ant.engine;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.StringUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;

public class DataConvert {
    public static final String TYPE_String = "type:string";
    public static final String TYPE_Integer = "type:integer";
    public static final String TYPE_BigInteger = "type:biginteger";
    public static final String TYPE_BigDecimal = "type:bigdecimal";
    public static final String TYPE_Float = "type:float";
    public static final String TYPE_Byte = "type:byte";
    public static final String TYPE_Short = "type:short";
    public static final String TYPE_Double = "type:double";
    public static final String TYPE_Long = "type:long";
    public static final String TYPE_Character = "type:character";
    public static final String TYPE_Boolean = "type:boolean";
    public static final String TYPE_Date = "type:date";
    public static final String TYPE_URI = "type:uri";

    public static Object getConvertVaule(String type, String value) throws Exception {
        if (TYPE_String.equals(type = type.toLowerCase())) {
            return value;
        }
        if (TYPE_Long.equals(type)) {
            Long longValue = new Long(StringUtils.parseHumanSizes((String)value));
            return longValue;
        }
        if (TYPE_Integer.equals(type)) {
            Integer integerValue = Integer.valueOf(value);
            return integerValue;
        }
        if (TYPE_BigInteger.equals(type)) {
            BigInteger bigIntegerValue = BigInteger.valueOf(new Long(StringUtils.parseHumanSizes((String)value)));
            return bigIntegerValue;
        }
        if (TYPE_BigDecimal.equals(type)) {
            BigDecimal bigIntegerValue = new BigDecimal(value);
            return bigIntegerValue;
        }
        if (TYPE_Float.equals(type)) {
            Float floatValue = Float.valueOf(value);
            return floatValue;
        }
        if (TYPE_Byte.equals(type)) {
            Byte byteValue = Byte.valueOf(value);
            return byteValue;
        }
        if (TYPE_Short.equals(type)) {
            Short shortValue = Short.valueOf(value);
            return shortValue;
        }
        if (TYPE_Double.equals(type)) {
            Double doubleValue = Double.valueOf(value);
            return doubleValue;
        }
        if (TYPE_Boolean.equals(type)) {
            Boolean booleanValue = Project.toBoolean((String)value) ? Boolean.TRUE : Boolean.FALSE;
            return booleanValue;
        }
        if (TYPE_Character.equals(type)) {
            Character characterValue = new Character(value.charAt(0));
            return characterValue;
        }
        if (TYPE_Date.equals(type)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date dateValue = simpleDateFormat.parse(value.replace("/", "-"));
            return dateValue;
        }
        if (TYPE_URI.equals(type)) {
            URI uriValue = URI.createURI((String)value);
            return uriValue;
        }
        throw new ExecutionException("It dosen't support to rewriting the contract with the type:'" + type + "' in ant script directly, please rewrite it in the task class.");
    }

    public static Class<?> getType(String type) throws Exception {
        if (TYPE_String.equals(type = type.toLowerCase())) {
            return String.class;
        }
        if (TYPE_Long.equals(type)) {
            return Long.class;
        }
        if (TYPE_Integer.equals(type)) {
            return Integer.class;
        }
        if (TYPE_BigInteger.equals(type)) {
            return BigInteger.class;
        }
        if (TYPE_BigDecimal.equals(type)) {
            return BigDecimal.class;
        }
        if (TYPE_Float.equals(type)) {
            return Float.class;
        }
        if (TYPE_Byte.equals(type)) {
            return Byte.class;
        }
        if (TYPE_Short.equals(type)) {
            return Short.class;
        }
        if (TYPE_Double.equals(type)) {
            return Double.class;
        }
        if (TYPE_Boolean.equals(type)) {
            return Boolean.class;
        }
        if (TYPE_Character.equals(type)) {
            return Character.class;
        }
        if (TYPE_Date.equals(type)) {
            return Date.class;
        }
        if (TYPE_URI.equals(type)) {
            return URI.class;
        }
        throw new ExecutionException("It dosen't support to read the contract with the type:'" + type + "' in ant script directly, please read it in the task class.");
    }
}

