/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.task.ant.ui.contributions;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.core.platform.uri.TargetPlatformURIConverter;
import org.eclipse.egf.task.ui.EGFTaskUIPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

class PlatformEditorInput
implements IStorageEditorInput {
    private final URI uri;

    public PlatformEditorInput(String path) {
        this.uri = URI.createURI((String)path);
    }

    public IStorage getStorage() throws CoreException {
        return new MyStorage();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PlatformEditorInput) {
            PlatformEditorInput input = (PlatformEditorInput)obj;
            return input.uri.equals(this.uri);
        }
        return super.equals(obj);
    }

    public String getName() {
        return this.uri.lastSegment();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.uri.path();
    }

    private class MyStorage
    implements IStorage {
        private MyStorage() {
        }

        public InputStream getContents() throws CoreException {
            try {
                TargetPlatformURIConverter converter = new TargetPlatformURIConverter();
                BufferedReader reader = new BufferedReader(new InputStreamReader(converter.createInputStream(PlatformEditorInput.this.uri)));
                StringBuilder builder = new StringBuilder(1000);
                String readLine = reader.readLine();
                while (readLine != null) {
                    builder.append(readLine).append(EGFCommonConstants.LINE_SEPARATOR);
                    readLine = reader.readLine();
                }
                return new ByteArrayInputStream(builder.toString().getBytes());
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, EGFTaskUIPlugin.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
            }
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            return null;
        }

        public boolean isReadOnly() {
            return true;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

