/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.emf.pattern.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.emf.pattern.base.EGFGenModelUtil;
import org.eclipse.egf.emf.pattern.base.StringJETEmitter;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenBaseGeneratorAdapter;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;

public class CodegenGeneratorAdapter
extends GenBaseGeneratorAdapter {
    protected Generator _generator;
    protected GenModel _genModel;
    protected URI _mergeRulesURI;

    public CodegenGeneratorAdapter(GenBase generatingObject) {
        super(null);
        this.generatingObject = generatingObject;
        this._genModel = generatingObject.getGenModel();
    }

    public void setMergeRulesURI(URI mergeRulesURI) {
        this._mergeRulesURI = mergeRulesURI;
    }

    public Generator getGenerator() {
        if (this._generator == null) {
            this._generator = EGFGenModelUtil.createGenerator(this._genModel, this._mergeRulesURI);
        }
        return this._generator;
    }

    public boolean canGenerate(Object projectType) {
        return super.canGenerate(this.generatingObject, projectType);
    }

    public URI toURI(String pathName) {
        return super.toURI(pathName);
    }

    protected OutputStream createOutputStream(final URI workspacePath) throws Exception {
        return new ByteArrayOutputStream(5000){

            public void close() throws IOException {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath.toString()));
                try {
                    if (file.exists()) {
                        file.setContents((InputStream)new ByteArrayInputStream(this.buf, 0, this.count), 3, null);
                    } else {
                        file.create((InputStream)new ByteArrayInputStream(this.buf, 0, this.count), true, null);
                    }
                }
                catch (CoreException e) {
                    IOException ioException = new IOException(e.getMessage());
                    ioException.initCause(e);
                    throw ioException;
                }
            }
        };
    }

    public boolean exists(URI workspacePath) {
        return ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(workspacePath.toString()));
    }

    public void ensureProjectExists(String workspacePath, Object object, Object projectType, boolean force, Monitor monitor) {
        super.ensureProjectExists(workspacePath, object, projectType, force, monitor);
    }

    public void ensureContainerExists(URI workspacePath, Monitor monitor) {
        super.ensureContainerExists(workspacePath, monitor);
    }

    public void generateJava(String targetPath, String packageName, String className, String output) {
        this.generateJava(targetPath, packageName, className, new StringJETEmitter(output), null, (Monitor)new BasicMonitor());
    }

    public void generateText(String targetPathName, boolean overwrite, String encoding, String output) {
        this.generateText(targetPathName, new StringJETEmitter(output), null, overwrite, encoding, (Monitor)new BasicMonitor());
    }

    public void generateProperties(String targetPathName, String output) {
        this.generateProperties(targetPathName, new StringJETEmitter(output), null, (Monitor)new BasicMonitor());
    }

    public void generateGIF(String inputPathName, String targetPathName, String parentKey, String childKey, boolean overwrite) {
        this.generateGIF(targetPathName, this.createGIFEmitter(inputPathName), parentKey, childKey, overwrite, (Monitor)new BasicMonitor());
    }
}

