/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.application.activity;

import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.application.activity.IApplicationConfigurationConstants;
import org.eclipse.egf.application.internal.activator.EGFApplicationPlugin;
import org.eclipse.egf.application.internal.activity.ActivityRunner;
import org.eclipse.egf.application.internal.l10n.ApplicationMessages;
import org.eclipse.egf.core.domain.RuntimePlatformResourceSet;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityApplication
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        String[] strings = (String[])context.getArguments().get("application.args");
        if (strings == null || strings.length < 2) {
            System.err.println(ApplicationMessages.ActivityApplication_Arguments_Usage);
            return IApplicationConfigurationConstants.EXIT_ERROR;
        }
        boolean hasActivitiesArgument = this.hasActivitiesArgument(strings);
        if (!hasActivitiesArgument) {
            System.err.println(ApplicationMessages.ActivityApplication_Arguments_Usage);
            return IApplicationConfigurationConstants.EXIT_ERROR;
        }
        List<URI> uris = this.getActivityURIs(strings);
        if (uris.isEmpty()) {
            return IApplication.EXIT_OK;
        }
        boolean isRuntime = this.isRuntime(strings);
        Object resourceSet = null;
        resourceSet = isRuntime ? new RuntimePlatformResourceSet() : new TargetPlatformResourceSet();
        UniqueEList activities = new UniqueEList();
        int i = 0;
        while (i < uris.size()) {
            URI uri = uris.get(i);
            EObject eObject = null;
            try {
                eObject = resourceSet.getEObject(uri, true);
            }
            catch (Throwable t) {
                EGFApplicationPlugin.getDefault().logError((Throwable)new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityApplication_EObject_Loading_Error, (Object)i, (Object)uri), t)));
                return IApplicationConfigurationConstants.EXIT_ERROR;
            }
            if (eObject == null || !(eObject instanceof Activity)) {
                EGFApplicationPlugin.getDefault().logError((Throwable)new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityApplication_Invalid_Activity_Argument, (Object)i, (Object)uri), null)));
                return IApplicationConfigurationConstants.EXIT_ERROR;
            }
            activities.add((Activity)eObject);
            ++i;
        }
        if (activities.isEmpty()) {
            return IApplication.EXIT_OK;
        }
        return ActivityApplication.runHelper((List<Activity>)activities);
    }

    public void stop() {
    }

    public static Object runHelper(final List<Activity> activities) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            try {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            ActivityRunner runner = new ActivityRunner(activities);
                            runner.run(monitor);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                workspace.run(runnable, (IProgressMonitor)new CodeGenUtil.EclipseUtil.StreamProgressMonitor(System.out));
            }
            catch (Exception e) {
                EGFApplicationPlugin.getDefault().logError(e);
                Integer n = IApplicationConfigurationConstants.EXIT_ERROR;
                try {
                    workspace.save(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e2) {
                    EGFApplicationPlugin.getDefault().logError(e2);
                    return IApplicationConfigurationConstants.EXIT_ERROR;
                }
                return n;
            }
        }
        finally {
            try {
                workspace.save(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EGFApplicationPlugin.getDefault().logError(e);
                return IApplicationConfigurationConstants.EXIT_ERROR;
            }
        }
        return IApplication.EXIT_OK;
    }

    protected boolean isRuntime(String[] objects) {
        String[] stringArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if ("-runtime".equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean hasActivitiesArgument(String[] objects) {
        String[] stringArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if ("-activities".equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected List<URI> getActivityURIs(String[] objects) {
        UniqueEList uris = new UniqueEList();
        boolean next = false;
        int position = 0;
        String[] stringArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if ("-activities".equals(string)) {
                next = true;
            } else if ("-runtime".equals(string)) {
                next = false;
            } else if (next) {
                URI uri = null;
                ++position;
                try {
                    uri = URI.createURI((String)string);
                }
                catch (Throwable t) {
                    EGFApplicationPlugin.getDefault().logError((Throwable)new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityApplication_Invalid_URI_Argument, (Object)position, (Object)string), t)));
                }
                if (uri != null) {
                    uris.add(uri);
                }
            }
            ++n2;
        }
        return uris;
    }
}

