/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.pattern;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.egf.model.pattern.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    private final Node parent;
    private Pattern pattern;
    private final String patternClass;
    private final Set<String> appliedOutputProcessors = new HashSet<String>();

    protected Node(Node parent, String patternClass) {
        this.parent = parent;
        this.patternClass = patternClass;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getContainer(Class cls) {
        if (this.parent == null) {
            return null;
        }
        if (this.getClass().equals(cls)) {
            return this;
        }
        return this.parent.getContainer(cls);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getPatternClass() {
        return this.patternClass;
    }

    public Set<String> getAppliedOutputProcessors() {
        return this.appliedOutputProcessors;
    }

    public String toString() {
        return "Node [patternClass=" + this.patternClass + "]";
    }

    public static class CallBackContainer
    extends Container {
        public CallBackContainer(Container parent) {
            super(parent, (String)null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Container
    extends Node {
        private final List<Node> children = new ArrayList<Node>();

        public Container(Container parent, Class patternClass) {
            this(parent, patternClass.getName());
        }

        public Container(Container parent, String patternClass) {
            super(parent, patternClass);
            if (parent != null) {
                parent.getChildren().add(this);
            }
        }

        public List<Node> getChildren() {
            return this.children;
        }
    }

    public static final class DataLeaf
    extends Leaf {
        private final String method;
        private String data;

        public DataLeaf(Container parent, Class patternClass, String method, String data) {
            super(parent, patternClass.getName());
            this.method = method;
            this.data = data;
            if (data != null && !"".equals(data)) {
                parent.getChildren().add(this);
            }
        }

        public String getMethod() {
            return this.method;
        }

        public String toString() {
            return "Leaf [method=" + this.method + ", data=" + this.data + " ]";
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public void toString(StringBuilder builder) {
            builder.append(this.data);
        }
    }

    public static abstract class Leaf
    extends Node {
        protected Leaf(Container parent, String patternClass) {
            super(parent, patternClass);
        }

        public abstract void toString(StringBuilder var1);
    }

    public static class SuperOrchestrationContainer
    extends Container {
        public SuperOrchestrationContainer(Container parent) {
            super(parent, (String)null);
        }
    }
}

