/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.AbstractStepContainer;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Chain;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Item;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Job;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Property;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Step;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.BuildLocation;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.BuildstepPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationHelper {
    private static final String FEATURE_SUFFIX = ".feature";
    private static final String SOURCE_SUFFIX = ".source";

    public boolean hasBinaryBuildLocation(EObject eObject) {
        return this.containsClass(eObject, BuildstepPackage.eINSTANCE.getBinaryBuildLocation());
    }

    public boolean hasTargetPlatformBuildLocation(EObject eObject) {
        return this.containsClass(eObject, BuildstepPackage.eINSTANCE.getTargetPlatformBuildLocation());
    }

    public boolean hasRunningPlatformBuildLocation(EObject eObject) {
        return this.containsClass(eObject, BuildstepPackage.eINSTANCE.getRunningPlatformBuildLocation());
    }

    public boolean hasInstallStepBuildLocation(EObject eObject) {
        return this.containsClass(eObject, BuildstepPackage.eINSTANCE.getInstallStepBuildLocation());
    }

    private boolean containsClass(EObject eObject, EClass eClass) {
        TreeIterator eAllContents = eObject.eAllContents();
        while (eAllContents.hasNext()) {
            EClass currentEClass = ((EObject)eAllContents.next()).eClass();
            if (!eClass.equals(currentEClass) && !currentEClass.getESuperTypes().contains((Object)eClass)) continue;
            return true;
        }
        return false;
    }

    public Job getNextChainJob(Job job2) {
        Chain chain2 = (Chain)job2.eContainer();
        if (chain2 == null) {
            return null;
        }
        EList eContents = chain2.eContents();
        int i = eContents.indexOf((Object)job2) + 1;
        while (i < eContents.size()) {
            Job nextJob;
            EObject next = (EObject)eContents.get(i);
            if (next instanceof Job && (nextJob = (Job)next).isEnabled()) {
                return nextJob;
            }
            ++i;
        }
        return null;
    }

    public String getJobName(PatternContext context, Job job2) {
        boolean prefixJobNameWithChainName = (Boolean)context.getValue("prefixJobNameWithChainName");
        Chain chain2 = (Chain)job2.eContainer();
        if (prefixJobNameWithChainName && chain2 != null) {
            return String.valueOf(chain2.getName()) + "_" + job2.getName();
        }
        return job2.getName();
    }

    public String getStringIfNotNull(String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    public String getPatternString(BuildLocation buildLocation) {
        String patternString = buildLocation.getPattern();
        if (patternString == null) {
            return "";
        }
        patternString = patternString.replaceAll("\\.", "\\\\.");
        patternString = patternString.replaceAll("\\?", ".");
        patternString = patternString.replaceAll("\\*", ".*");
        return "pattern=\"^" + patternString + "\"";
    }

    public String getIdOrPositionString(EObject eObject) {
        StringBuilder result = new StringBuilder();
        while (eObject != null) {
            EObject eContainer = eObject.eContainer();
            String idOrPosition = null;
            if (eObject instanceof Step) {
                idOrPosition = ((Step)eObject).getId();
            }
            if (eObject instanceof Item) {
                idOrPosition = ((Item)eObject).getName();
            }
            if (idOrPosition == null || idOrPosition.trim().length() == 0) {
                if (eContainer instanceof AbstractStepContainer) {
                    AbstractStepContainer abstractStepContainer = (AbstractStepContainer)eContainer;
                    idOrPosition = Integer.toString(abstractStepContainer.getSteps().indexOf((Object)eObject) + 1);
                } else if (eContainer != null) {
                    idOrPosition = Integer.toString(eContainer.eContents().indexOf((Object)eObject) + 1);
                }
            }
            if (idOrPosition != null) {
                if (result.length() > 0) {
                    result.insert(0, '_');
                }
                result.insert(0, idOrPosition.replace(' ', '_').replace('\\', '_').replace('/', '_'));
            }
            if (result.length() > 0) {
                result.insert(0, '_');
            }
            result.insert(0, eObject.eClass().getName());
            eObject = eContainer;
            if (!(eObject instanceof Job) && !(eObject instanceof Chain)) continue;
            eObject = null;
        }
        return result.toString();
    }

    /*
     * Unable to fully structure code
     */
    public String replaceProperties(EObject eObject, String input) {
        if (input != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            if (eObject instanceof Item) {
                item = (Item)eObject;
                for (Property property : item.getProperties()) {
                    propertyExpression = "${" + property.getKey() + "}";
                    if (!input.contains(propertyExpression)) continue;
                    input = input.replace(propertyExpression, property.getValue());
                }
            }
            eObject = eObject.eContainer();
lbl11:
            // 2 sources

            ** while (eObject != null)
        }
lbl12:
        // 1 sources

        return input;
    }

    public String createSourceFeatureId(String originalId) {
        StringBuilder sourceIdBld = new StringBuilder();
        if (originalId.endsWith(FEATURE_SUFFIX)) {
            sourceIdBld.append(originalId, 0, originalId.length() - FEATURE_SUFFIX.length());
            sourceIdBld.append(SOURCE_SUFFIX);
            sourceIdBld.append(FEATURE_SUFFIX);
        } else {
            sourceIdBld.append(originalId);
            sourceIdBld.append(SOURCE_SUFFIX);
        }
        return sourceIdBld.toString();
    }

    public Job getJob(EObject eObject) {
        EObject container = eObject.eContainer();
        if (container instanceof Job) {
            return (Job)container;
        }
        if (container != null) {
            return this.getJob(container);
        }
        return null;
    }

    public String getPublishPath(PatternContext context, EObject targetEObject, EObject sourceEObject) {
        if (this.getJob(sourceEObject) == this.getJob(targetEObject)) {
            return "${publish}/";
        }
        return "${build.root}/../../" + this.getJobName(context, this.getJob(targetEObject)) + "/workspace/result/publish/";
    }

    public boolean isEnabled(Step step) {
        return this.getJob(step).isEnabled();
    }

    public List<Step> getAllSteps(Job job2) {
        ArrayList<Step> result = new ArrayList<Step>();
        TreeIterator iterator = job2.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof Step)) continue;
            result.add((Step)eObject);
        }
        return result;
    }
}

