/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.ui.compare.CompareHelper;
import org.eclipse.egf.pattern.ui.compare.MethodCompareItem;

public class MethodCompareInput
extends CompareEditorInput {
    private PatternMethod patternMethod;
    private PatternMethod superPatternMethod;

    public MethodCompareInput(PatternMethod patternMethod, PatternMethod superPatternMethod) {
        super(new CompareConfiguration());
        this.patternMethod = patternMethod;
        this.superPatternMethod = superPatternMethod;
    }

    protected Object prepareInput(IProgressMonitor pm) {
        MethodCompareItem left = new MethodCompareItem(this.superPatternMethod);
        MethodCompareItem right = new MethodCompareItem(this.patternMethod);
        this.getCompareConfiguration().setLeftEditable(left.isEditable());
        this.getCompareConfiguration().setLeftLabel(left.getName());
        this.getCompareConfiguration().setRightEditable(right.isEditable());
        this.getCompareConfiguration().setRightLabel(right.getName());
        PatternMethod superSuperPattern = CompareHelper.getSuperMethod(this.superPatternMethod);
        if (superSuperPattern != null) {
            MethodCompareItem ancestor = new MethodCompareItem(superSuperPattern);
            return new DiffNode(12, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
        }
        return new DiffNode((ITypedElement)left, (ITypedElement)right);
    }
}

