/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.contributions;

import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.editors.PatternEditor;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.PatternTemplateEditor;
import org.eclipse.egf.pattern.ui.editors.templateEditor.AbstractTemplateEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditHelper {
    public static IEditorPart openPatternEditor(IWorkbenchPage page, Pattern pattern) {
        return EditHelper.openPatternEditor(page, pattern, 0);
    }

    public static IEditorPart openPatternEditor(IWorkbenchPage page, Pattern pattern, int matchFlags) {
        if (page == null || pattern == null) {
            throw new IllegalArgumentException();
        }
        IEditorPart part = EditHelper.getExistingEditor(page, pattern, "org.eclipse.egf.pattern.ui.pattern.editor.id");
        if (part != null) {
            return part;
        }
        try {
            return page.openEditor((IEditorInput)new PatternEditorInput(pattern.eResource(), pattern.getID()), "org.eclipse.egf.pattern.ui.pattern.editor.id", true, matchFlags);
        }
        catch (PartInitException pie) {
            Activator.getDefault().logError(pie);
            return null;
        }
    }

    public static PatternTemplateEditor openTemplateBasicEditor(IWorkbenchPage page, Pattern pattern) {
        return EditHelper.openTemplateBasicEditor(page, pattern, 0);
    }

    public static PatternTemplateEditor openTemplateBasicEditor(IWorkbenchPage page, Pattern pattern, int matchFlags) {
        if (page == null || pattern == null) {
            throw new IllegalArgumentException();
        }
        PatternTemplateEditor editor = (PatternTemplateEditor)EditHelper.getExistingEditor(page, pattern, "org.eclipse.egf.pattern.ui.pattern.template.editor.id");
        if (editor != null) {
            return editor;
        }
        try {
            return (PatternTemplateEditor)page.openEditor((IEditorInput)new PatternEditorInput(pattern.eResource(), pattern.getID()), "org.eclipse.egf.pattern.ui.pattern.template.editor.id", true, matchFlags);
        }
        catch (PartInitException pie) {
            Activator.getDefault().logError(pie);
            return null;
        }
    }

    public static IEditorPart openTemplateEditor(IWorkbenchPage page, Pattern pattern) {
        IEditorPart part = EditHelper.getExistingEditor(page, pattern, "org.eclipse.egf.pattern.ui.abstract.template.editor.id");
        if (part != null) {
            return part;
        }
        try {
            return page.openEditor((IEditorInput)new PatternEditorInput(pattern.eResource(), pattern.getID()), "org.eclipse.egf.pattern.ui.abstract.template.editor.id", true, 2);
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e);
            return null;
        }
    }

    private static IEditorPart getExistingEditor(IWorkbenchPage page, Pattern pattern, String editorId) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage innerPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = innerPage.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    PatternEditorInput editorInput;
                    Pattern currentPattern;
                    IEditorReference reference = iEditorReferenceArray[n6];
                    IEditorPart part = reference.getEditor(false);
                    if ((part instanceof PatternEditor && "org.eclipse.egf.pattern.ui.pattern.editor.id".equals(editorId) || part instanceof AbstractTemplateEditor && "org.eclipse.egf.pattern.ui.abstract.template.editor.id".equals(editorId) || part instanceof PatternTemplateEditor && "org.eclipse.egf.pattern.ui.pattern.template.editor.id".equals(editorId)) && pattern.equals(currentPattern = (editorInput = (PatternEditorInput)part.getEditorInput()).getPattern())) {
                        window.setActivePage(innerPage);
                        innerPage.activate((IWorkbenchPart)part);
                        part.setFocus();
                        return part;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

