/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.java.editor.contentassist.computer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egf.pattern.ui.editors.templateEditor.TemplateEditorUtility;
import org.eclipse.egf.pattern.ui.editors.templateEditor.computer.AbstractProposalComputer;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.java.FillArgumentNamesCompletionProposalCollector;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalSorterRegistry;
import org.eclipse.jdt.internal.ui.text.java.TemplateCompletionProposalComputer;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeProposalComputer
extends AbstractProposalComputer {
    private IProgressMonitor fTimeoutProgressMonitor;
    private int offset;
    private IEditorPart templateEditorPart;
    private static final long JAVA_CODE_ASSIST_TIMEOUT = Long.getLong("org.eclipse.jdt.ui.codeAssistTimeout", 5000L);

    public JavaTypeProposalComputer(ITextViewer viewer, int offset, IEditorPart templateEditorPart) {
        this.offset = offset;
        this.templateEditorPart = templateEditorPart;
        this.fTimeoutProgressMonitor = this.createTimeoutProgressMonitor(JAVA_CODE_ASSIST_TIMEOUT);
    }

    public List<ICompletionProposal> computeProposal() {
        if (this.templateEditorPart == null || ((JavaEditor)this.templateEditorPart).getViewer() == null) {
            return null;
        }
        JavaContentAssistInvocationContext context = this.createContext(this.offset);
        ICompilationUnit unit = context.getCompilationUnit();
        if (unit == null) {
            return null;
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        List<ICompletionProposal> javaTypeProposal = this.computeJavaTypeProposal(unit, context);
        proposals.addAll(javaTypeProposal);
        List<ICompletionProposal> templateProposal = this.computeTemplateProposal(context);
        proposals.addAll(templateProposal);
        ProposalSorterRegistry.getDefault().getCurrentSorter().sortProposals((ContentAssistInvocationContext)context, proposals);
        return proposals;
    }

    private List<ICompletionProposal> computeJavaTypeProposal(ICompilationUnit unit, JavaContentAssistInvocationContext context) {
        ITextViewer viewer = context.getViewer();
        CompletionProposalCollector collector = this.createCollector(context);
        collector.setInvocationContext(context);
        collector.setAllowsRequiredProposals(2, 9, true);
        collector.setAllowsRequiredProposals(2, 23, true);
        collector.setAllowsRequiredProposals(2, 21, true);
        collector.setAllowsRequiredProposals(6, 9, true);
        collector.setAllowsRequiredProposals(6, 23, true);
        collector.setAllowsRequiredProposals(6, 22, true);
        collector.setAllowsRequiredProposals(26, 9, true);
        collector.setAllowsRequiredProposals(27, 9, true);
        collector.setAllowsRequiredProposals(1, 9, true);
        collector.setAllowsRequiredProposals(9, 9, true);
        this.setCollectorIgnored(collector);
        collector.setFavoriteReferences(this.getFavoriteStaticMembers());
        try {
            Point selection = viewer.getSelectedRange();
            if (selection.y > 0) {
                collector.setReplacementLength(selection.y);
            }
            unit.codeComplete(this.offset, (CompletionRequestor)collector, this.fTimeoutProgressMonitor);
        }
        catch (OperationCanceledException selection) {
        }
        catch (JavaModelException selection) {
            // empty catch block
        }
        ICompletionProposal[] javaProposals = TemplateEditorUtility.filterJavaMethodProposals((ICompletionProposal[])collector.getJavaCompletionProposals());
        int contextInformationOffset = this.guessMethodContextInformationPosition((ContentAssistInvocationContext)context, this.offset);
        if (contextInformationOffset != this.offset) {
            int i = 0;
            while (i < javaProposals.length) {
                if (javaProposals[i] instanceof JavaMethodCompletionProposal) {
                    JavaMethodCompletionProposal jmcp = (JavaMethodCompletionProposal)javaProposals[i];
                    jmcp.setContextInformationPosition(contextInformationOffset);
                }
                ++i;
            }
        }
        return Arrays.asList(javaProposals);
    }

    private List<ICompletionProposal> computeTemplateProposal(JavaContentAssistInvocationContext context) {
        TemplateCompletionProposalComputer templateCompletionProposalComputer = new TemplateCompletionProposalComputer();
        List computeCompletionProposals = templateCompletionProposalComputer.computeCompletionProposals((ContentAssistInvocationContext)context, null);
        return computeCompletionProposals;
    }

    private void setCollectorIgnored(CompletionProposalCollector collector) {
        collector.setIgnored(13, false);
        collector.setIgnored(1, false);
        collector.setIgnored(27, false);
        collector.setIgnored(2, false);
        collector.setIgnored(25, false);
        collector.setIgnored(3, false);
        collector.setIgnored(4, false);
        collector.setIgnored(5, false);
        collector.setIgnored(7, false);
        collector.setIgnored(12, false);
        collector.setIgnored(6, false);
        collector.setIgnored(26, false);
        collector.setIgnored(24, false);
        collector.setIgnored(8, false);
        collector.setIgnored(11, false);
        collector.setIgnored(10, false);
        collector.setIgnored(9, false);
    }

    protected JavaContentAssistInvocationContext createContext(int offset) {
        if (this.templateEditorPart instanceof JavaEditor) {
            JavaContentAssistInvocationContext javaContentAssistInvocationContext = new JavaContentAssistInvocationContext((ITextViewer)((JavaEditor)this.templateEditorPart).getViewer(), offset, this.templateEditorPart);
            return javaContentAssistInvocationContext;
        }
        return null;
    }

    protected CompletionProposalCollector createCollector(JavaContentAssistInvocationContext context) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments")) {
            return new FillArgumentNamesCompletionProposalCollector(context);
        }
        return new CompletionProposalCollector(context.getCompilationUnit(), true);
    }

    private String[] getFavoriteStaticMembers() {
        String serializedFavorites = PreferenceConstants.getPreferenceStore().getString("content_assist_favorite_static_members");
        if (serializedFavorites != null && serializedFavorites.length() > 0) {
            return serializedFavorites.split(";");
        }
        return new String[0];
    }

    protected final int guessMethodContextInformationPosition(ContentAssistInvocationContext context, int offset) {
        int contextPosition = context.getInvocationOffset();
        IDocument document = context.getDocument();
        if ("".equals(document.get())) {
            return offset;
        }
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        int bound = Math.max(-1, contextPosition - 200);
        int pos = contextPosition - 1;
        try {
            int paren;
            while ((paren = scanner.findOpeningPeer(pos, bound, '(', ')')) != -1) {
                int token = scanner.previousToken(paren - 1, bound);
                if (token == 2000 || token == 14) {
                    return paren + 1;
                }
                pos = paren - 1;
            }
        }
        catch (Exception e) {
            return offset;
        }
        return contextPosition;
    }

    private IProgressMonitor createTimeoutProgressMonitor(final long timeout) {
        return new IProgressMonitor(){
            private long fEndTime;

            public void beginTask(String name, int totalWork) {
                this.fEndTime = System.currentTimeMillis() + timeout;
            }

            public boolean isCanceled() {
                return this.fEndTime <= System.currentTimeMillis();
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
            }
        };
    }
}

