/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.wizards.pages;

import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.dialogs.EcoreSelectionDialog;
import org.eclipse.egf.core.ui.dialogs.ISelectionDialogListener;
import org.eclipse.egf.core.ui.dialogs.TypeSelectionDialog;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class ChooseTypePage
extends WizardPage {
    private static final URI NSURI_GENMODEL = URI.createURI((String)"http://www.eclipse.org/emf/2002/GenModel");
    private Object[] _selectedJavaType;
    private Object[] _selectedEcoreType;
    private EcoreSelectionDialog _ecoreDialog;
    private TypeSelectionDialog _typeDialog;
    private TabFolder _tabFolder;
    private EditingDomain _editingDomain;
    private String _currentType;
    private IJavaProject _javaProject;

    public ChooseTypePage(EditingDomain editingDomain, String currentType) {
        super(Messages.ChooseTypePage_title);
        this.setTitle(Messages.ChooseTypePage_title);
        this.setDescription(Messages.ChooseTypePage_description);
        this._editingDomain = editingDomain;
        this._currentType = currentType;
    }

    public ChooseTypePage(EditingDomain editingDomain, String currentType, EObject current) {
        this(editingDomain, currentType);
        if (current != null) {
            this._javaProject = EMFHelper.getJavaProject((Resource)current.eResource());
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createTabFolder(container);
        this.setControl((Control)container);
    }

    private void createTabFolder(Composite container) {
        this._tabFolder = new TabFolder(container, 0);
        this._tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    if (ChooseTypePage.this._javaProject != null) {
                        ChooseTypePage.this._javaProject.close();
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        });
        this._tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem ecoreTabItem = new TabItem(this._tabFolder, 0);
        ecoreTabItem.setText(Messages.ChooseTypePage_coreTypeTabItem_title);
        ecoreTabItem.setImage(EGFCoreUIPlugin.getDefault().getImage("obj16/EcoreModelFile.gif"));
        Composite compositeEcore = new Composite((Composite)this._tabFolder, 0);
        compositeEcore.setLayout((Layout)new GridLayout());
        compositeEcore.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChooseTypePage.this._ecoreDialog.close();
            }
        });
        this._ecoreDialog = new EcoreSelectionDialog(container.getShell(), this._editingDomain){

            protected Control createDialogArea(Composite parent) {
                int index;
                Control content = super.createDialogArea(parent);
                URI nsURI = !"".equals(ChooseTypePage.this._currentType) && ChooseTypePage.this._currentType != null ? ((index = ChooseTypePage.this._currentType.indexOf("#//")) != -1 ? URI.createURI((String)ChooseTypePage.this._currentType.substring(0, index)) : NSURI_GENMODEL) : NSURI_GENMODEL;
                Resource resource = ChooseTypePage.this._editingDomain.getResourceSet().getResource(nsURI, true);
                this._ecoreTypeTreeViewer.setInput((Object)resource.getContents());
                this._ecoreTypeTreeViewer.expandToLevel(2);
                return content;
            }

            protected void handleDoubleClick() {
                IWizard wizard = ChooseTypePage.this.getWizard();
                wizard.performFinish();
                super.handleDoubleClick();
                IWizardContainer wizardContainer = wizard.getContainer();
                if (wizardContainer instanceof WizardDialog) {
                    ((WizardDialog)wizardContainer).close();
                }
            }
        };
        this._ecoreDialog.createPage(compositeEcore);
        this._ecoreDialog.addSelectionListeners(new ISelectionDialogListener(){

            public void handleSelected(Object[] selected) {
                ChooseTypePage.this._selectedEcoreType = selected;
                ChooseTypePage.this.setPageComplete(ChooseTypePage.this.isPageComplete());
            }
        });
        ecoreTabItem.setControl((Control)compositeEcore);
        TabItem typeTabItem = new TabItem(this._tabFolder, 0);
        typeTabItem.setText(Messages.ChooseTypePage_javaTypeTabItem_title);
        typeTabItem.setImage(Activator.getDefault().getImage("obj16/class_obj.gif"));
        Composite compositeType = new Composite((Composite)this._tabFolder, 0);
        compositeType.setLayout((Layout)new GridLayout());
        compositeType.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChooseTypePage.this._typeDialog.close();
            }
        });
        this._typeDialog = new TypeSelectionDialog(container.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), this._javaProject, 10){

            protected void handleDoubleClick() {
                IWizard wizard = ChooseTypePage.this.getWizard();
                wizard.performFinish();
                super.handleDoubleClick();
                IWizardContainer wizardContainer = wizard.getContainer();
                if (wizardContainer instanceof WizardDialog) {
                    ((WizardDialog)wizardContainer).close();
                }
            }
        };
        this._typeDialog.createPage(compositeType);
        this._typeDialog.addSelectionListeners(new ISelectionDialogListener(){

            public void handleSelected(Object[] selected) {
                ChooseTypePage.this._selectedJavaType = selected;
                ChooseTypePage.this.setPageComplete(ChooseTypePage.this.isPageComplete());
            }
        });
        typeTabItem.setControl((Control)compositeType);
    }

    public static String getType(String type) {
        if (type == null || type.length() == 0) {
            return "";
        }
        int index = type.lastIndexOf(".");
        if (index != -1) {
            return type.substring(index + 1);
        }
        return type;
    }

    public Object getSelectedEcoreType() {
        return this.isPageComplete() ? this._selectedEcoreType[0] : null;
    }

    public boolean isPageComplete() {
        return this._selectedEcoreType != null && this._selectedEcoreType.length > 0 || this._selectedJavaType != null && this._selectedJavaType.length > 0;
    }

    public Object getSelectedJavaType() {
        return this.isPageComplete() ? this._selectedJavaType[0] : null;
    }

    public boolean isInCoreTab() {
        return this._tabFolder.getSelectionIndex() == 0;
    }
}

