/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build;

import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.BuildcorePackage;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Chain;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Item;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Job;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Property;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Step;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.BuildLocation;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.BuildstepPackage;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.CLEAN_TYPE;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class GenerationHelper {
    public String getCleanTypeString(String prefix, String suffix, CLEAN_TYPE cleanType) {
        if (cleanType == null || cleanType == CLEAN_TYPE.NOTHING) {
            return "";
        }
        if (cleanType == CLEAN_TYPE.RESULT) {
            return String.valueOf(prefix) + "clean.result" + suffix;
        }
        if (cleanType == CLEAN_TYPE.WORKSPACE) {
            return String.valueOf(prefix) + "clean.workspace" + suffix;
        }
        return "unknown " + (Object)((Object)cleanType);
    }

    public boolean hasTargetPlatformBuildLocation(EObject eObject) {
        return this.containsClass(eObject, BuildstepPackage.eINSTANCE.getTargetPlatformBuildLocation());
    }

    private boolean containsClass(EObject eObject, EClass eClass) {
        TreeIterator eAllContents = eObject.eAllContents();
        while (eAllContents.hasNext()) {
            if (!eClass.equals(((EObject)eAllContents.next()).eClass())) continue;
            return true;
        }
        return false;
    }

    public Job getNextChainJob(Job job) {
        Chain chain = (Chain)job.eContainer();
        if (chain == null) {
            return null;
        }
        EList eContents = chain.eContents();
        int i = eContents.indexOf((Object)job) + 1;
        while (i < eContents.size()) {
            Job nextJob;
            EObject next = (EObject)eContents.get(i);
            if (next instanceof Job && (nextJob = (Job)next).isEnabled()) {
                return nextJob;
            }
            ++i;
        }
        return null;
    }

    public String getJobName(PatternContext context, Job job) {
        boolean prefixJobNameWithChainName = (Boolean)context.getValue("prefixJobNameWithChainName");
        Chain chain = (Chain)job.eContainer();
        if (prefixJobNameWithChainName && chain != null) {
            return String.valueOf(chain.getName()) + "_" + job.getName();
        }
        return job.getName();
    }

    public String generateJobStepsString(Job job, char separator) {
        StringBuffer buffer = new StringBuffer("init");
        for (Object next : job.eContents()) {
            if (!(next instanceof Step)) continue;
            Step step = (Step)next;
            if (buffer.length() > 0) {
                buffer.append(separator);
            }
            buffer.append(this.getPositionString(step));
        }
        return buffer.toString();
    }

    public String getStringIfNotNull(String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    public String getPatternString(BuildLocation buildLocation) {
        String patternString = buildLocation.getPattern();
        if (patternString == null) {
            return "";
        }
        patternString = patternString.replaceAll("\\.", "\\\\.");
        patternString = patternString.replaceAll("\\?", ".");
        patternString = patternString.replaceAll("\\*", ".*");
        return "pattern=\"^" + patternString + "\"";
    }

    private int getPositionInParent(EObject eObject, EClass eClass) {
        int result = 0;
        for (EObject object : eObject.eContainer().eContents()) {
            if (object.eClass().equals(eClass) || object.eClass().getEAllSuperTypes().contains((Object)eClass)) {
                ++result;
            }
            if (object != eObject) continue;
            return result;
        }
        return -1;
    }

    public String getPositionString(Step step) {
        return "step" + this.getPositionInParent(step, BuildcorePackage.eINSTANCE.getStep());
    }

    public String getPositionString(BuildLocation buildLocation) {
        return String.valueOf(this.getPositionString(buildLocation.getBuildStep())) + "location" + this.getPositionInParent(buildLocation, BuildstepPackage.eINSTANCE.getBuildLocation());
    }

    /*
     * Unable to fully structure code
     */
    public String replaceProperties(EObject eObject, String input) {
        if (input != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            if (eObject instanceof Item) {
                item = (Item)eObject;
                for (Property property : item.getProperties()) {
                    propertyExpression = "${" + property.getKey() + "}";
                    if (!input.contains(propertyExpression)) continue;
                    input = input.replace(propertyExpression, property.getValue());
                }
            }
            eObject = eObject.eContainer();
lbl11:
            // 2 sources

            ** while (eObject != null)
        }
lbl12:
        // 1 sources

        return input;
    }
}

