/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.dialogs.AbstractFilteredItemsSelectionDialog;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreSelectionDialog
extends AbstractFilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.egf.core.ui.dialogs.FcoreSelectionDialog";
    private ILabelProvider _labelProvider = new LabelProvider(){

        public Image getImage(Object element) {
            if (!(element instanceof IPlatformFcore)) {
                return super.getImage(element);
            }
            return EGFCoreUIPlugin.getDefault().getImage("obj16/fcore.gif");
        }

        public String getText(Object element) {
            if (!(element instanceof IPlatformFcore)) {
                return super.getText(element);
            }
            return ((IPlatformFcore)element).getName();
        }
    };
    private ILabelProvider _detailsLabelProvider = new LabelProvider(){

        public Image getImage(Object element) {
            if (!(element instanceof IPlatformFcore)) {
                return super.getImage(element);
            }
            IPlatformFcore fc = (IPlatformFcore)element;
            File file = new File(fc.getPlatformBundle().getInstallLocation());
            if (file.exists() && file.isDirectory()) {
                return EGFCoreUIPlugin.getDefault().getImage("obj16/directory.gif");
            }
            if (file.exists() && file.isFile()) {
                return EGFCoreUIPlugin.getDefault().getImage("obj16/jar.gif");
            }
            return EGFCoreUIPlugin.getDefault().getImage("obj16/fcore.gif");
        }

        public String getText(Object element) {
            if (!(element instanceof IPlatformFcore)) {
                return super.getText(element);
            }
            StringBuffer buffer = new StringBuffer();
            IPlatformFcore fc = (IPlatformFcore)element;
            if (fc.getPlatformBundle().isTarget()) {
                buffer.append(" [Target]");
            } else {
                buffer.append(" [Workspace]");
            }
            buffer.append(" [");
            buffer.append(fc.getPlatformBundle().getInstallLocation());
            buffer.append("]");
            return buffer.toString();
        }
    };
    private IPlatformFcore[] _fcores;

    private static IPlatformFcore[] getElements() {
        return EGFCorePlugin.getPlatformFcores();
    }

    public FcoreSelectionDialog(Shell parentShell, boolean multipleSelection) {
        this(parentShell, FcoreSelectionDialog.getElements(), multipleSelection);
    }

    public FcoreSelectionDialog(Shell parentShell, IPlatformFcore[] factoryComponents, boolean multipleSelection) {
        super(parentShell, multipleSelection);
        this._fcores = factoryComponents;
        this.setTitle(CoreUIMessages._UI_FcoreSelection_label);
        this.setMessage(CoreUIMessages._UI_SelectRegisteredFcore);
        this.setListLabelProvider(this.getLabelProvider());
        this.setListSelectionLabelDecorator(this.getSelectionLabelProvider());
        this.setDetailsLabelProvider(this.getDetailsLabelProvider());
        this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_platformSeparatorLabel);
        this.setSelectionHistory(new FcoreSelectionHistory());
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        if (selection.size() != 0) {
            UniqueEList fcores = new UniqueEList();
            for (Object object : selection.toList()) {
                if (!(object instanceof IPlatformFcore)) continue;
                fcores.add((IPlatformFcore)object);
            }
            this.notifySelectionListeners(fcores.toArray());
        }
    }

    protected ILabelProvider getLabelProvider() {
        return this._labelProvider;
    }

    protected ILabelDecorator getSelectionLabelProvider() {
        return new ResourceSelectionLabelProvider();
    }

    protected ILabelProvider getDetailsLabelProvider() {
        return this._detailsLabelProvider;
    }

    public Shell getShell() {
        return super.getShell() != null ? super.getShell() : this.getParentShell();
    }

    public Control createPage(Composite parent) {
        this.dialogArea = this.createDialogArea(parent);
        return this.dialogArea;
    }

    public Object[] getResult() {
        Object[] result = super.getResult();
        if (result == null) {
            return null;
        }
        ArrayList<IPlatformFcore> resultToReturn = new ArrayList<IPlatformFcore>();
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof IPlatformFcore) {
                resultToReturn.add((IPlatformFcore)result[i]);
            }
            ++i;
        }
        return resultToReturn.toArray();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FcoreSearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        int i = 0;
        while (i < this._fcores.length) {
            contentProvider.add((Object)this._fcores[i], itemsFilter);
            progressMonitor.worked(1);
            ++i;
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = EGFCoreUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = EGFCoreUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IPlatformFcore) {
            IPlatformFcore fc = (IPlatformFcore)item;
            return fc.getURI().toString();
        }
        return null;
    }

    protected Comparator<IPlatformFcore> getItemsComparator() {
        return new FcoreSearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, EGFCoreUIPlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FcoreSearchComparator
    implements Comparator<IPlatformFcore>,
    Serializable {
        public static final long serialVersionUID = 1L;

        private FcoreSearchComparator() {
        }

        @Override
        public int compare(IPlatformFcore fc1, IPlatformFcore fc2) {
            if (fc1.getName() == null) {
                return -1;
            }
            if (fc2.getName() == null) {
                return 1;
            }
            return fc1.getName().compareTo(fc2.getName());
        }
    }

    private class FcoreSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private FcoreSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)FcoreSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof IPlatformFcore)) {
                return false;
            }
            return this.matches(((IPlatformFcore)item).getName());
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof IPlatformFcore;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            return filter instanceof FcoreSearchItemsFilter;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.equalsFilter(filter)) {
                return false;
            }
            return filter instanceof FcoreSearchItemsFilter;
        }
    }

    private class FcoreSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private static final String TAG_URI = "path";
        private IPlatformFcore _previous;

        protected Object restoreItemFromMemento(IMemento memento) {
            String tag = memento.getString(TAG_URI);
            if (tag == null) {
                return null;
            }
            URI uri = URI.createURI((String)tag);
            IPlatformFcore[] iPlatformFcoreArray = EGFCorePlugin.getPlatformFcores();
            int n = iPlatformFcoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPlatformFcore fcore = iPlatformFcoreArray[n2];
                if (fcore.getURI().equals((Object)uri)) {
                    this._previous = fcore;
                    return fcore;
                }
                ++n2;
            }
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            if (FcoreSelectionDialog.this.getReturnCode() == 0) {
                Object[] items = this.getHistoryItems();
                int i = 0;
                while (i < items.length) {
                    IPlatformFcore fcore = (IPlatformFcore)items[i];
                    element.putString(TAG_URI, fcore.getURI().toString());
                    ++i;
                }
            } else if (this._previous != null) {
                element.putString(TAG_URI, this._previous.getURI().toString());
            }
        }
    }

    private class ResourceSelectionLabelProvider
    extends LabelProvider
    implements ILabelDecorator {
        public String decorateText(String text, Object element) {
            if (!(element instanceof IPlatformFcore)) {
                return this.getText(element);
            }
            return ((IPlatformFcore)element).getURI().toString();
        }

        public Image decorateImage(Image image, Object element) {
            if (!(element instanceof IPlatformFcore)) {
                return this.getImage(element);
            }
            return EGFCoreUIPlugin.getDefault().getImage("obj16/fcore.gif");
        }
    }
}

