/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.internal.pde.PlatformBundle;
import org.eclipse.egf.core.platform.internal.pde.PlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointFactory;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointListener;
import org.eclipse.egf.core.platform.pde.IPlatformManager;
import org.eclipse.egf.core.platform.util.CollectionHelper;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IExtensionDeltaEvent;
import org.eclipse.pde.internal.core.IExtensionDeltaListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformManager
implements IPlatformManager,
IPluginModelListener,
IExtensionDeltaListener {
    private static Map<String, Class<? extends IPlatformExtensionPoint>> _extensionPoints;
    private static volatile PlatformManager __platformManager;
    private static Object _lock;
    private Map<String, IPlatformBundle> _platformBundles;
    private Map<Class<?>, List<Object>> _workspaceRegistry;
    private Map<Class<?>, List<Object>> _targetRegistry;
    private List<IPlatformExtensionPointListener> _listeners;

    static {
        _lock = new Object();
    }

    private static Map<String, Class<? extends IPlatformExtensionPoint>> getExtensionPoints() {
        if (_extensionPoints == null) {
            _extensionPoints = new HashMap<String, Class<? extends IPlatformExtensionPoint>>();
            for (String extensionPoint : EGFPlatformPlugin.getDefault().getPlatform().keySet()) {
                IPlatformExtensionPointFactory clazz = null;
                try {
                    clazz = (IPlatformExtensionPointFactory)ExtensionPointHelper.createInstance((IConfigurationElement)EGFPlatformPlugin.getDefault().getPlatform().get(extensionPoint), (String)"class");
                }
                catch (CoreException ce) {
                    EGFPlatformPlugin.getDefault().logError(ce);
                }
                if (clazz == null) continue;
                Class<? extends IPlatformExtensionPoint> key = EGFPlatformPlugin.fetchReturnedTypeFromFactory(clazz.getClass());
                _extensionPoints.put(extensionPoint, key);
            }
        }
        return _extensionPoints;
    }

    public static Collection<Class<? extends IPlatformExtensionPoint>> getExtensionPointsValues() {
        return PlatformManager.getExtensionPoints().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlatformManager getInstance() {
        if (__platformManager == null) {
            Object object = _lock;
            synchronized (object) {
                if (__platformManager == null) {
                    __platformManager = new PlatformManager();
                }
            }
        }
        return __platformManager;
    }

    private PlatformManager() {
    }

    public void dispose() {
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        PDECore.getDefault().getModelManager().removeExtensionDeltaListener((IExtensionDeltaListener)this);
        this._platformBundles = null;
        this._targetRegistry = null;
        this._workspaceRegistry = null;
        this._listeners = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlatformBundle getPlatformBundle(String id) {
        Object object = _lock;
        synchronized (object) {
            block5: {
                if (id != null) break block5;
                return null;
            }
            if (this._platformBundles == null) {
                this.initializePlatformManager();
            }
            return this._platformBundles.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlatformBundle getPlatformBundle(IPluginModelBase base) {
        Object object = _lock;
        synchronized (object) {
            String id;
            block6: {
                block5: {
                    if (base != null) break block5;
                    return null;
                }
                id = BundleHelper.getBundleId((IPluginModelBase)base);
                if (id != null) break block6;
                return null;
            }
            return this.getPlatformBundle(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlatformBundle getPlatformBundle(IProject project) {
        Object object = _lock;
        synchronized (object) {
            String id;
            block8: {
                IPluginModelBase base;
                block7: {
                    block6: {
                        if (project != null) break block6;
                        return null;
                    }
                    base = BundleHelper.getPluginModelBase((IProject)project);
                    if (base != null) break block7;
                    return null;
                }
                id = BundleHelper.getBundleId((IPluginModelBase)base);
                if (id != null) break block8;
                return null;
            }
            return this.getPlatformBundle(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlatformBundle[] getPlatformBundles() {
        Object object = _lock;
        synchronized (object) {
            if (this._platformBundles == null) {
                this.initializePlatformManager();
            }
            return this._platformBundles.values().toArray(new IPlatformBundle[this._platformBundles.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getWorkspacePlatformExtensionPoints(Class<T> clazz) {
        Object object = _lock;
        synchronized (object) {
            ArrayList<Object> extensionPoints = new ArrayList<Object>();
            if (clazz != null && PlatformManager.getExtensionPointsValues().contains(clazz)) {
                if (this._platformBundles == null) {
                    this.initializePlatformManager();
                }
                if (this._workspaceRegistry.get(clazz) != null) {
                    extensionPoints.addAll((Collection<Object>)this._workspaceRegistry.get(clazz));
                }
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(extensionPoints, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getTargetPlatformExtensionPoints(Class<T> clazz) {
        Object object = _lock;
        synchronized (object) {
            ArrayList<Object> extensionPoints = new ArrayList<Object>();
            if (clazz != null && PlatformManager.getExtensionPointsValues().contains(clazz)) {
                if (this._platformBundles == null) {
                    this.initializePlatformManager();
                }
                if (this._targetRegistry.get(clazz) != null) {
                    extensionPoints.addAll((Collection<Object>)this._targetRegistry.get(clazz));
                }
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(extensionPoints, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(Class<T> clazz) {
        Object object = _lock;
        synchronized (object) {
            block5: {
                if (clazz != null && PlatformManager.getExtensionPointsValues().contains(clazz)) break block5;
                return null;
            }
            if (this._platformBundles == null) {
                this.initializePlatformManager();
            }
            IPlatformExtensionPoint[] targetExtensionPoints = this.getTargetPlatformExtensionPoints(clazz);
            IPlatformExtensionPoint[] workspaceExtensionPoints = this.getWorkspacePlatformExtensionPoints(clazz);
            IPlatformExtensionPoint[] extensionPoints = (IPlatformExtensionPoint[])Array.newInstance(clazz, targetExtensionPoints.length + workspaceExtensionPoints.length);
            System.arraycopy(targetExtensionPoints, 0, extensionPoints, 0, targetExtensionPoints.length);
            System.arraycopy(workspaceExtensionPoints, 0, extensionPoints, targetExtensionPoints.length, workspaceExtensionPoints.length);
            return extensionPoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(IProject project, Class<T> clazz) {
        Object object = _lock;
        synchronized (object) {
            if (project != null && clazz != null && PlatformManager.getExtensionPointsValues().contains(clazz)) {
                IPlatformBundle platformBundle;
                if (this._platformBundles == null) {
                    this.initializePlatformManager();
                }
                if ((platformBundle = this.getPlatformBundle(project)) != null) {
                    return platformBundle.getPlatformExtensionPoints(clazz);
                }
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(new ArrayList<Object>(0), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(String id, Class<T> clazz) {
        Object object = _lock;
        synchronized (object) {
            if (id != null && clazz != null && PlatformManager.getExtensionPointsValues().contains(clazz)) {
                IPlatformBundle platformBundle;
                if (this._platformBundles == null) {
                    this.initializePlatformManager();
                }
                if ((platformBundle = this._platformBundles.get(id)) != null) {
                    return platformBundle.getPlatformExtensionPoints(clazz);
                }
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(new ArrayList<Object>(0), clazz);
        }
    }

    private void initializePlatformManager() {
        if (this._platformBundles != null) {
            return;
        }
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        PDECore.getDefault().getModelManager().addExtensionDeltaListener((IExtensionDeltaListener)this);
        this._platformBundles = new TreeMap<String, IPlatformBundle>();
        this._workspaceRegistry = new HashMap();
        this._targetRegistry = new HashMap();
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getActiveModels((boolean)true);
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase base = iPluginModelBaseArray[n2];
            this.addPlatformBundle(BundleHelper.getBundleId((IPluginModelBase)base), this.createPlatformBundle(base), null);
            ++n2;
        }
        if (EGFPlatformPlugin.getDefault().isDebugging()) {
            IPlatformBundle[] platformBundles = this.getPlatformBundles();
            if (platformBundles.length > 0) {
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"PlatformManager.initializePlatformManager(..) _ found {0} Platform Bundle{1}", (Object)platformBundles.length, (Object)(platformBundles.length < 2 ? "" : "s")));
            }
            this.trace(platformBundles);
        }
    }

    private void firePlatformExtensionPoint(IPlatformExtensionPointDelta delta) {
        if (this._listeners != null) {
            for (IPlatformExtensionPointListener listener : this._listeners) {
                listener.platformExtensionPointChanged(delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlatformExtensionPointListener(IPlatformExtensionPointListener listener) {
        Object object = _lock;
        synchronized (object) {
            if (this._listeners == null) {
                this._listeners = new ArrayList<IPlatformExtensionPointListener>();
            }
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInFrontPlatformExtensionPointListener(IPlatformExtensionPointListener listener) {
        Object object = _lock;
        synchronized (object) {
            if (this._listeners == null) {
                this._listeners = new ArrayList<IPlatformExtensionPointListener>();
            }
            if (!this._listeners.contains(listener)) {
                this._listeners.add(0, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlatformExtensionPointListener(IPlatformExtensionPointListener listener) {
        Object object = _lock;
        synchronized (object) {
            if (this._listeners == null) {
                return;
            }
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extensionsChanged(IExtensionDeltaEvent event) {
        Object object = _lock;
        synchronized (object) {
            IPlatformBundle existingPlatformBundle;
            String id;
            IPluginModelBase base;
            PlatformExtensionPointDelta delta = new PlatformExtensionPointDelta();
            IPluginModelBase[] iPluginModelBaseArray = event.getRemovedModels();
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                base = iPluginModelBaseArray[n2];
                id = BundleHelper.getBundleId((IPluginModelBase)base);
                if (id != null && (existingPlatformBundle = this._platformBundles.get(id)) != null && base.equals(existingPlatformBundle.getPluginModelBase())) {
                    this.removePlatformBundle(id, existingPlatformBundle, delta);
                }
                ++n2;
            }
            iPluginModelBaseArray = event.getChangedModels();
            n = iPluginModelBaseArray.length;
            n2 = 0;
            while (n2 < n) {
                base = iPluginModelBaseArray[n2];
                this.handleChange(base, delta);
                ++n2;
            }
            iPluginModelBaseArray = event.getAddedModels();
            n = iPluginModelBaseArray.length;
            n2 = 0;
            while (n2 < n) {
                base = iPluginModelBaseArray[n2];
                id = BundleHelper.getBundleId((IPluginModelBase)base);
                if (id != null) {
                    existingPlatformBundle = this._platformBundles.get(id);
                    if (existingPlatformBundle != null && !base.equals(existingPlatformBundle.getPluginModelBase())) {
                        this.removePlatformBundle(id, existingPlatformBundle, delta);
                    }
                    this.addPlatformBundle(id, this.createPlatformBundle(base), delta);
                }
                ++n2;
            }
            if (!delta.isEmpty()) {
                if (EGFPlatformPlugin.getDefault().isDebugging()) {
                    this.trace(delta);
                }
                this.firePlatformExtensionPoint(delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelsChanged(PluginModelDelta event) {
        Object object = _lock;
        synchronized (object) {
            ModelEntry entry;
            int n;
            int n2;
            ModelEntry[] modelEntryArray;
            PlatformExtensionPointDelta delta = new PlatformExtensionPointDelta();
            if ((event.getKind() & 2) != 0) {
                modelEntryArray = event.getRemovedEntries();
                n2 = modelEntryArray.length;
                n = 0;
                while (n < n2) {
                    IPlatformBundle existingPlatformBundle;
                    entry = modelEntryArray[n];
                    String id = entry.getId();
                    if (id != null && (existingPlatformBundle = this._platformBundles.get(id)) != null) {
                        this.removePlatformBundle(id, existingPlatformBundle, delta);
                    }
                    ++n;
                }
            }
            if ((event.getKind() & 4) != 0) {
                modelEntryArray = event.getChangedEntries();
                n2 = modelEntryArray.length;
                n = 0;
                while (n < n2) {
                    entry = modelEntryArray[n];
                    for (IPluginModelBase base : this.getExtensionPointModels(entry)) {
                        this.handleChange(base, delta);
                    }
                    ++n;
                }
            }
            if ((event.getKind() & 1) != 0) {
                modelEntryArray = event.getAddedEntries();
                n2 = modelEntryArray.length;
                n = 0;
                while (n < n2) {
                    entry = modelEntryArray[n];
                    for (IPluginModelBase base : this.getExtensionPointModels(entry)) {
                        String id = BundleHelper.getBundleId((IPluginModelBase)base);
                        if (id == null) continue;
                        IPlatformBundle existingPlatformBundle = this._platformBundles.get(id);
                        if (existingPlatformBundle != null && !base.equals(existingPlatformBundle.getPluginModelBase())) {
                            this.removePlatformBundle(id, existingPlatformBundle, delta);
                        }
                        this.addPlatformBundle(id, this.createPlatformBundle(base), delta);
                    }
                    ++n;
                }
            }
            if (!delta.isEmpty()) {
                if (EGFPlatformPlugin.getDefault().isDebugging()) {
                    this.trace(delta);
                }
                this.firePlatformExtensionPoint(delta);
            }
        }
    }

    private IPlatformBundle createPlatformBundle(IPluginModelBase base) {
        PlatformBundle platformBundle = new PlatformBundle(base);
        IPluginExtension[] iPluginExtensionArray = base.getExtensions(false).getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            Class<? extends IPlatformExtensionPoint> clazz = PlatformManager.getExtensionPoints().get(extension.getPoint());
            if (clazz != null) {
                platformBundle.addPlatformExtensionPoint(clazz, extension);
            }
            ++n2;
        }
        return platformBundle;
    }

    private void handleChange(IPluginModelBase base, PlatformExtensionPointDelta delta) {
        String id = BundleHelper.getBundleId((IPluginModelBase)base);
        IPlatformBundle existingPlatformBundle = this._platformBundles.get(id);
        if (base.isEnabled()) {
            if (existingPlatformBundle != null && base.equals(existingPlatformBundle.getPluginModelBase())) {
                this.mergePlatformBundle(id, this.createPlatformBundle(base), delta);
            } else {
                if (existingPlatformBundle != null && !base.equals(existingPlatformBundle.getPluginModelBase())) {
                    this.removePlatformBundle(id, existingPlatformBundle, delta);
                }
                this.addPlatformBundle(id, this.createPlatformBundle(base), delta);
            }
        } else {
            this.removePlatformBundle(id, existingPlatformBundle, delta);
        }
    }

    private void mergePlatformBundle(String id, IPlatformBundle newPlatformBundle, PlatformExtensionPointDelta delta) {
        if (id == null || newPlatformBundle == null) {
            return;
        }
        IPlatformBundle existingPlatformBundle = this._platformBundles.get(id);
        if (existingPlatformBundle == null) {
            return;
        }
        for (Class<? extends IPlatformExtensionPoint> clazz : PlatformManager.getExtensionPoints().values()) {
            int n;
            int n2;
            IPlatformExtensionPoint[] iPlatformExtensionPointArray;
            IPlatformExtensionPoint[] iPlatformExtensionPointArray2 = existingPlatformBundle.getPlatformExtensionPoints(clazz);
            int n3 = iPlatformExtensionPointArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                block32: {
                    IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray2[n4];
                    iPlatformExtensionPointArray = newPlatformBundle.getPlatformExtensionPoints(clazz);
                    n2 = iPlatformExtensionPointArray.length;
                    n = 0;
                    while (n < n2) {
                        block31: {
                            IPlatformExtensionPoint newExtensionPoint = iPlatformExtensionPointArray[n];
                            try {
                                if (!extensionPoint.getPluginElement().equals(newExtensionPoint.getPluginElement())) break block31;
                                break block32;
                            }
                            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                                break;
                            }
                        }
                        ++n;
                    }
                    if (!existingPlatformBundle.removePlatformExtensionPoint(clazz, extensionPoint)) {
                        EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.mergePlatformBundle(..) _ ''{0}'' unable to remove Extension Point from PlatformBundle.", (Object)extensionPoint));
                    }
                    if (existingPlatformBundle.isTarget()) {
                        if (this._targetRegistry.get(clazz).remove(extensionPoint)) {
                            if (this._targetRegistry.get(clazz).isEmpty()) {
                                this._targetRegistry.remove(clazz);
                            }
                            if (delta != null) {
                                delta.storeRemovedPlatformExtensionPoint(clazz, extensionPoint);
                            }
                        }
                    } else if (this._workspaceRegistry.get(clazz).remove(extensionPoint)) {
                        if (this._workspaceRegistry.get(clazz).isEmpty()) {
                            this._workspaceRegistry.remove(clazz);
                        }
                        if (delta != null) {
                            delta.storeRemovedPlatformExtensionPoint(clazz, extensionPoint);
                        }
                    }
                }
                ++n4;
            }
            iPlatformExtensionPointArray2 = newPlatformBundle.getPlatformExtensionPoints(clazz);
            n3 = iPlatformExtensionPointArray2.length;
            n4 = 0;
            while (n4 < n3) {
                block33: {
                    IPlatformExtensionPoint newExtensionPoint = iPlatformExtensionPointArray2[n4];
                    iPlatformExtensionPointArray = existingPlatformBundle.getPlatformExtensionPoints(clazz);
                    n2 = iPlatformExtensionPointArray.length;
                    n = 0;
                    while (n < n2) {
                        IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n];
                        if (!extensionPoint.getPluginElement().equals(newExtensionPoint.getPluginElement())) {
                            ++n;
                            continue;
                        }
                        break block33;
                    }
                    if ((newExtensionPoint = existingPlatformBundle.addPlatformExtensionPoint(clazz, newExtensionPoint.getPluginElement())) != null) {
                        List<Object> extensionPoints;
                        if (existingPlatformBundle.isTarget()) {
                            extensionPoints = this._targetRegistry.get(clazz);
                            if (extensionPoints == null) {
                                extensionPoints = new ArrayList<Object>();
                                this._targetRegistry.put(clazz, extensionPoints);
                            }
                            if (!extensionPoints.add(newExtensionPoint)) {
                                EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.mergePlatformBundle(..) _ ''{0}'' unable to add Extension Point in target registry.", (Object)newExtensionPoint));
                            } else if (delta != null) {
                                delta.storeAddedPlatformExtensionPoint(clazz, newExtensionPoint);
                            }
                        } else {
                            extensionPoints = this._workspaceRegistry.get(clazz);
                            if (extensionPoints == null) {
                                extensionPoints = new ArrayList<Object>();
                                this._workspaceRegistry.put(clazz, extensionPoints);
                            }
                            if (!extensionPoints.add(newExtensionPoint)) {
                                EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.mergePlatformBundle(..) _ ''{0}'' unable to add Extension Point in workspace registry.", (Object)newExtensionPoint));
                            } else if (delta != null) {
                                delta.storeAddedPlatformExtensionPoint(clazz, newExtensionPoint);
                            }
                        }
                    }
                }
                ++n4;
            }
        }
        if (existingPlatformBundle.isEmpty() && !existingPlatformBundle.equals(this._platformBundles.remove(id))) {
            EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.mergePlatformBundle(..) _ ''{0}'' unknown PlatformBundle.", (Object)id));
        }
    }

    private void removePlatformBundle(String id, IPlatformBundle platformBundle, PlatformExtensionPointDelta delta) {
        if (id == null || platformBundle == null) {
            return;
        }
        if (!platformBundle.equals(this._platformBundles.remove(id))) {
            EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.removePlatformBundle(..) _ ''{0}'' unknown PlatformBundle.", (Object)id));
        }
        for (Class<? extends IPlatformExtensionPoint> clazz : PlatformManager.getExtensionPoints().values()) {
            IPlatformExtensionPoint[] iPlatformExtensionPointArray = platformBundle.getPlatformExtensionPoints(clazz);
            int n = iPlatformExtensionPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n2];
                if (platformBundle.isTarget()) {
                    if (this._targetRegistry.get(clazz).remove(extensionPoint)) {
                        if (this._targetRegistry.get(clazz).isEmpty()) {
                            this._targetRegistry.remove(clazz);
                        }
                        if (delta != null) {
                            delta.storeRemovedPlatformExtensionPoint(clazz, extensionPoint);
                        }
                    }
                } else if (this._workspaceRegistry.get(clazz).remove(extensionPoint)) {
                    if (this._workspaceRegistry.get(clazz).isEmpty()) {
                        this._workspaceRegistry.remove(clazz);
                    }
                    if (delta != null) {
                        delta.storeRemovedPlatformExtensionPoint(clazz, extensionPoint);
                    }
                }
                ++n2;
            }
        }
    }

    private void addPlatformBundle(String id, IPlatformBundle newPlatformBundle, PlatformExtensionPointDelta delta) {
        if (id == null || newPlatformBundle == null || newPlatformBundle.isEmpty()) {
            return;
        }
        IPlatformBundle existingPlatformBundle = this._platformBundles.get(id);
        if (existingPlatformBundle != null) {
            return;
        }
        this._platformBundles.put(id, newPlatformBundle);
        for (Class<? extends IPlatformExtensionPoint> clazz : PlatformManager.getExtensionPoints().values()) {
            IPlatformExtensionPoint[] iPlatformExtensionPointArray = newPlatformBundle.getPlatformExtensionPoints(clazz);
            int n = iPlatformExtensionPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                List<Object> extensionPoints;
                IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n2];
                if (newPlatformBundle.isTarget()) {
                    extensionPoints = this._targetRegistry.get(clazz);
                    if (extensionPoints == null) {
                        extensionPoints = new ArrayList<Object>();
                        this._targetRegistry.put(clazz, extensionPoints);
                    }
                    if (!extensionPoints.add(extensionPoint)) {
                        EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.addPlatformBundle(..) _ ''{0}'' unable to add Extension Point in target registry.", (Object)extensionPoint.getId()));
                    } else if (delta != null) {
                        delta.storeAddedPlatformExtensionPoint(clazz, extensionPoint);
                    }
                } else {
                    extensionPoints = this._workspaceRegistry.get(clazz);
                    if (extensionPoints == null) {
                        extensionPoints = new ArrayList<Object>();
                        this._workspaceRegistry.put(clazz, extensionPoints);
                    }
                    if (!extensionPoints.add(extensionPoint)) {
                        EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.addPlatformBundle(..) _ ''{0}'' unable to add Extension Point in workspace registry.", (Object)extensionPoint.getId()));
                    } else if (delta != null) {
                        delta.storeAddedPlatformExtensionPoint(clazz, extensionPoint);
                    }
                }
                ++n2;
            }
        }
    }

    private List<IPluginModelBase> getExtensionPointModels(ModelEntry entry) {
        UniqueEList plugins = new UniqueEList();
        IPluginModelBase[] iPluginModelBaseArray = entry.hasWorkspaceModels() ? entry.getWorkspaceModels() : entry.getExternalModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model.getExtensions(false) != null && model.getExtensions(false).getExtensions() != null) {
                IPluginExtension[] iPluginExtensionArray = model.getExtensions(false).getExtensions();
                int n3 = iPluginExtensionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginExtension extension = iPluginExtensionArray[n4];
                    Class<? extends IPlatformExtensionPoint> clazz = PlatformManager.getExtensionPoints().get(extension.getPoint());
                    if (clazz != null) {
                        plugins.add(model);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return plugins;
    }

    private void trace(IPlatformBundle[] platformBundles) {
        IPlatformBundle[] iPlatformBundleArray = platformBundles;
        int n = platformBundles.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformBundle platformBundle = iPlatformBundleArray[n2];
            EGFPlatformPlugin.getDefault().logInfo(platformBundle.toString(), 1);
            IPlatformExtensionPoint[] iPlatformExtensionPointArray = platformBundle.getPlatformExtensionPoints();
            int n3 = iPlatformExtensionPointArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n4];
                EGFPlatformPlugin.getDefault().logInfo("Contains: " + extensionPoint.toString(), 2);
                ++n4;
            }
            ++n2;
        }
    }

    private void trace(IPlatformExtensionPointDelta delta) {
        if (delta.getRemovedPlatformExtensionPoints().length > 0) {
            EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"PlatformManager Removed {0} Extension Point{1}.", (Object)delta.getRemovedPlatformExtensionPoints().length, (Object)(delta.getRemovedPlatformExtensionPoints().length < 2 ? "" : "s")));
            this.trace(delta.getRemovedPlatformExtensionPoints());
        }
        if (delta.getAddedPlatformExtensionPoints().length > 0) {
            EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"PlatformManager Added {0} Extension Point{1}.", (Object)delta.getAddedPlatformExtensionPoints().length, (Object)(delta.getAddedPlatformExtensionPoints().length < 2 ? "" : "s")));
            this.trace(delta.getAddedPlatformExtensionPoints());
        }
    }

    private void trace(IPlatformExtensionPoint[] extensionPoints) {
        IPlatformExtensionPoint[] iPlatformExtensionPointArray = extensionPoints;
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n2];
            EGFPlatformPlugin.getDefault().logInfo(extensionPoint.toString(), 1);
            EGFPlatformPlugin.getDefault().logInfo(extensionPoint.getPlatformBundle().toString(), 2);
            ++n2;
        }
    }
}

