/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public class FileHelper {
    public static void setContent(IFile file, String source) throws CoreException {
        FileHelper.setContent(file, new ByteArrayInputStream(source.getBytes()));
    }

    private static void setContent(IFile file, InputStream source) throws CoreException {
        if (file.exists()) {
            file.setContents(source, true, true, null);
        } else {
            FileHelper.createParentfolders(file.getProject(), file.getProjectRelativePath().removeLastSegments(1));
            file.create(source, true, null);
        }
    }

    private static void createParentfolders(IProject project, IPath folderPath) throws CoreException {
        if (folderPath.isEmpty()) {
            return;
        }
        IFolder folder = project.getFolder(folderPath);
        if (folder == null) {
            throw new IllegalStateException();
        }
        if (!folder.exists()) {
            FileHelper.createParentfolders(project, folderPath.removeLastSegments(1));
            folder.create(true, true, null);
        }
    }

    public static String getContent(String pluginId, IProject project, IPath templatePath) throws CoreException, IOException {
        IFile file = project.getFile(templatePath);
        if (file == null) {
            throw new IllegalStateException();
        }
        if (file.exists()) {
            return FileHelper.getFileContent(file);
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.fileHelper_error1, (Object)pluginId));
        }
        URL entry = bundle.getEntry(templatePath.toPortableString());
        if (entry == null) {
            throw new IllegalStateException(Messages.bind((String)Messages.fileHelper_error2, (Object)templatePath.toPortableString(), (Object)pluginId));
        }
        return FileHelper.getContent(entry.openStream());
    }

    public static String getContent(IPlatformFcore component, URI uri) throws CoreException, IOException {
        if (component == null) {
            throw new IllegalArgumentException(Messages.fileHelper_error3);
        }
        IProject project = component.getPlatformBundle().getProject();
        if (project != null) {
            IFile file = project.getFile(uri.path());
            if (file == null) {
                throw new IllegalStateException();
            }
            if (!file.exists()) {
                return "";
            }
            return FileHelper.getFileContent(file);
        }
        Bundle bundle = component.getPlatformBundle().getBundle();
        if (bundle == null) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.fileHelper_error1, (Object)component.getPlatformBundle().getBundleId()));
        }
        URL entry = bundle.getEntry(uri.path());
        if (entry == null) {
            throw new IllegalStateException(Messages.bind((String)Messages.fileHelper_error2, (Object)uri.toString(), (Object)component.getPlatformBundle().getBundleId()));
        }
        return FileHelper.getContent(entry.openStream());
    }

    private static String getFileContent(IFile file) throws CoreException, IOException {
        return FileHelper.getContent(file.getContents());
    }

    private static String getContent(InputStream contents) throws CoreException, IOException {
        byte[] buf = null;
        try {
            buf = new byte[contents.available()];
            contents.read(buf);
        }
        finally {
            if (contents != null) {
                contents.close();
            }
        }
        return new String(buf);
    }
}

