/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.plugin;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.core.pde.EGFPDEPlugin;
import org.eclipse.egf.core.pde.plugin.AbstractChangesCommand;
import org.eclipse.egf.core.pde.util.ExtensionHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginParent;

public abstract class AbstractExtensionChangesCommand
extends AbstractChangesCommand {
    protected IPluginExtension createExtension() {
        return ExtensionHelper.createExtension(this.getPluginModelBase(), this.getExtensionPointId());
    }

    protected void removeExtension(Object extensionChildIdValue_p) {
        ExtensionHelper.removePluginExtension(this.getExtensions(), this.getExtensionPointId(), this.getExtensionChildIdAttribute(), extensionChildIdValue_p);
    }

    protected IPluginElement[] getExtensionElementWithNodeName(String elementName_p, boolean createIfMissing_p) {
        IPluginExtension[] extensions;
        ArrayList<IPluginElement> result = new ArrayList<IPluginElement>(0);
        IExtensions extensionPart = this.getExtensions();
        String extensionPointId = this.getExtensionPointId();
        IPluginExtension[] iPluginExtensionArray = extensions = ExtensionHelper.getPluginExtension(extensionPart, extensionPointId);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension currentExtension = iPluginExtensionArray[n2];
            IPluginElement[] iPluginElementArray = ExtensionHelper.getPluginElement((IPluginParent)currentExtension, elementName_p);
            int n3 = iPluginElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPluginElement pluginElement = iPluginElementArray[n4];
                result.add(pluginElement);
                ++n4;
            }
            ++n2;
        }
        if (createIfMissing_p && result.isEmpty()) {
            result.add(ExtensionHelper.createPluginElement((IPluginParent)this.createExtension(), elementName_p));
        }
        return result.toArray(new IPluginElement[result.size()]);
    }

    protected IPluginElement createExtensionElementWithId(Object elementIdValue_p, boolean asChildIfOneIsFound) {
        String extensionPointId;
        IPluginElement element = null;
        IExtensions extensions = this.getExtensions();
        IPluginExtension[] pluginExtensions = ExtensionHelper.getPluginExtension(extensions, extensionPointId = this.getExtensionPointId());
        if (pluginExtensions != null) {
            int i = 0;
            while (i < pluginExtensions.length && element == null) {
                IPluginElement extensionChild = ExtensionHelper.getPluginElement((IPluginParent)pluginExtensions[i], this.getExtensionChildIdAttribute(), elementIdValue_p);
                if (extensionChild != null) {
                    element = extensionChild;
                }
                ++i;
            }
        }
        if (element == null) {
            IPluginExtension extension = null;
            if (asChildIfOneIsFound && pluginExtensions != null && pluginExtensions.length > 0) {
                extension = pluginExtensions[0];
            }
            if (extension == null) {
                extension = this.createExtension();
            }
            if ((element = ExtensionHelper.createPluginElement((IPluginParent)extension, this.getExtensionChildName())) != null) {
                try {
                    element.setAttribute(this.getExtensionChildIdAttribute(), elementIdValue_p.toString());
                }
                catch (CoreException ce) {
                    EGFPDEPlugin.getDefault().logError(NLS.bind((String)"AbstractExtensionChangesCommand.getExtensionElementWithId(..) _ '{0}'", (Object)ce.toString()), ce);
                    element = null;
                }
            }
        }
        return element;
    }

    protected IPluginElement getExtensionElementFromUniqueExtension(String childElementId_p) {
        return this.getExtensionElementFromUniqueExtension(childElementId_p, true);
    }

    protected IPluginElement getExtensionElementFromUniqueExtension(String childElementId_p, boolean createIfMissing_p) {
        String extensionPointId = this.getExtensionPointId();
        IPluginExtension[] extensions = this.getExtensions(extensionPointId);
        IPluginExtension extension = null;
        if (extensions.length == 0) {
            if (createIfMissing_p) {
                extension = this.createExtension();
            }
        } else {
            extension = extensions[0];
        }
        return this.getElement((IPluginParent)extension, this.getExtensionChildName(), this.getExtensionChildIdAttribute(), childElementId_p, createIfMissing_p);
    }

    protected IPluginExtension[] getExtensions(String extensionPointId_p) {
        return ExtensionHelper.getPluginExtension(this.getExtensions(), extensionPointId_p);
    }

    protected IPluginElement getElement(IPluginParent parent_p, String elementChildNodeName_p, String elementChildIdAttribute_p, String elementChildIdAttributeValue_p, boolean createIfMissing_p) {
        IPluginElement result = null;
        if (parent_p == null) {
            return result;
        }
        result = ExtensionHelper.getPluginElement(parent_p, elementChildIdAttribute_p, elementChildIdAttributeValue_p);
        if (result == null && createIfMissing_p) {
            result = ExtensionHelper.createPluginElement(parent_p, elementChildNodeName_p);
            try {
                result.setAttribute(elementChildIdAttribute_p, elementChildIdAttributeValue_p);
            }
            catch (CoreException ce) {
                EGFPDEPlugin.getDefault().logError(NLS.bind((String)"AbstractExtensionChangesCommand.getElement(..) _ '{0}'", (Object)ce.toString()), ce);
            }
        }
        return result;
    }

    protected IExtensions getExtensions() {
        IExtensions result = null;
        IPluginModelBase pluginModelBase = this.getPluginModelBase();
        if (pluginModelBase != null) {
            result = pluginModelBase.getExtensions();
        }
        return result;
    }

    protected IPluginElement getFirstExtensionElement() {
        IPluginElement result = null;
        IPluginElement[] extensionElements = this.getExtensionElementWithNodeName(this.getExtensionChildName(), false);
        if (extensionElements.length > 0) {
            result = extensionElements[0];
        }
        return result;
    }

    protected IPluginElement createExtensionElementChild(IPluginElement extension_p, String elementChildNodeName_p, String elementChildIdAttribute_p, String elementChildIdAttributeValue_p) {
        if (extension_p == null) {
            return null;
        }
        return this.getElement((IPluginParent)extension_p, elementChildNodeName_p, elementChildIdAttribute_p, elementChildIdAttributeValue_p, true);
    }

    protected boolean removeExtensionElementChild(IPluginElement extension_p, String elementChildIdAttribute_p, String elementChildAttributeValue_p) {
        boolean result = false;
        IPluginElement[] extensionElements = this.getExtensionElementWithNodeName(this.getExtensionChildName(), false);
        int matchingExtensionCount = extensionElements.length;
        if (matchingExtensionCount > 0) {
            int i = 0;
            while (i < matchingExtensionCount && !result) {
                result = ExtensionHelper.removePluginElement((IPluginParent)extensionElements[i], elementChildIdAttribute_p, elementChildAttributeValue_p);
                ++i;
            }
        }
        return result;
    }

    protected IPluginElement setSingleChild(IPluginParent parentElement_p, String childNodeName_p, String childIdAttribute_p, String childIdAttributeValue_p) {
        return this.getElement(parentElement_p, childNodeName_p, childIdAttribute_p, childIdAttributeValue_p, true);
    }

    protected void setDescription(IPluginElement parentElement_p, String idAttributeValue_p, String description_p) throws CoreException {
        String idAttributeName = this.getExtensionChildIdAttribute();
        String idAttributeValue = String.valueOf(idAttributeValue_p) + ".description";
        if (description_p != null) {
            IPluginElement descriptionElement = this.getElement((IPluginParent)parentElement_p, "description", idAttributeName, idAttributeValue, true);
            descriptionElement.setText(description_p);
            descriptionElement.setAttribute(idAttributeName, idAttributeValue);
        }
    }

    protected abstract String getExtensionPointId();

    protected abstract String getExtensionChildName();

    protected String getExtensionChildIdAttribute() {
        return "id";
    }
}

