/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.fprod.tasks;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.helper.ResourceHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.fprod.producer.context.ITaskProductionContext;
import org.eclipse.egf.fprod.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.fcore.ActivityContract;
import org.eclipse.egf.model.pattern.BundleAccessor;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.osgi.framework.Bundle;

public abstract class AbstractPatternTask
implements ITaskProduction {
    protected final PatternHelper helper = PatternHelper.createCollector();
    private Resource domainResource;

    public void preExecute(ITaskProductionContext context, IProgressMonitor monitor_p) throws InvocationException {
    }

    public void doExecute(ITaskProductionContext context, IProgressMonitor monitor_p) throws InvocationException {
    }

    public void postExecute(ITaskProductionContext context, IProgressMonitor monitor_p) throws InvocationException {
        this.helper.clear();
    }

    protected void writeContext(ITaskProductionContext context, PatternContext ctx) throws InvocationException {
        for (ActivityContract ac : context.getOutputValueKeys()) {
            context.setOutputValue((Object)ac.getName(), ctx.getValue(ac.getName()));
        }
        if (this.domainResource != null) {
            this.domainResource.unload();
            this.domainResource = null;
        }
    }

    protected void readContext(ITaskProductionContext context, PatternContext ctx) throws InvocationException {
        for (ActivityContract ac : context.getInputValueKeys()) {
            String name = ac.getName();
            if ("domain".equals(name)) {
                URI uri = (URI)context.getInputValue((Object)name, ac.getType().getType());
                ResourceSetImpl set = new ResourceSetImpl();
                this.domainResource = ResourceHelper.loadResource((ResourceSet)set, (URI)uri);
                ctx.setValue("domain", (Object)this.domainResource.getContents());
                continue;
            }
            ctx.setValue(name, context.getInputValue((Object)name, ac.getType().getType()));
        }
    }

    protected PatternContext createPatternContext(final ITaskProductionContext prodCtx) {
        return new PatternContext(new BundleAccessor(){

            public Bundle getBundle(String id) throws PatternException {
                try {
                    return prodCtx.getBundle(id);
                }
                catch (InvocationException e) {
                    throw new PatternException((Throwable)e);
                }
            }
        });
    }
}

