/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.CallTypeEnum;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ChooseCallPage;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ChooseKindPage;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ParameterMatchingPage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class OrchestrationWizard
extends Wizard
implements INewWizard {
    private ChooseKindPage chooseKindPage;
    private ChooseCallPage chooseCallPage;
    private ParameterMatchingPage parameterMatchingPage;
    private ISelection selection;
    private Pattern pattern;
    private Call selectCall;
    private CallTypeEnum defaultKind;
    private Object eidtItem;
    private TransactionalEditingDomain transactionalEditingDomain;

    public OrchestrationWizard(Pattern pattern, CallTypeEnum defaultKind, Object eidtItem, TransactionalEditingDomain transactionalEditingDomain) {
        this.setNeedsProgressMonitor(true);
        this.pattern = pattern;
        this.defaultKind = defaultKind;
        this.eidtItem = eidtItem;
        this.transactionalEditingDomain = transactionalEditingDomain;
    }

    public void addPages() {
        this.setWindowTitle(Messages.OrchestrationWizard_title);
        if (this.defaultKind.equals((Object)CallTypeEnum.Add)) {
            this.chooseKindPage = new ChooseKindPage(this.selection);
            this.addPage((IWizardPage)this.chooseKindPage);
        }
        this.chooseCallPage = new ChooseCallPage(this.pattern, this.selection, this.eidtItem);
        this.addPage((IWizardPage)this.chooseCallPage);
        if (this.defaultKind.equals((Object)CallTypeEnum.PATTERN_CALL) || this.defaultKind.equals((Object)CallTypeEnum.Add)) {
            this.parameterMatchingPage = new ParameterMatchingPage(this.selection, this.pattern, this.transactionalEditingDomain);
            Pattern patternCallee = null;
            if (this.eidtItem instanceof PatternCall) {
                patternCallee = ((PatternCall)this.eidtItem).getCalled();
            }
            this.parameterMatchingPage.setPatternCallee(patternCallee);
            this.addPage((IWizardPage)this.parameterMatchingPage);
        }
    }

    public boolean performFinish() {
        this.selectCall = this.chooseCallPage.getChooseCall();
        return true;
    }

    public boolean performCancel() {
        List<RecordingCommand> parameterMatchingCommands;
        if (this.parameterMatchingPage != null && this.eidtItem != null && (parameterMatchingCommands = this.parameterMatchingPage.getParameterMatchingCommands()) != null) {
            Iterator<RecordingCommand> iterator = parameterMatchingCommands.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                if (!this.transactionalEditingDomain.getCommandStack().canUndo()) continue;
                this.transactionalEditingDomain.getCommandStack().undo();
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public Call getSelectCall() {
        return this.selectCall;
    }

    public CallTypeEnum getDefaultKind() {
        return this.defaultKind;
    }
}

