/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table;

import java.util.concurrent.CompletableFuture;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.process.OpenCompareProcess;
import org.eclipse.egerrit.internal.ui.editors.ModelLoader;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.table.filter.CommentsFilter;
import org.eclipse.egerrit.internal.ui.table.filter.CommitMsgFileFilter;
import org.eclipse.egerrit.internal.ui.table.filter.DeletedFilesFilter;
import org.eclipse.egerrit.internal.ui.table.filter.ReviewedFilesFilter;
import org.eclipse.egerrit.internal.ui.table.model.FilesTableModel;
import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.egerrit.internal.ui.table.model.ReviewTableSorter;
import org.eclipse.egerrit.internal.ui.table.provider.DynamicMenuBuilder;
import org.eclipse.egerrit.internal.ui.table.provider.FileTableLabelProvider;
import org.eclipse.egerrit.internal.ui.table.provider.HandleFileSelection;
import org.eclipse.egerrit.internal.ui.utils.PersistentStorage;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class UIFilesTable {
    private boolean popupEnabled = true;
    private boolean filterDeletedFiles = false;
    private boolean filterCommitMsgFile = false;
    private boolean filterReviewedFile = false;
    private boolean filterCommentedFile = false;
    public static final String FILES_TABLE = "filesTable";
    private static final int TABLE_STYLE = 66304;
    private TableViewer fViewer = null;
    private GerritClient fGerritClient;
    private ChangeInfo fChangeInfo;
    private ModelLoader loader;
    private DynamicMenuBuilder dynamicMenu = new DynamicMenuBuilder();
    private DeletedFilesFilter fileDeleteFilter = new DeletedFilesFilter();
    private CommitMsgFileFilter commitFileFilter = new CommitMsgFileFilter();
    private ReviewedFilesFilter reviewedFileFilter = new ReviewedFilesFilter();
    private CommentsFilter commentedFileFilter = new CommentsFilter();
    private ViewerFilter searchFilter = null;
    private String searchString = "";
    private RevisionInfo fRevisionInfo;
    private String storageSectionName;
    private PersistentStorage persistStorage;

    public UIFilesTable(GerritClient gerritClient, ChangeInfo changeInfo, String name) {
        this.fGerritClient = gerritClient;
        this.fChangeInfo = changeInfo;
        this.storageSectionName = name;
        this.loader = ModelLoader.initialize(gerritClient, changeInfo);
        this.loader.loadCurrentRevision();
    }

    public UIFilesTable(GerritClient gerritClient, RevisionInfo revisionInfo, String name) {
        this.fGerritClient = gerritClient;
        this.fRevisionInfo = revisionInfo;
        this.storageSectionName = name;
    }

    public TableViewer createTableViewerSection(Composite aParent) {
        this.fViewer = new TableViewer(aParent, 68354);
        this.buildAndLayoutTable();
        this.adjustTableData();
        ReviewTableSorter.bind(this.fViewer);
        this.fViewer.setComparator((ViewerComparator)new ReviewTableSorter(2));
        this.persistStorage = new PersistentStorage((Viewer)this.fViewer, this.storageSectionName);
        this.persistStorage.restoreDialogSettings();
        return this.fViewer;
    }

    public void enablePopup(boolean value) {
        this.popupEnabled = value;
    }

    public void enableDeletedFilesFilter(boolean value) {
        this.filterDeletedFiles = value;
        if (this.fViewer != null) {
            if (this.filterDeletedFiles) {
                this.fViewer.addFilter((ViewerFilter)this.fileDeleteFilter);
            } else {
                this.fViewer.removeFilter((ViewerFilter)this.fileDeleteFilter);
            }
        }
    }

    public void enableCommitMsgFilter(boolean value) {
        this.filterCommitMsgFile = value;
        if (this.fViewer != null) {
            if (this.filterCommitMsgFile) {
                this.fViewer.addFilter((ViewerFilter)this.commitFileFilter);
            } else {
                this.fViewer.removeFilter((ViewerFilter)this.commitFileFilter);
            }
        }
    }

    public void enableReviewedFilesFilter(boolean value) {
        this.filterReviewedFile = value;
        if (this.fViewer != null) {
            if (this.filterReviewedFile) {
                this.fViewer.addFilter((ViewerFilter)this.reviewedFileFilter);
            } else {
                this.fViewer.removeFilter((ViewerFilter)this.reviewedFileFilter);
            }
        }
    }

    public void enableCommentedFilesFilter(boolean value) {
        this.filterCommentedFile = value;
        if (this.fViewer != null) {
            if (this.filterCommentedFile) {
                this.fViewer.addFilter((ViewerFilter)this.commentedFileFilter);
            } else {
                this.fViewer.removeFilter((ViewerFilter)this.commentedFileFilter);
            }
        }
    }

    public void filterFileText(String fileString) {
        this.searchString = fileString.toLowerCase();
        if (fileString.isEmpty()) {
            if (this.searchFilter != null) {
                this.fViewer.removeFilter(this.searchFilter);
                this.searchFilter = null;
            }
        } else {
            if (this.searchFilter == null) {
                this.searchFilter = this.createSearchFilter();
            }
            this.fViewer.addFilter(this.searchFilter);
            if (this.fViewer.getTable().getItemCount() >= 1) {
                this.fViewer.getTable().select(0);
            }
        }
    }

    public ViewerFilter getSearchingFilter() {
        return this.searchFilter;
    }

    private ViewerFilter createSearchFilter() {
        this.searchFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String file = ((StringToFileInfoImpl)element).getKey().toLowerCase();
                return file.contains(UIFilesTable.this.searchString);
            }
        };
        return this.searchFilter;
    }

    private void buildAndLayoutTable() {
        Table table = this.fViewer.getTable();
        FilesTableModel[] tableInfo = FilesTableModel.values();
        int size = tableInfo.length;
        int index = 0;
        while (index < size) {
            this.createTableViewerColumn(tableInfo[index]);
            ++index;
        }
        GridData gribData = new GridData(4, 4, true, true);
        gribData.minimumWidth = tableInfo[0].getWidth();
        this.fViewer.getTable().setLayoutData((Object)gribData);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setData((Object)FILES_TABLE);
        this.dynamicMenu.addPulldownMenu((ColumnViewer)this.fViewer, this.fGerritClient, this.popupEnabled);
        this.enableDeletedFilesFilter(this.filterDeletedFiles);
        this.enableCommitMsgFilter(this.filterCommitMsgFile);
        this.enableReviewedFilesFilter(this.filterReviewedFile);
        this.enableCommentedFilesFilter(this.filterCommentedFile);
    }

    private TableViewerColumn createTableViewerColumn(ITableModel tableInfo) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(tableInfo.getName());
        column.setWidth(tableInfo.getWidth());
        column.setAlignment(tableInfo.getAlignment());
        column.setResizable(tableInfo.getResize());
        column.setMoveable(tableInfo.getMoveable());
        column.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                UIFilesTable.this.persistStorage.storeDialogSettings();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    private void adjustTableData() {
        this.fViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 10, 1));
        IDoubleClickListener doubleClickListener = event -> {
            if (!this.popupEnabled) {
                HandleFileSelection handleSelection = new HandleFileSelection(this.fGerritClient, (ColumnViewer)this.fViewer);
                handleSelection.showFileSelection();
            } else {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object element = sel.getFirstElement();
                if (element instanceof StringToFileInfoImpl) {
                    FileInfo selectedFile = ((StringToFileInfoImpl)element).getValue();
                    OpenCompareProcess openCompare = new OpenCompareProcess();
                    openCompare.handleOpenCompare(this.fViewer.getTable().getShell(), this.fGerritClient, this.fChangeInfo, selectedFile, this.fChangeInfo.getUserSelectedRevision());
                }
            }
        };
        this.fViewer.addDoubleClickListener(doubleClickListener);
        if (!this.fGerritClient.getRepository().getServerInfo().isAnonymous()) {
            this.fViewer.getTable().addMouseListener((MouseListener)this.toggleReviewedStateListener());
        }
        this.filesTabDataBindings();
    }

    public void setDialogSelection() {
        this.fViewer.getTable().select(0);
    }

    private MouseAdapter toggleReviewedStateListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ISelection selection;
                ViewerCell viewerCell = UIFilesTable.this.fViewer.getCell(new Point(e.x, e.y));
                if (viewerCell != null && viewerCell.getColumnIndex() == 0 && (selection = UIFilesTable.this.fViewer.getSelection()) instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object element = structuredSelection.getFirstElement();
                    FileInfo fileInfo = ((StringToFileInfoImpl)element).getValue();
                    UIFilesTable.this.toggleReviewed(fileInfo);
                }
            }
        };
    }

    private void toggleReviewed(FileInfo fileInfo) {
        CompletableFuture.runAsync(() -> {
            if (fileInfo.isReviewed()) {
                QueryHelpers.markAsNotReviewed(this.fGerritClient, fileInfo);
            } else {
                QueryHelpers.markAsReviewed(this.fGerritClient, fileInfo);
            }
        });
    }

    private void filesTabDataBindings() {
        if (this.fViewer != null) {
            FeaturePath reviewed = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.STRING_TO_FILE_INFO__VALUE, ModelPackage.Literals.FILE_INFO__REVIEWED});
            FeaturePath commentsCount = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.STRING_TO_FILE_INFO__VALUE, ModelPackage.Literals.FILE_INFO__COMMENTS_COUNT});
            FeaturePath draftCount = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.STRING_TO_FILE_INFO__VALUE, ModelPackage.Literals.FILE_INFO__DRAFTS_COUNT});
            ObservableListContentProvider contentProvider = new ObservableListContentProvider();
            this.fViewer.setContentProvider((IContentProvider)contentProvider);
            IObservableMap[] watchedProperties = Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])new IValueProperty[]{EMFProperties.value((FeaturePath)reviewed), EMFProperties.value((FeaturePath)commentsCount), EMFProperties.value((FeaturePath)draftCount)});
            this.fViewer.setLabelProvider((IBaseLabelProvider)new FileTableLabelProvider(watchedProperties));
            IObservableList revisionFiles = null;
            if (this.fChangeInfo != null) {
                FeaturePath changerev = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__USER_SELECTED_REVISION, ModelPackage.Literals.REVISION_INFO__FILES});
                revisionFiles = EMFProperties.list((FeaturePath)changerev).observe((Object)this.fChangeInfo);
            } else {
                revisionFiles = EMFObservables.observeList((EObject)this.fRevisionInfo, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__FILES);
            }
            this.fViewer.setInput((Object)revisionFiles);
        }
    }

    public void dispose() {
        this.loader.dispose();
    }

    public IDialogSettings getDialogSettings() {
        if (this.persistStorage == null) {
            this.persistStorage = new PersistentStorage((Viewer)this.fViewer, this.storageSectionName);
        }
        return this.persistStorage.getDialogSettings(this.storageSectionName);
    }
}

