/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core;

import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.command.AbandonCommand;
import org.eclipse.egerrit.internal.core.command.AddReviewerCommand;
import org.eclipse.egerrit.internal.core.command.ChangeCommitMsgCommand;
import org.eclipse.egerrit.internal.core.command.CherryPickRevisionCommand;
import org.eclipse.egerrit.internal.core.command.CreateDraftCommand;
import org.eclipse.egerrit.internal.core.command.DeleteDraftChangeCommand;
import org.eclipse.egerrit.internal.core.command.DeleteDraftCommand;
import org.eclipse.egerrit.internal.core.command.DeleteDraftRevisionCommand;
import org.eclipse.egerrit.internal.core.command.DeleteReviewedCommand;
import org.eclipse.egerrit.internal.core.command.DeleteReviewerCommand;
import org.eclipse.egerrit.internal.core.command.DeleteTopicCommand;
import org.eclipse.egerrit.internal.core.command.GetChangeCommand;
import org.eclipse.egerrit.internal.core.command.GetCommitMsgCommand;
import org.eclipse.egerrit.internal.core.command.GetContentCommand;
import org.eclipse.egerrit.internal.core.command.GetContentFromCommitCommand;
import org.eclipse.egerrit.internal.core.command.GetDiffCommand;
import org.eclipse.egerrit.internal.core.command.GetFilesCommand;
import org.eclipse.egerrit.internal.core.command.GetIncludedInCommand;
import org.eclipse.egerrit.internal.core.command.GetMergeableCommand;
import org.eclipse.egerrit.internal.core.command.GetModifiedFilesCommand;
import org.eclipse.egerrit.internal.core.command.GetRelatedChangesCommand;
import org.eclipse.egerrit.internal.core.command.GetReviewedFilesCommand;
import org.eclipse.egerrit.internal.core.command.GetRevisionActionsCommand;
import org.eclipse.egerrit.internal.core.command.ListBranchesCommand;
import org.eclipse.egerrit.internal.core.command.ListCommentsCommand;
import org.eclipse.egerrit.internal.core.command.ListDraftsCommand;
import org.eclipse.egerrit.internal.core.command.ListProjectsCommand;
import org.eclipse.egerrit.internal.core.command.ListReviewersCommand;
import org.eclipse.egerrit.internal.core.command.PublishChangeEditCommand;
import org.eclipse.egerrit.internal.core.command.PublishDraftChangeCommand;
import org.eclipse.egerrit.internal.core.command.QueryChangesCommand;
import org.eclipse.egerrit.internal.core.command.RebaseRevisionCommand;
import org.eclipse.egerrit.internal.core.command.RestoreCommand;
import org.eclipse.egerrit.internal.core.command.RevertCommand;
import org.eclipse.egerrit.internal.core.command.SetReviewCommand;
import org.eclipse.egerrit.internal.core.command.SetReviewedCommand;
import org.eclipse.egerrit.internal.core.command.SetTopicCommand;
import org.eclipse.egerrit.internal.core.command.StarChangeCommand;
import org.eclipse.egerrit.internal.core.command.SubmitCommand;
import org.eclipse.egerrit.internal.core.command.SuggestAccountCommand;
import org.eclipse.egerrit.internal.core.command.SuggestReviewersCommand;
import org.eclipse.egerrit.internal.core.command.UnstarChangeCommand;
import org.eclipse.egerrit.internal.core.command.UpdateDraftCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.FileInfo;

public abstract class GerritClient {
    private final GerritRepository fGerritRepository;

    protected GerritClient(GerritRepository gerritRepository) throws EGerritException {
        if (gerritRepository == null) {
            throw new EGerritException("Invalid gerrit repository");
        }
        this.fGerritRepository = gerritRepository;
    }

    public GerritRepository getRepository() {
        return this.fGerritRepository;
    }

    public QueryChangesCommand queryChanges() {
        return new QueryChangesCommand(this.fGerritRepository);
    }

    public GetChangeCommand getChange(String id) {
        return new GetChangeCommand(this.fGerritRepository, id);
    }

    public GetContentCommand getContent(String id, String revision, String file) {
        return new GetContentCommand(this.fGerritRepository, id, revision, file);
    }

    public GetCommitMsgCommand getCommitMsg(String changeId, String commitId) {
        return new GetCommitMsgCommand(this.fGerritRepository, changeId, commitId);
    }

    public GetMergeableCommand getMergeable(ChangeInfo change) {
        return new GetMergeableCommand(this.fGerritRepository, change, null);
    }

    public ListReviewersCommand getReviewers(String changeId) {
        return new ListReviewersCommand(this.fGerritRepository, changeId);
    }

    public SuggestReviewersCommand suggestReviewers(String changeId) {
        return new SuggestReviewersCommand(this.fGerritRepository, changeId);
    }

    public SuggestAccountCommand suggestAccount() {
        return new SuggestAccountCommand(this.fGerritRepository);
    }

    public GetIncludedInCommand getIncludedIn(String changeId) {
        return new GetIncludedInCommand(this.fGerritRepository, changeId);
    }

    public GetRelatedChangesCommand getRelatedChanges(String id, String revision) {
        return new GetRelatedChangesCommand(this.fGerritRepository, id, revision);
    }

    public ListCommentsCommand getListComments(String changeId, String revisionId) {
        return new ListCommentsCommand(this.fGerritRepository, changeId, revisionId);
    }

    public CreateDraftCommand createDraftComments(String changeId, String revisionId) {
        return new CreateDraftCommand(this.fGerritRepository, changeId, revisionId);
    }

    public SetReviewCommand setReview(String changeId, String revisionId) {
        return new SetReviewCommand(this.fGerritRepository, changeId, revisionId);
    }

    public ListDraftsCommand listDraftsComments(String changeId, String revisionId) {
        return new ListDraftsCommand(this.fGerritRepository, changeId, revisionId);
    }

    public ListProjectsCommand listProjects() {
        return new ListProjectsCommand(this.fGerritRepository);
    }

    public SubmitCommand submit(String changeId) {
        return new SubmitCommand(this.fGerritRepository, changeId);
    }

    public AbandonCommand abandon(String changeId) {
        return new AbandonCommand(this.fGerritRepository, changeId);
    }

    public RestoreCommand restore(String changeId) {
        return new RestoreCommand(this.fGerritRepository, changeId);
    }

    public AddReviewerCommand addReviewer(String changeId) {
        return new AddReviewerCommand(this.fGerritRepository, changeId);
    }

    public DeleteReviewerCommand deleteReviewer(String changeId, String accountId) {
        return new DeleteReviewerCommand(this.fGerritRepository, changeId, accountId);
    }

    public DeleteDraftCommand deleteDraft(String changeId, String revisionId, String draftId) {
        return new DeleteDraftCommand(this.fGerritRepository, changeId, revisionId, draftId);
    }

    public UpdateDraftCommand updateDraftComments(String changeId, String revisionId, String draftId) {
        return new UpdateDraftCommand(this.fGerritRepository, changeId, revisionId, draftId);
    }

    public GetContentFromCommitCommand getContentFromCommit(String project, String commitId, String fileId) {
        return new GetContentFromCommitCommand(this.fGerritRepository, project, commitId, fileId);
    }

    public GetRevisionActionsCommand getRevisionActions(String changeId, String currentRevision) {
        return new GetRevisionActionsCommand(this.fGerritRepository, changeId, currentRevision);
    }

    public ListBranchesCommand listBranches(String project) {
        return new ListBranchesCommand(this.fGerritRepository, project);
    }

    public CherryPickRevisionCommand cherryPickRevision(String changeId, String revisionId) {
        return new CherryPickRevisionCommand(this.fGerritRepository, changeId, revisionId);
    }

    public ChangeCommitMsgCommand editMessage(String changeId) {
        return new ChangeCommitMsgCommand(this.fGerritRepository, changeId);
    }

    public PublishChangeEditCommand publishChangeEdit(String changeId) {
        return new PublishChangeEditCommand(this.fGerritRepository, changeId);
    }

    public SetReviewedCommand setReviewed(String changeId, String revisionId, FileInfo file) {
        return new SetReviewedCommand(this.fGerritRepository, changeId, revisionId, file);
    }

    public DeleteReviewedCommand deleteReviewed(String changeId, String revisionId, FileInfo file) {
        return new DeleteReviewedCommand(this.fGerritRepository, changeId, revisionId, file);
    }

    public GetReviewedFilesCommand getReviewed(String changeId, String revisionId) {
        return new GetReviewedFilesCommand(this.fGerritRepository, changeId, revisionId);
    }

    public SetTopicCommand setTopic(String changeId) {
        return new SetTopicCommand(this.fGerritRepository, changeId);
    }

    public DeleteTopicCommand deleteTopic(String changeId) {
        return new DeleteTopicCommand(this.fGerritRepository, changeId);
    }

    public RevertCommand revert(String changeId) {
        return new RevertCommand(this.fGerritRepository, changeId);
    }

    public DeleteDraftChangeCommand deleteDraftChange(String changeId) {
        return new DeleteDraftChangeCommand(this.fGerritRepository, changeId);
    }

    public PublishDraftChangeCommand publishDraftChange(String changeId) {
        return new PublishDraftChangeCommand(this.fGerritRepository, changeId);
    }

    public DeleteDraftRevisionCommand deleteDraftRevision(String changeId, String commitId) {
        return new DeleteDraftRevisionCommand(this.fGerritRepository, changeId, commitId);
    }

    public GetModifiedFilesCommand getFilesModifiedSince(String changeId, String revisionId, String compareAgainst) {
        return new GetModifiedFilesCommand(this.fGerritRepository, changeId, revisionId, compareAgainst);
    }

    public GetFilesCommand getFiles(String changeId, String revisionId) {
        return new GetFilesCommand(this.fGerritRepository, changeId, revisionId);
    }

    public StarChangeCommand starChange(ChangeInfo changeInfo) {
        return new StarChangeCommand(this.fGerritRepository, changeInfo);
    }

    public UnstarChangeCommand unstarChange(ChangeInfo changeInfo) {
        return new UnstarChangeCommand(this.fGerritRepository, changeInfo);
    }

    public RebaseRevisionCommand rebase(String changeId, String revisionId) {
        return new RebaseRevisionCommand(this.fGerritRepository, changeId, revisionId);
    }

    public GetDiffCommand getDiff(String changeId, String revisionId, String fileName, int base) {
        return new GetDiffCommand(this.fGerritRepository, changeId, revisionId, fileName, base);
    }
}

