/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.process;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.SetReviewCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.ReviewInput;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.LabelInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.swt.widgets.Shell;

public class ReplyProcess {
    private static final String CODE_REVIEW = "Code-Review";
    private ChangeInfo changeInfo = null;
    private GerritClient gerritClient = null;

    public void handleReplyDialog(Shell shell, ChangeInfo changeInfo, GerritClient gerritClient, RevisionInfo selectedRevision) {
        UIUtils.replyToChange(shell, selectedRevision, null, gerritClient, false);
        CompletableFuture.runAsync(() -> QueryHelpers.loadBasicInformation(gerritClient, changeInfo, false)).thenRun(() -> changeInfo.setUserSelectedRevision(selectedRevision));
    }

    public void handleReplyPlus2(RevisionInfo selectedRevision) {
        ReviewInput reviewInput = new ReviewInput();
        reviewInput.setDrafts("PUBLISH");
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put(CODE_REVIEW, Messages.ReplyProcess_PlusTwo);
        reviewInput.setLabels(obj);
        this.postReply(reviewInput, selectedRevision);
    }

    public boolean isCRPlusTwoAllowed(ChangeInfo changeInfo, GerritClient gerritClient, RevisionInfo revision) {
        String psSelectedID;
        this.changeInfo = changeInfo;
        this.gerritClient = gerritClient;
        int maxCRPermitted = this.findMaxPermitted(CODE_REVIEW);
        int maxCRDefined = this.findMaxDefinedLabelValue(CODE_REVIEW);
        boolean allowPlus2 = false;
        if (maxCRDefined == maxCRPermitted && maxCRPermitted > 0) {
            allowPlus2 = true;
        }
        if (allowPlus2 && ((psSelectedID = revision.getId()) == null || changeInfo.getLatestPatchSet().getId().compareTo(psSelectedID) != 0)) {
            allowPlus2 = false;
        }
        return !revision.isSubmitable() && allowPlus2;
    }

    private int findMaxPermitted(String label) {
        int maxPermitted = 0;
        EList listPermitted = null;
        EMap mapLabels = this.changeInfo.getPermitted_labels();
        if (mapLabels != null) {
            for (Map.Entry permittedlabel : mapLabels.entrySet()) {
                listPermitted = (EList)permittedlabel.getValue();
                if (((String)permittedlabel.getKey()).compareTo(label) != 0) continue;
                for (String element2 : listPermitted) {
                    maxPermitted = Math.max(maxPermitted, new Integer(element2.trim()));
                }
            }
        }
        return maxPermitted;
    }

    private int findMaxDefinedLabelValue(String label) {
        Iterator iterator = this.changeInfo.getLabels().entrySet().iterator();
        int maxDefined = 0;
        while (iterator.hasNext()) {
            Map.Entry definedlabel = (Map.Entry)iterator.next();
            if (((String)definedlabel.getKey()).compareTo(label) != 0) continue;
            for (String element2 : ((LabelInfo)definedlabel.getValue()).getValues().keySet()) {
                maxDefined = Math.max(maxDefined, new Integer(element2.trim()));
            }
        }
        return maxDefined;
    }

    private void postReply(ReviewInput reviewInput, RevisionInfo selectedRevision) {
        if (this.changeInfo != null && this.gerritClient != null) {
            SetReviewCommand reviewToEmit = this.gerritClient.setReview(this.changeInfo.getId(), selectedRevision.getId());
            reviewToEmit.setCommandInput((Object)reviewInput);
            try {
                reviewToEmit.call();
                CompletableFuture.runAsync(() -> QueryHelpers.loadBasicInformation(this.gerritClient, this.changeInfo, false)).thenRun(() -> this.changeInfo.setUserSelectedRevision(selectedRevision));
            }
            catch (EGerritException e1) {
                EGerritCorePlugin.logError((String)(String.valueOf(this.gerritClient.getRepository().formatGerritVersion()) + e1.getMessage()));
            }
        }
    }
}

