/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.table.model.FilesTableModel;
import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.egerrit.internal.ui.table.provider.FileInfoCompareCellLabelProvider;
import org.eclipse.egerrit.internal.ui.table.provider.FileTableLabelProvider;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

public class DynamicMenuBuilder {
    private Menu commonMenu;
    private HashMap<ITableModel, TreeViewerColumn> treeViewerColumn = new HashMap();
    private FileTableLabelProvider tableLabelProvider;

    public HashMap<ITableModel, TreeViewerColumn> getTreeViewerColumn() {
        return this.treeViewerColumn;
    }

    public void addPulldownMenu(final ColumnViewer viewer, final GerritClient client) {
        MenuManager menuManager = new MenuManager();
        if (viewer instanceof TableViewer) {
            this.commonMenu = menuManager.createContextMenu((Control)((TableViewer)viewer).getTable());
            ((TableViewer)viewer).getTable().setMenu(this.commonMenu);
        } else if (viewer instanceof DiffTreeViewer) {
            this.commonMenu = menuManager.createContextMenu(((DiffTreeViewer)viewer).getControl());
            ((DiffTreeViewer)viewer).getControl().setMenu(this.commonMenu);
        }
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DynamicMenuBuilder.this.addMenuItem(DynamicMenuBuilder.this.commonMenu, viewer, client);
            }
        });
        menuManager.update(true);
    }

    private void addMenuItem(Menu menu, final ColumnViewer viewer, final GerritClient client) {
        if (menu.getItemCount() == 0) {
            MenuItem openFile = new MenuItem(menu, 8);
            openFile.setText(Messages.UIFilesTable_0);
            if (viewer instanceof TableViewer) {
                this.tableLabelProvider = (FileTableLabelProvider)viewer.getLabelProvider();
                openFile.setSelection(this.tableLabelProvider.getFileOrder());
            }
            openFile.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = viewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                        Iterator itr = structuredSelection.iterator();
                        String failedFiles = "";
                        while (itr.hasNext()) {
                            Object element = itr.next();
                            if (element == null) {
                                return;
                            }
                            FileInfo fileInfo = viewer instanceof TableViewer ? ((StringToFileInfoImpl)element).getValue() : ((GerritDiffNode)((Object)element)).getFileInfo();
                            String status = fileInfo.getStatus();
                            if (status.compareTo("D") == 0) continue;
                            if (viewer instanceof TableViewer) {
                                if (UIUtils.openSingleFile(((StringToFileInfoImpl)element).getKey(), client, fileInfo.getRevision(), 0)) continue;
                                failedFiles = String.valueOf(failedFiles) + fileInfo.getPath() + "\n";
                                continue;
                            }
                            if (UIUtils.openSingleFile(((StringToFileInfoImpl)fileInfo.eContainer()).getKey(), client, fileInfo.getRevision(), 0)) continue;
                            failedFiles = String.valueOf(failedFiles) + fileInfo.getPath() + "\n";
                        }
                        if (!failedFiles.isEmpty()) {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            UIUtils.displayInformation(shell, Messages.UIFilesTable_2, failedFiles);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            MenuItem nameFirst = new MenuItem(menu, 32);
            nameFirst.setText(Messages.UIFilesTable_1);
            if (viewer instanceof TableViewer) {
                nameFirst.setSelection(this.tableLabelProvider.getFileOrder());
            } else {
                nameFirst.setSelection(((FileInfoCompareCellLabelProvider)viewer.getLabelProvider()).getFileOrder());
            }
            nameFirst.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.getSource();
                    if (viewer instanceof TableViewer) {
                        DynamicMenuBuilder.this.tableLabelProvider.setFileNameFirst(menuItem.getSelection());
                    } else {
                        ((FileInfoCompareCellLabelProvider)viewer.getLabelProvider()).setFileNameFirst(menuItem.getSelection());
                    }
                    viewer.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.addVisibleColumnSelection(menu, viewer);
        }
    }

    private void addVisibleColumnSelection(Menu menu, final ColumnViewer viewer) {
        FilesTableModel[] tableInfo;
        new MenuItem(menu, 2);
        MenuItem visible = new MenuItem(menu, 64);
        visible.setText("Visible column");
        FilesTableModel[] filesTableModelArray = tableInfo = FilesTableModel.values();
        int n = tableInfo.length;
        int n2 = 0;
        while (n2 < n) {
            FilesTableModel element = filesTableModelArray[n2];
            MenuItem menuItem = new MenuItem(menu, 32);
            if (element.getName().isEmpty()) {
                menuItem.setText("Column: " + element.ordinal());
            } else {
                menuItem.setText(element.getName());
            }
            menuItem.setData((Object)element);
            menuItem.setSelection(element.isColumnVisible());
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TreeViewerColumn columnName;
                    MenuItem subMenuItem = (MenuItem)e.getSource();
                    FilesTableModel tablemodel = (FilesTableModel)subMenuItem.getData();
                    tablemodel.setColumnVisible(subMenuItem.getSelection());
                    if (viewer instanceof TableViewer) {
                        ((TableViewer)viewer).getTable().getColumn(tablemodel.ordinal()).setWidth(tablemodel.getWidth());
                    } else if (viewer instanceof DiffTreeViewer && (columnName = (TreeViewerColumn)DynamicMenuBuilder.this.treeViewerColumn.get(tablemodel)) != null) {
                        TreeColumn column = columnName.getColumn();
                        column.setWidth(tablemodel.getWidth());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++n2;
        }
    }
}

