/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ApprovalInfo;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.LabelInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ReplyDialog
extends InputDialog {
    private EMap<String, LabelInfo> labelsInfo;
    private EMap<String, EList<String>> permitted_labels;
    private Composite keyComposite;
    private Composite radioButtonComposite;
    private Composite detailTextComposite;
    private ScrolledComposite scrolledDraftArea;
    private final String DISPLAYWIDGET = "displayWidget";
    private LinkedHashMap<String, String> previousVotes = new LinkedHashMap();
    private RevisionInfo fRevisionInfo;
    private GerritClient fGerritClient;
    private static final int WIDTH = 650;

    public ReplyDialog(Shell shell, String reason, RevisionInfo revisionToReplyTo, GerritClient gerritClient) {
        super(shell, Messages.ReplyDialog_0, ReplyDialog.buildMessage(reason, revisionToReplyTo), null, null);
        this.fRevisionInfo = revisionToReplyTo;
        this.fGerritClient = gerritClient;
        this.permitted_labels = revisionToReplyTo.getChangeInfo().getPermitted_labels();
        this.labelsInfo = revisionToReplyTo.getChangeInfo().getLabels();
        boolean isVoteAllowed = revisionToReplyTo.getId().equals(revisionToReplyTo.getChangeInfo().getCurrent_revision());
        if (!isVoteAllowed) {
            this.labelsInfo = null;
        }
    }

    private static String buildMessage(String reason, RevisionInfo revisionToReplyTo) {
        if (reason == null) {
            return ReplyDialog.buildDefaultMessage(revisionToReplyTo);
        }
        return String.valueOf(reason) + ReplyDialog.buildDefaultMessage(revisionToReplyTo);
    }

    private static String buildDefaultMessage(RevisionInfo revisionToReplyTo) {
        return String.valueOf(Messages.ReplyDialog_1) + UIUtils.getPatchSetString(revisionToReplyTo);
    }

    protected int getInputTextStyle() {
        return 2626;
    }

    protected int getShellStyle() {
        return 1232;
    }

    protected Control createDialogArea(final Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridData)this.getText().getLayoutData()).heightHint = 100;
        ((GridData)this.getText().getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.getText().getLayoutData()).verticalAlignment = 4;
        this.createMessageArea(composite);
        if (this.labelsInfo != null) {
            this.createMiddleRadioSection(composite);
        }
        parent.getShell().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Point size = parent.getShell().computeSize(650, -1);
                parent.getShell().setMinimumSize(size);
                parent.getShell().setSize(size);
                if (ReplyDialog.this.hasDrafts(ReplyDialog.this.fRevisionInfo)) {
                    ReplyDialog.this.scrolledDraftArea.layout();
                }
                parent.getShell().removeControlListener((ControlListener)this);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return parent;
    }

    private boolean hasDrafts(RevisionInfo revInfo) {
        Collection files = revInfo.getFiles().values();
        for (FileInfo fileInfo : files) {
            if (fileInfo.getDraftComments().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void createMessageArea(Composite parent) {
        if (this.hasDrafts(this.fRevisionInfo)) {
            this.scrolledDraftArea = new ScrolledComposite(parent, 768);
            GridData grid = new GridData(1808);
            grid.heightHint = 100;
            this.scrolledDraftArea.setLayoutData((Object)grid);
            final Composite composite = new Composite((Composite)this.scrolledDraftArea, 0);
            GridLayout gl_composite = new GridLayout(1, false);
            gl_composite.marginTop = 0;
            gl_composite.marginHeight = 0;
            composite.setLayout((Layout)gl_composite);
            GridData gd_composite = new GridData(4, 4, true, true, 1, 1);
            gd_composite.heightHint = 150;
            composite.setLayoutData((Object)gd_composite);
            composite.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    Rectangle size = composite.getParent().getClientArea();
                    composite.setSize(composite.computeSize(size.width, -1));
                    ReplyDialog.this.scrolledDraftArea.setMinWidth(size.x);
                    Rectangle compoHeight = composite.getBounds();
                    ReplyDialog.this.scrolledDraftArea.setMinHeight(compoHeight.height);
                }

                public void controlMoved(ControlEvent e) {
                }
            });
            this.createLink(composite);
            this.scrolledDraftArea.setContent((Control)composite);
            Point p = composite.computeSize(-1, -1, true);
            this.scrolledDraftArea.setMinHeight(p.y);
            this.scrolledDraftArea.setMinWidth(p.x);
            this.scrolledDraftArea.setExpandHorizontal(true);
            this.scrolledDraftArea.setExpandVertical(true);
        }
    }

    private void createLink(Composite composite) {
        Collection files = this.fRevisionInfo.getFiles().values();
        for (FileInfo fileInfo : files) {
            if (fileInfo.getDraftComments().isEmpty()) continue;
            Link linkFile = new Link(composite, 0);
            linkFile.setToolTipText(Messages.ReplyDialog_2);
            linkFile.setText("<a>" + fileInfo.getPath() + "</a>");
            linkFile.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            linkFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileInfo fileInfo = (FileInfo)ReplyDialog.this.fRevisionInfo.getFiles().get((Object)e.text);
                    if (fileInfo != null) {
                        UIUtils.open(ReplyDialog.this.fGerritClient, fileInfo, ReplyDialog.this.fRevisionInfo.getChangeInfo(), "BASE");
                        ReplyDialog.this.cancelPressed();
                    }
                }
            });
            Iterator commentsIter = fileInfo.getDraftComments().iterator();
            StringBuilder sb = new StringBuilder();
            while (commentsIter.hasNext()) {
                CommentInfo comment = (CommentInfo)commentsIter.next();
                sb.append("\t " + comment.getLine() + "\t ");
                sb.append(String.valueOf(comment.getMessage()) + "\n");
            }
            Text commentLabel = new Text(composite, 66);
            commentLabel.setBackground(composite.getBackground());
            commentLabel.setEditable(false);
            commentLabel.setText(sb.toString());
            GridData grid = new GridData(16384, 128, true, true, 1, 1);
            commentLabel.setLayoutData((Object)grid);
        }
    }

    private void createMiddleRadioSection(Composite parent) {
        int height;
        if (this.hasDrafts(this.fRevisionInfo)) {
            Label separator = new Label(parent, 258);
            GridData sepGrid = new GridData(768);
            sepGrid.grabExcessHorizontalSpace = true;
            separator.setLayoutData((Object)sepGrid);
        }
        Composite composite = new Composite(parent, 0);
        GridLayout gl_composite = new GridLayout(3, false);
        gl_composite.marginTop = 3;
        composite.setLayout((Layout)gl_composite);
        GridData gd_composite = new GridData(4, 16384, true, false, 1, 1);
        gd_composite.minimumHeight = height = 75 + 30 * (this.permitted_labels.size() - 1);
        gd_composite.heightHint = height;
        composite.setLayoutData((Object)gd_composite);
        this.keyComposite = this.createComposite(composite, 16384, 1);
        this.radioButtonComposite = this.createComposite(composite, 0x1000000, 1);
        this.detailTextComposite = this.createComposite(composite, 16384, 1);
        this.createRadioButtonSelection();
    }

    private Composite createComposite(Composite parent, int horizontalSwt, int numColumn) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl_composite = new GridLayout(numColumn, true);
        gl_composite.marginTop = 3;
        composite.setLayout((Layout)gl_composite);
        GridData gd_composite = new GridData(horizontalSwt, 0x1000000, true, false);
        gd_composite.minimumHeight = 117;
        composite.setLayoutData((Object)gd_composite);
        return composite;
    }

    private Composite createButtonComposite(Composite composite, int maxRadio) {
        Composite radioComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(maxRadio, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginTop = 0;
        radioComposite.setLayout((Layout)gridLayout);
        return radioComposite;
    }

    private void createRadioButtonSelection() {
        int maxRadio = this.getMaxCountLabels();
        if (maxRadio <= 0) {
            return;
        }
        Composite headerLabels = this.getRadioButtonHeaderLabels(maxRadio);
        Point sizeRadio = null;
        Point fontSize = UIUtils.computeFontSize(this.detailTextComposite);
        this.getLastLabelSet();
        for (Map.Entry permittedlabel : this.permitted_labels.entrySet()) {
            EList listPermitted = (EList)permittedlabel.getValue();
            Label rowLabel = new Label(this.keyComposite, 1);
            rowLabel.setText((String)permittedlabel.getKey());
            String valueSet = this.previousVotes.get(permittedlabel.getKey());
            if (valueSet == null) {
                valueSet = "0";
            }
            int lastValue = Integer.parseInt(valueSet);
            Label detailLabel = new Label(this.detailTextComposite, 0);
            GridData grid = new GridData(4, 16384, true, false);
            grid.minimumWidth = fontSize.x * 50;
            detailLabel.setLayoutData((Object)grid);
            Composite radioComposite = this.createButtonComposite(this.radioButtonComposite, maxRadio);
            radioComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            int numEmpty = (maxRadio - listPermitted.size()) / 2;
            this.createFillerRadioButtons(numEmpty, radioComposite);
            Button[] radios = new Button[listPermitted.size()];
            int i = 0;
            while (i < listPermitted.size()) {
                radios[i] = new Button(radioComposite, 16);
                radios[i].setData(listPermitted.get(i));
                radios[i].setData((String)listPermitted.get(i), permittedlabel.getKey());
                radios[i].setData("displayWidget", (Object)detailLabel);
                String description = this.labelSelectionDescription((String)permittedlabel.getKey(), (String)listPermitted.get(i));
                radios[i].setToolTipText(description);
                if (Integer.parseInt(((String)listPermitted.get(i)).trim()) == lastValue) {
                    radios[i].setSelection(true);
                    detailLabel.setText(description);
                }
                radios[i].addListener(13, this.radioGroupListener());
                ++i;
            }
            this.createFillerRadioButtons(numEmpty, radioComposite);
            radioComposite.pack();
            sizeRadio = radioComposite.getSize();
        }
        Point headerSize = headerLabels.getSize();
        GridLayout layout = (GridLayout)headerLabels.getLayout();
        if (sizeRadio != null) {
            int space = (sizeRadio.x - headerSize.x) / layout.numColumns;
            layout.marginWidth = space / 2;
            layout.horizontalSpacing = space;
            headerLabels.setLayout((Layout)layout);
        }
    }

    private Composite getRadioButtonHeaderLabels(int maxRadioChoice) {
        EList listPermitted = null;
        for (Map.Entry permittedlabel : this.permitted_labels.entrySet()) {
            listPermitted = (EList)permittedlabel.getValue();
            if (listPermitted.size() == maxRadioChoice) break;
        }
        new Label(this.keyComposite, 0);
        new Label(this.detailTextComposite, 0);
        Composite radioComposite = this.createButtonComposite(this.radioButtonComposite, maxRadioChoice);
        radioComposite.setLayoutData((Object)new GridData(4, 4, true, true, maxRadioChoice, 1));
        if (listPermitted != null) {
            Label[] radioLabels = new Label[listPermitted.size()];
            int i = 0;
            while (i < listPermitted.size()) {
                radioLabels[i] = new Label(radioComposite, 16);
                radioLabels[i].setText((String)listPermitted.get(i));
                ++i;
            }
            radioComposite.pack();
        }
        return radioComposite;
    }

    private void createFillerRadioButtons(int num, Composite radioComposite) {
        Button[] emptyRadios = new Button[num];
        int i = 0;
        while (i < num) {
            emptyRadios[i] = new Button(radioComposite, 16);
            emptyRadios[i].setVisible(false);
            ++i;
        }
    }

    private int getMaxCountLabels() {
        int maxButtons = 0;
        int count = 0;
        for (Map.Entry permittedlabel : this.permitted_labels.entrySet()) {
            count = ((EList)permittedlabel.getValue()).size();
            maxButtons = Math.max(maxButtons, count);
        }
        return maxButtons;
    }

    private Listener radioGroupListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Widget wid = event.widget;
                Object obj = wid.getData();
                String keyLabel = (String)wid.getData((String)obj);
                String tootip = ((Button)wid).getToolTipText();
                Object objWidget = wid.getData("displayWidget");
                Label toShow = (Label)objWidget;
                toShow.setText(tootip);
                toShow.pack();
                ReplyDialog.this.previousVotes.put(keyLabel, (String)obj);
            }
        };
    }

    private String labelSelectionDescription(String key, String value) {
        String ret = "";
        if (this.labelsInfo != null && !this.labelsInfo.isEmpty()) {
            for (Map.Entry entrylabel : this.labelsInfo.entrySet()) {
                if (!((String)entrylabel.getKey()).equals(key)) continue;
                LabelInfo labelInfo = (LabelInfo)entrylabel.getValue();
                EMap mapValues = labelInfo.getValues();
                return (String)mapValues.get((Object)value);
            }
        }
        return ret;
    }

    private void getLastLabelSet() {
        if (this.labelsInfo != null && !this.labelsInfo.isEmpty()) {
            for (Map.Entry entrylabel : this.labelsInfo.entrySet()) {
                LabelInfo labelInfo = (LabelInfo)entrylabel.getValue();
                EList listApproval = labelInfo.getAll();
                if (listApproval == null || listApproval.isEmpty()) continue;
                ApprovalInfo candidate = null;
                for (ApprovalInfo oneApproval : listApproval) {
                    if (!this.fGerritClient.getRepository().getServerInfo().getUserName().equals(oneApproval.getEmail()) || candidate != null) continue;
                    candidate = oneApproval;
                }
                if (candidate == null) continue;
                this.previousVotes.put((String)entrylabel.getKey(), StringConverter.asString((Integer)candidate.getValue()));
            }
        }
    }

    public Map<String, String> getRadiosSelection() {
        return this.previousVotes;
    }
}

