/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.log;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.fx.core.log.Condition;
import org.eclipse.fx.core.log.Throttle;
import org.eclipse.jdt.annotation.NonNull;

public interface FluentLogContext {
    public FluentLogContext when(Predicate<MutableState> var1);

    public <T extends Condition> T with(Function<FluentLogContext, T> var1);

    default public FluentLogContext throttleByCount(long nTime) {
        return this.with(Throttle::new).every(nTime);
    }

    default public FluentLogContext throttleByTime(long interval, TimeUnit unit) {
        return this.with(Throttle::new).interval(interval, unit);
    }

    public FluentLogContext withException(Throwable var1);

    public void log(@NonNull CharSequence var1);

    public void log(@NonNull String var1, Object ... var2);

    public void log(@NonNull Supplier<@NonNull CharSequence> var1);

    public <T> void log(@NonNull Function<T, @NonNull CharSequence> var1, T var2);

    public static interface MutableState {
        public long currentCallCount();

        public long lastLogTime();

        public long lastLogCount();
    }
}

