/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fx.ide.rrobot.impl.JDTProjectHandler;
import org.eclipse.fx.ide.rrobot.model.bundle.BundlePackage;
import org.eclipse.fx.ide.rrobot.model.bundle.BundleProject;
import org.eclipse.fx.ide.rrobot.model.task.File;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.pde.internal.core.ClasspathComputer;

public class BundleProjectHandler
extends JDTProjectHandler<BundleProject> {
    @Override
    public boolean isHandled(EClass eClass) {
        return eClass == BundlePackage.Literals.BUNDLE_PROJECT;
    }

    @Override
    public IStatus createProject(IProgressMonitor monitor, BundleProject project, Map<String, Object> additionalData) {
        return super.createProject(monitor, project, additionalData);
    }

    @Override
    protected IStatus customizeProject(IProgressMonitor monitor, IProject project, BundleProject model) {
        IStatus s = super.customizeProject(monitor, project, model);
        if (!s.isOK()) {
            return s;
        }
        try {
            BundleProjectHandler.addNatureToProject(project, "org.eclipse.pde.PluginNature", monitor);
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.fx.ide.rrobot", "Unable to add nature", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IClasspathEntry[] createClasspathEntries(BundleProject model) {
        IClasspathEntry[] entries = new IClasspathEntry[]{ClasspathComputer.createJREEntry((String)model.getManifest().getExecutionEnvironment()), ClasspathComputer.createContainerEntry()};
        return entries;
    }

    @Override
    protected IStatus createResources(IProgressMonitor monitor, IProject p, BundleProject model, Map<String, Object> additionalData) {
        IStatus s = super.createResources(monitor, p, model, additionalData);
        if (s.isOK()) {
            ArrayList<Object> rv = new ArrayList<Object>();
            rv.add(s);
            IFolder f = p.getFolder("META-INF");
            if (!f.exists()) {
                try {
                    f.create(true, true, monitor);
                }
                catch (CoreException e) {
                    rv.add(new Status(4, "org.eclipse.fx.ide.rrobot", "Failed to create folder 'META-INF'", (Throwable)e));
                }
            }
            rv.add(this.createFile(monitor, f.getFile("MANIFEST.MF"), (File)model.getManifest(), additionalData));
            if (model.getPluginxml() != null) {
                rv.add(this.createFile(monitor, p.getFile("plugin.xml"), (File)model.getPluginxml(), additionalData));
            }
            rv.add(this.createFile(monitor, p.getFile("build.properties"), (File)model.getBuildProperties(), additionalData));
            return new MultiStatus("org.eclipse.fx.ide.rrobot", 0, rv.toArray(new IStatus[0]), "File creation states", null);
        }
        return s;
    }
}

