/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.filesystem;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import org.eclipse.fx.ui.controls.filesystem.DirItem;
import org.eclipse.fx.ui.controls.filesystem.IconSize;
import org.eclipse.fx.ui.controls.filesystem.ResourceEvent;
import org.eclipse.fx.ui.controls.filesystem.ResourceItem;
import org.eclipse.fx.ui.controls.filesystem.skin.DirectoryViewSkin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DirectoryView
extends Control {
    private final @NonNull ObjectProperty<@Nullable DirItem> dir = new SimpleObjectProperty((Object)this, "dir");
    private final @NonNull ObjectProperty<@NonNull DisplayType> displayType = new SimpleObjectProperty((Object)this, "displayType", (Object)DisplayType.LIST);
    private final @NonNull ObjectProperty<@NonNull IconSize> iconSize = new SimpleObjectProperty((Object)this, "iconSize", (Object)IconSize.SMALL);
    private final @NonNull ObjectProperty<@Nullable EventHandler<@NonNull ResourceEvent<@NonNull ResourceItem>>> onOpenResource = new ObjectPropertyBase<EventHandler<ResourceEvent<ResourceItem>>>(){

        protected void invalidated() {
            DirectoryView.this.setEventHandler(ResourceEvent.openResourceEvent(), (EventHandler)this.get());
        }

        public Object getBean() {
            return DirectoryView.this;
        }

        public String getName() {
            return "onOpenResource";
        }
    };
    private @NonNull ObservableList<@NonNull ResourceItem> selectedItems = FXCollections.observableArrayList();
    private @NonNull ObservableList<@NonNull ResourceItem> unmodifiableItemsPaths = FXCollections.unmodifiableObservableList(this.selectedItems);

    public final String getUserAgentStylesheet() {
        return DirectoryView.class.getResource("skin/default.css").toExternalForm();
    }

    public final @NonNull ObjectProperty<@Nullable DirItem> dirProperty() {
        return this.dir;
    }

    public final @Nullable DirItem getDir() {
        return (DirItem)this.dirProperty().get();
    }

    public final void setDir(@Nullable DirItem dir) {
        this.dirProperty().set((Object)dir);
    }

    public final @NonNull ObjectProperty<@NonNull DisplayType> displayTypeProperty() {
        return this.displayType;
    }

    public final @NonNull DisplayType getDisplayType() {
        return (DisplayType)((Object)this.displayTypeProperty().get());
    }

    public final void setDisplayType(@NonNull DisplayType displayType) {
        this.displayTypeProperty().set((Object)displayType);
    }

    public final @NonNull ObjectProperty<@NonNull IconSize> iconSizeProperty() {
        return this.iconSize;
    }

    public final @NonNull IconSize getIconSize() {
        return (IconSize)((Object)this.iconSizeProperty().get());
    }

    public final void setIconSize(@NonNull IconSize iconSize) {
        this.iconSizeProperty().set((Object)iconSize);
    }

    public final @NonNull ObjectProperty<@Nullable EventHandler<@NonNull ResourceEvent<@NonNull ResourceItem>>> onOpenResourceProperty() {
        return this.onOpenResource;
    }

    public final @Nullable EventHandler<@NonNull ResourceEvent<@NonNull ResourceItem>> getOnOpenResource() {
        return (EventHandler)this.onOpenResourceProperty().get();
    }

    public final void setOnOpenResource(@Nullable EventHandler<@NonNull ResourceEvent<@NonNull ResourceItem>> onOpenResource) {
        this.onOpenResourceProperty().set(onOpenResource);
    }

    protected Skin<?> createDefaultSkin() {
        return new DirectoryViewSkin(this, this.selectedItems);
    }

    public @NonNull ObservableList<@NonNull ResourceItem> getSelectedItems() {
        return this.unmodifiableItemsPaths;
    }

    public static enum DisplayType {
        LIST;

    }
}

