/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.collection.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.LongBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import org.eclipse.fx.core.collection.IndexRangeView;
import org.eclipse.fx.core.collection.IndexView;
import org.eclipse.fx.core.collection.VirtualList;
import org.eclipse.fx.core.observable.FXObservableUtil;
import org.eclipse.jdt.annotation.Nullable;

public class VirtualObservableList<@Nullable T>
implements VirtualList<T> {
    final ObservableList<T> list;
    private final ReadOnlyLongWrapper length = new ReadOnlyLongWrapper();

    public VirtualObservableList(ObservableList<T> list) {
        this.list = list;
        this.length.bind((ObservableValue)Bindings.size(list));
    }

    @Override
    public ObservableLongValue length() {
        return this.length.getReadOnlyProperty();
    }

    @Override
    public T get(long index) {
        return (T)this.list.get((int)index);
    }

    @Override
    public IndexView<T> getView(long index) {
        return new ValueViewImpl((int)index);
    }

    @Override
    public IndexRangeView<T> getView(long startIndex, int length) {
        return new ListViewImpl(startIndex, length);
    }

    class ListViewImpl
    extends ObservableListBase<T>
    implements IndexRangeView<T> {
        private final ObservableList<T> data = FXCollections.observableArrayList();
        private final ListChangeListener<T> listener;
        final ReadOnlyLongWrapper startIndex;
        final ReadOnlyIntegerWrapper length;

        public ListViewImpl(long startIndex, int length) {
            this.startIndex = new ReadOnlyLongWrapper(startIndex);
            FXObservableUtil.onInvalidate((Observable)this.startIndex, v -> this.updateList());
            this.length = new ReadOnlyIntegerWrapper(length);
            FXObservableUtil.onInvalidate((Observable)this.length, v -> this.updateList());
            FXObservableUtil.onInvalidate(VirtualObservableList.this.list, o -> this.updateList());
            this.listener = c -> this.fireChange(new SourceChangeEvent(this, c));
            this.data.addListener(this.listener);
            this.updateList();
        }

        private void updateList() {
            ArrayList list = new ArrayList(this.size());
            if (this.startIndex.get() < (long)VirtualObservableList.this.list.size()) {
                list.addAll(VirtualObservableList.this.list.subList((int)this.startIndex.get(), (int)Math.min(this._endIndex() + 1L, (long)VirtualObservableList.this.list.size())));
            }
            if (list.size() < this.size()) {
                int i = list.size();
                while (i < this.size()) {
                    list.add(null);
                    ++i;
                }
            }
            if (!list.equals(this.data)) {
                this.data.setAll(list);
            }
        }

        @Override
        public void moveBy(long delta) {
            this.startIndex.set(Math.max(0L, this.startIndex.get() + delta));
        }

        @Override
        public void shrinkBy(int delta) {
            if (delta > 0) {
                this.length.set(Math.max(0, this.length.get() - delta));
            }
        }

        @Override
        public void growBy(int delta) {
            if (delta > 0) {
                this.length.set(Math.max(0, this.length.get() + delta));
            }
        }

        @Override
        public ObservableLongValue startIndex() {
            return this.startIndex.getReadOnlyProperty();
        }

        long _endIndex() {
            return this.startIndex.get() + (long)this.length.get() - 1L;
        }

        @Override
        public ObservableLongValue endIndex() {
            return new LongBinding(){
                {
                    this.bind(new Observable[]{ListViewImpl.this.startIndex, ListViewImpl.this.length});
                }

                protected long computeValue() {
                    return ListViewImpl.this._endIndex();
                }
            };
        }

        @Override
        public ObservableIntegerValue length() {
            return this.length.getReadOnlyProperty();
        }

        public T get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (index < this.data.size()) {
                return this.data.get(index);
            }
            return null;
        }

        public int size() {
            return this.length.get();
        }
    }

    static class SourceChangeEvent<T>
    extends ListChangeListener.Change<T> {
        private final ListChangeListener.Change<? extends T> change;
        private final Method getPermutation;

        public SourceChangeEvent(ObservableList<T> list, ListChangeListener.Change<? extends T> change) {
            super(list);
            this.change = change;
            try {
                this.getPermutation = ListChangeListener.Change.class.getDeclaredMethod("getPermutation", new Class[0]);
                this.getPermutation.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean next() {
            return this.change.next();
        }

        public void reset() {
            this.change.reset();
        }

        public int getFrom() {
            return this.change.getFrom();
        }

        public int getTo() {
            return this.change.getTo();
        }

        public List<T> getRemoved() {
            return this.change.getRemoved();
        }

        protected int[] getPermutation() {
            try {
                return (int[])this.getPermutation.invoke(this.change, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean wasUpdated() {
            return this.change.wasUpdated();
        }
    }

    class ValueViewImpl
    extends ReadOnlyObjectWrapper<T>
    implements IndexView<T> {
        private final ReadOnlyLongWrapper index;
        private ObjectBinding<T> indexValue;

        public ValueViewImpl(int index) {
            this.index = new ReadOnlyLongWrapper((long)index);
            this.indexValue = Bindings.valueAt(VirtualObservableList.this.list, (ObservableNumberValue)this.index);
            this.bind((ObservableValue)this.indexValue);
        }

        @Override
        public ObservableLongValue index() {
            return this.index.getReadOnlyProperty();
        }

        @Override
        public void moveBy(long delta) {
            this.index.set(Math.max(0L, this.index.get() + delta));
        }
    }
}

