/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConcurrentUtils {
    @SafeVarargs
    public static <T> CompletableFuture<List<T>> collect(CompletableFuture<T> ... futures) {
        return CompletableFuture.allOf(futures).thenApply(v -> Stream.of(futures).map(f -> f.join()).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T, O> CompletableFuture<List<T>> collect(Function<O, T> transformer, CompletableFuture<O> ... futures) {
        return CompletableFuture.allOf(futures).thenApply(v -> Stream.of(futures).map(f -> f.join()).map(transformer::apply).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> CompletableFuture<List<T>> collectLists(CompletableFuture<List<T>> ... futures) {
        return CompletableFuture.allOf(futures).thenApply(v -> Stream.of(futures).flatMap(f -> ((List)f.join()).stream()).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T, O> CompletableFuture<List<T>> collectLists(Function<O, T> transformer, CompletableFuture<List<O>> ... futures) {
        return CompletableFuture.allOf(futures).thenApply(v -> Stream.of(futures).flatMap(f -> ((List)f.join()).stream()).map(transformer::apply).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T, O> CompletableFuture<List<T>> collectWithStream(Function<Stream<O>, Stream<T>> streamTransformer, CompletableFuture<O> ... futures) {
        return CompletableFuture.allOf(futures).thenApply(v -> ((Stream)streamTransformer.apply(Stream.of(futures).map(f -> f.join()))).collect(Collectors.toList()));
    }
}

